/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.LockingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerAdminPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 4712657652337914993L;

    public IModel getGeoServerModel() {
        return new LoadableDetachableModel(){

            public Object load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer();
            }
        };
    }

    public IModel getGlobalInfoModel() {
        return new LoadableDetachableModel(){

            public Object load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer().getGlobal();
            }
        };
    }

    public IModel getJAIModel() {
        return new LoadableDetachableModel(){

            public Object load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer().getGlobal().getJAI();
            }
        };
    }

    public IModel getCoverageAccessModel() {
        return new LoadableDetachableModel(){

            public Object load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer().getGlobal().getCoverageAccess();
            }
        };
    }

    public IModel getContactInfoModel() {
        return new LoadableDetachableModel(){

            public Object load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer().getGlobal().getContact();
            }
        };
    }

    public IModel getLoggingInfoModel() {
        return new LoadableDetachableModel(){

            protected Object load() {
                return ServerAdminPage.this.getGeoServer().getLogging();
            }
        };
    }

    private synchronized int getLockCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            if (!meta.isEnabled()) continue;
            try {
                LockingManager lockingManager;
                DataAccess store = meta.getDataStore(null);
                if (store instanceof DataStore && (lockingManager = ((DataStore)store).getLockingManager()) == null) continue;
            }
            catch (IllegalStateException notAvailable) {
            }
            catch (Throwable huh) {}
        }
        return count;
    }

    private synchronized int getConnectionCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            if (!meta.isEnabled()) continue;
            try {
                meta.getDataStore(null);
            }
            catch (Throwable notAvailable) {
                continue;
            }
            ++count;
        }
        return count;
    }

    private List<DataStoreInfo> getDataStores() {
        return this.getGeoServerApplication().getGeoServer().getCatalog().getDataStores();
    }
}

