/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerSecuredPage;

public class LogPage
extends GeoServerSecuredPage {
    static final String LINES = "lines";
    int lines = 1000;
    File logFile;

    public LogPage(PageParameters params) {
        Form form = new Form("form");
        this.add(new Component[]{form});
        String location = GeoServerExtensions.getProperty((String)"GEOSERVER_LOG_LOCATION");
        if (location == null) {
            location = this.getGeoServerApplication().getGeoServer().getLogging().getLocation();
        }
        this.logFile = new File(location);
        if (!this.logFile.isAbsolute()) {
            GeoServerDataDirectory dd = this.getGeoServerApplication().getBeanOfType(GeoServerDataDirectory.class);
            this.logFile = new File(dd.root(), this.logFile.getPath());
        }
        if (!this.logFile.exists()) {
            this.error((Serializable)((Object)("Could not find the GeoServer log file: " + this.logFile.getAbsolutePath())));
        }
        try {
            if (params.getKey(LINES) != null && params.getInt(LINES) > 0) {
                this.lines = params.getInt(LINES);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error parsing the lines parameter: ", params.getKey(LINES));
        }
        form.add(new Component[]{new SubmitLink("refresh"){

            public void onSubmit() {
                this.setResponsePage(LogPage.class, new PageParameters("lines=" + String.valueOf(LogPage.this.lines)));
            }
        }});
        TextField lines = new TextField(LINES, (IModel)new PropertyModel((Object)this, LINES));
        lines.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{lines});
        TextArea logs = new TextArea("logs", (IModel)new GSLogsModel());
        logs.setOutputMarkupId(true);
        logs.setMarkupId("logs");
        this.add(new Component[]{logs});
        this.add(new Component[]{new Link("download"){

            public void onClick() {
                RequestCycle.get().setRequestTarget(new IRequestTarget(){

                    public void detach(RequestCycle requestCycle) {
                    }

                    public void respond(RequestCycle requestCycle) {
                        InputStream is = null;
                        try {
                            is = new FileInputStream(LogPage.this.logFile);
                            WebResponse r = (WebResponse)requestCycle.getResponse();
                            r.setAttachmentHeader("geoserver.log");
                            r.setContentType("text/plain");
                            Streams.copy((InputStream)is, (OutputStream)r.getOutputStream());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                });
            }
        }});
    }

    public class GSLogsModel
    extends LoadableDetachableModel {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object load() {
            BufferedReader br = null;
            try {
                String line;
                LinkedList<String> lineList = new LinkedList<String>();
                br = new BufferedReader(new FileReader(LogPage.this.logFile));
                while ((line = br.readLine()) != null) {
                    lineList.addLast(line);
                    if (lineList.size() <= LogPage.this.lines) continue;
                    lineList.removeFirst();
                }
                StringBuilder result = new StringBuilder();
                for (String logLine : lineList) {
                    result.append(logLine).append("\n");
                }
                StringBuilder stringBuilder = result;
                return stringBuilder;
            }
            catch (Exception e) {
                LogPage.this.error(e);
                String string = e.getMessage();
                return string;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

