/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.Component;
import org.apache.wicket.IResponseFilter;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHTMLValidatorResponseFilter;

public class DeveloperToolbar
extends Panel {
    private AjaxCheckBox wicketIds;
    private AjaxCheckBox xhtml;

    public DeveloperToolbar(String id) {
        super(id);
        this.add(new Component[]{new IndicatingAjaxLink("clearCache"){

            public void onClick(AjaxRequestTarget target) {
                GeoServerApplication.get().clearWicketCaches();
            }
        }});
        this.add(new Component[]{new IndicatingAjaxLink("reload"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(AjaxRequestTarget target) {
                try {
                    GeoServerLoader loader = (GeoServerLoader)GeoServerApplication.get().getBean("geoServerLoader");
                    Object object = GeoServer.CONFIGURATION_LOCK;
                    synchronized (object) {
                        loader.reload();
                    }
                    this.info("Catalog and configuration reloaded");
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        GeoServerApplicationModel gsApp = new GeoServerApplicationModel();
        final AjaxCheckBox wicketPaths = new AjaxCheckBox("wicketPaths", (IModel)new PropertyModel((Object)gsApp, "debugSettings.outputComponentPath")){

            protected void onUpdate(AjaxRequestTarget target) {
            }
        };
        wicketPaths.setOutputMarkupId(true);
        this.add(new Component[]{wicketPaths});
        this.xhtml = new AjaxCheckBox("xhtml", new XHTMLModel()){

            protected void onUpdate(AjaxRequestTarget target) {
                DeveloperToolbar.this.wicketIds.setModelObject((Object)Boolean.TRUE);
                wicketPaths.setModelObject((Object)Boolean.FALSE);
                target.addComponent((Component)DeveloperToolbar.this.wicketIds);
                target.addComponent((Component)wicketPaths);
            }
        };
        this.add(new Component[]{this.xhtml});
        this.wicketIds = new AjaxCheckBox("wicketIds", (IModel)new PropertyModel((Object)gsApp, "markupSettings.stripWicketTags")){

            protected void onUpdate(AjaxRequestTarget target) {
                wicketPaths.setModelObject((Object)Boolean.FALSE);
                target.addComponent((Component)wicketPaths);
            }
        };
        this.wicketIds.setOutputMarkupId(true);
        this.add(new Component[]{this.wicketIds});
        this.add(new Component[]{new AjaxCheckBox("ajaxDebug", (IModel)new PropertyModel((Object)gsApp, "debugSettings.ajaxDebugModeEnabled")){

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
    }

    static class XHTMLModel
    implements IModel {
        XHTMLModel() {
        }

        public Object getObject() {
            GeoServerApplication app = GeoServerApplication.get();
            boolean enabled = false;
            for (IResponseFilter filter : app.getRequestCycleSettings().getResponseFilters()) {
                if (!(filter instanceof GeoServerHTMLValidatorResponseFilter)) continue;
                enabled = ((GeoServerHTMLValidatorResponseFilter)filter).enabled;
            }
            return enabled;
        }

        public void setObject(Object object) {
            GeoServerApplication app = GeoServerApplication.get();
            for (IResponseFilter filter : app.getRequestCycleSettings().getResponseFilters()) {
                if (!(filter instanceof GeoServerHTMLValidatorResponseFilter)) continue;
                ((GeoServerHTMLValidatorResponseFilter)filter).enabled = (Boolean)object;
            }
        }

        public void detach() {
        }
    }

    static class GeoServerApplicationModel
    extends LoadableDetachableModel {
        GeoServerApplicationModel() {
            super((Object)GeoServerApplication.get());
        }

        protected Object load() {
            return GeoServerApplication.get();
        }
    }
}

