/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.List;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wcs.kvp.Wcs10KvpParser;
import org.geotools.geometry.GeneralEnvelope;
import org.vfny.geoserver.wcs.WcsException;

public class BBoxKvpParser
extends Wcs10KvpParser {
    public BBoxKvpParser() {
        super("bbox", GeneralEnvelope.class);
    }

    public GeneralEnvelope parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        int size = unparsed.size();
        if (unparsed.size() != 4) {
            throw new WcsException("Requested bounding box contains wrongnumber of coordinates: " + unparsed.size(), WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        double[] bbox = new double[size];
        for (int i = 0; i < size; ++i) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new WcsException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i), WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
            }
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double maxx = bbox[2];
        double maxy = bbox[3];
        if (minx > maxx) {
            throw new WcsException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx, WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        if (miny > maxy) {
            throw new WcsException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy, WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        GeneralEnvelope envelope = new GeneralEnvelope(size / 2);
        envelope.setEnvelope(new double[]{minx, miny, maxx, maxy});
        return envelope;
    }
}

