/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.GCP;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOStreamMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GDALImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger(GDALImageReader.class.toString());
    private String[] datasetNames;
    private int nSubdatasets = -1;
    private ImageInputStream imageInputStream;
    private volatile boolean isInitialized = false;
    private ImageTypeSpecifier imageType = null;
    private File datasetSource = null;
    private URI uriSource = null;
    private Map<String, GDALCommonIIOImageMetadata> datasetMetadataMap = Collections.synchronizedMap(new HashMap());

    @Override
    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input, seekForwardOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDALCommonIIOImageMetadata getDatasetMetadata(int imageIndex) {
        this.checkImageIndex(imageIndex);
        String datasetName = this.datasetNames[imageIndex];
        Map<String, GDALCommonIIOImageMetadata> map = this.datasetMetadataMap;
        synchronized (map) {
            if (this.datasetMetadataMap.containsKey(datasetName)) {
                return this.datasetMetadataMap.get(datasetName);
            }
            GDALCommonIIOImageMetadata datasetMetadata = this.createDatasetMetadata(datasetName);
            this.datasetMetadataMap.put(datasetName, datasetMetadata);
            return datasetMetadata;
        }
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider, int numSubdatasets) {
        super(originatingProvider);
        if (numSubdatasets < 0) {
            throw new IllegalArgumentException("The provided number of sub datasets is invalid");
        }
        this.nSubdatasets = numSubdatasets;
    }

    protected void checkImageIndex(int imageIndex) {
        this.initialize();
        if (imageIndex < 0 || imageIndex > this.nSubdatasets) {
            int maxImageIndex = this.nSubdatasets;
            StringBuilder sb = new StringBuilder("Illegal imageIndex specified = ").append(imageIndex).append(", while the valid imageIndex");
            if (maxImageIndex > 0) {
                sb.append(" range should be (0,").append(maxImageIndex).append(")!!");
            } else {
                sb.append(" should be 0!");
            }
            throw new IndexOutOfBoundsException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initialize() {
        block19: {
            if (!GDALUtilities.isGDALAvailable()) {
                throw new IllegalStateException("GDAL native libraries are not available.");
            }
            var1_1 = this.datasetMetadataMap;
            synchronized (var1_1) {
                block18: {
                    block20: {
                        block17: {
                            if (this.isInitialized) break block19;
                            mainDatasetName = "";
                            datainput = super.getInput();
                            if (!(datainput instanceof URIImageInputStream)) {
                                mainDatasetName = this.getDatasetSource(datainput).getAbsolutePath();
                            } else {
                                uri = ((URIImageInputStream)datainput).getUri();
                                if (uri != null) {
                                    mainDatasetName = uri.toString();
                                }
                            }
                            mainDataset = null;
                            try {
                                mainDataset = GDALUtilities.acquireDataSet(mainDatasetName, gdalconstConstants.GA_ReadOnly);
                                if (mainDataset == null) {
                                    var5_5 = false;
                                    var10_7 = null;
                                    if (mainDataset == null) return var5_5;
                                    break block17;
                                }
                                subdatasets = mainDataset.GetMetadata_List("SUBDATASETS");
                                this.nSubdatasets = subdatasets.size() / 2;
                                if (this.nSubdatasets == 0) {
                                    this.nSubdatasets = 1;
                                    this.datasetNames = new String[1];
                                    this.datasetNames[0] = mainDatasetName;
                                    myItem = this.createDatasetMetadata(this.datasetNames[0]);
                                    this.datasetMetadataMap.put(this.datasetNames[0], myItem);
                                } else {
                                    this.datasetNames = new String[this.nSubdatasets + 1];
                                    for (i = 0; i < this.nSubdatasets; ++i) {
                                        subdatasetName = subdatasets.get(i * 2).toString();
                                        nameStartAt = subdatasetName.lastIndexOf("_NAME=") + 6;
                                        this.datasetNames[i] = subdatasetName.substring(nameStartAt);
                                    }
                                    this.datasetNames[this.nSubdatasets] = mainDatasetName;
                                    this.datasetMetadataMap.put(mainDatasetName, this.createDatasetMetadata(mainDataset, mainDatasetName));
                                    subdatasets.clear();
                                }
                                this.isInitialized = true;
                                break block18;
                            }
                            catch (Throwable var9_17) {
                                var10_9 = null;
                                if (mainDataset == null) throw var9_17;
                                try {
                                    GDALUtilities.closeDataSet(mainDataset);
                                    throw var9_17;
                                }
                                catch (Throwable e) {
                                    if (GDALImageReader.LOGGER.isLoggable(Level.FINEST) == false) throw var9_17;
                                    GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                                throw var9_17;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [3 : 323->331)] { 
lbl59:
                        // 1 sources

                        GDALUtilities.closeDataSet(mainDataset);
                        break block20;
lbl61:
                        // 1 sources

                        catch (Throwable e) {
                            if (GDALImageReader.LOGGER.isLoggable(Level.FINEST) == false) return var5_5;
                            GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                    return var5_5;
                }
                var10_8 = null;
                if (mainDataset != null) {
                    ** try [egrp 2[TRYBLOCK] [3 : 323->331)] { 
lbl70:
                    // 1 sources

                    GDALUtilities.closeDataSet(mainDataset);
lbl72:
                    // 1 sources

                    catch (Throwable e) {
                        if (!GDALImageReader.LOGGER.isLoggable(Level.FINEST)) break block19;
                        GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        if (this.nSubdatasets <= 0) return false;
        return true;
    }

    protected GDALCommonIIOImageMetadata createDatasetMetadata(String datasetName) {
        return new GDALCommonIIOImageMetadata(datasetName);
    }

    protected GDALCommonIIOImageMetadata createDatasetMetadata(Dataset mainDataset, String mainDatasetFileName) {
        return new GDALCommonIIOImageMetadata(mainDataset, mainDatasetFileName, false);
    }

    private Raster readDatasetRaster(GDALCommonIIOImageMetadata item, Rectangle srcRegion, Rectangle dstRegion, int[] selectedBands) throws IOException {
        return this.readDatasetRaster(item, srcRegion, dstRegion, selectedBands, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Raster readDatasetRaster(GDALCommonIIOImageMetadata item, Rectangle srcRegion, Rectangle dstRegion, int[] selectedBands, SampleModel destSampleModel) throws IOException {
        block56: {
            destSm = destSampleModel != null ? destSampleModel : item.getSampleModel();
            sampleModel /* !! */  = null;
            imgBuffer /* !! */  = null;
            datasetName = item.getDatasetName();
            dataset = GDALUtilities.acquireDataSet(datasetName, gdalconst.GA_ReadOnly);
            pBand = null;
            if (dataset == null) {
                throw new IOException("Error while acquiring the input dataset " + datasetName);
            }
            try {
                dstWidth = dstRegion.width;
                dstHeight = dstRegion.height;
                srcRegionXOffset = srcRegion.x;
                srcRegionYOffset = srcRegion.y;
                srcRegionWidth = srcRegion.width;
                srcRegionHeight = srcRegion.height;
                if (GDALImageReader.LOGGER.isLoggable(Level.FINE)) {
                    GDALImageReader.LOGGER.fine("SourceRegion = " + srcRegion.toString());
                }
                nBands = selectedBands != null ? selectedBands.length : destSm.getNumBands();
                banks = new int[nBands];
                offsets = new int[nBands];
                pixels = dstWidth * dstHeight;
                bufferType = 0;
                bufferSize = 0;
                pBand = dataset.GetRasterBand(1);
                bufferType = pBand.getDataType();
                typeSizeInBytes = gdal.GetDataTypeSize((int)bufferType) / 8;
                bufferSize = nBands * pixels * typeSizeInBytes;
                splitBands = false;
                if (bufferSize < 0 || destSm instanceof BandedSampleModel) {
                    bufferSize = pixels * typeSizeInBytes;
                    splitBands = true;
                }
                dataBufferType = -1;
                byteBands = new byte[nBands][];
                for (k = 0; k < nBands && (k <= 0 || splitBands); ++k) {
                    dataBuffer = new byte[bufferSize];
                    if (!splitBands) {
                        if (selectedBands != null) {
                            bandsMap = new int[nBands];
                            for (i = 0; i < nBands; ++i) {
                                bandsMap[i] = selectedBands[i] + 1;
                            }
                            returnVal = dataset.ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, nBands, bandsMap, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, typeSizeInBytes, dataBuffer);
                        } else {
                            returnVal = dataset.ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, nBands, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, typeSizeInBytes, dataBuffer);
                        }
                        byteBands[k] = dataBuffer;
                    } else {
                        rBand = null;
                        try {
                            rBand = dataset.GetRasterBand(k + 1);
                            returnVal = rBand.ReadRaster_Direct(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, dataBuffer);
                            byteBands[k] = dataBuffer;
                            var34_48 = null;
                            ** if (rBand == null) goto lbl-1000
                        }
                        catch (Throwable var33_50) {
                            block55: {
                                var34_48 = null;
                                if (rBand != null) {
                                    try {
                                        rBand.delete();
                                    }
                                    catch (Throwable e) {
                                        if (!GDALImageReader.LOGGER.isLoggable(Level.FINEST)) break block55;
                                        GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                    }
                                }
                            }
                            throw var33_50;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                rBand.delete();
                            }
                            catch (Throwable e) {
                                if (GDALImageReader.LOGGER.isLoggable(Level.FINEST)) {
                                    GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                        }
lbl-1000:
                        // 4 sources

                        {
                        }
                    }
                    if (returnVal == gdalconstConstants.CE_None) {
                        if (!splitBands) {
                            for (band = 0; band < nBands; ++band) {
                                banks[band] = band;
                                offsets[band] = band;
                            }
                            continue;
                        }
                        banks[k] = k;
                        offsets[k] = 0;
                        continue;
                    }
                    GDALImageReader.LOGGER.info("Last error: " + gdal.GetLastErrorMsg());
                    GDALImageReader.LOGGER.info("Last error number: " + gdal.GetLastErrorNo());
                    GDALImageReader.LOGGER.info("Last error type: " + gdal.GetLastErrorType());
                    GDALUtilities.closeDataSet(dataset);
                    throw new RuntimeException(gdal.GetLastErrorMsg());
                }
                if (bufferType == gdalconstConstants.GDT_Byte) {
                    imgBuffer /* !! */  = splitBands == false ? new DataBufferByte(byteBands[0], nBands * pixels) : new DataBufferByte(byteBands, pixels);
                    dataBufferType = 0;
                } else {
                    bands = new ByteBuffer[nBands];
                    for (k = 0; splitBands && k < nBands || k < 1 && !splitBands; ++k) {
                        bands[k] = ByteBuffer.wrap(byteBands[k], 0, byteBands[k].length);
                    }
                    if (bufferType == gdalconstConstants.GDT_Int16 || bufferType == gdalconstConstants.GDT_UInt16) {
                        if (!splitBands) {
                            shorts = new short[nBands * pixels];
                            bands[0].order(ByteOrder.nativeOrder());
                            buff = bands[0].asShortBuffer();
                            buff.get(shorts, 0, nBands * pixels);
                            imgBuffer /* !! */  = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, nBands * pixels) : new DataBufferUShort(shorts, nBands * pixels);
                        } else {
                            shorts = new short[nBands][];
                            for (i = 0; i < nBands; ++i) {
                                shorts[i] = new short[pixels];
                                bands[i].order(ByteOrder.nativeOrder());
                                bands[i].asShortBuffer().get(shorts[i], 0, pixels);
                            }
                            imgBuffer /* !! */  = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, pixels) : new DataBufferUShort(shorts, pixels);
                        }
                        dataBufferType = bufferType == gdalconstConstants.GDT_UInt16 ? 1 : 2;
                    } else if (bufferType == gdalconstConstants.GDT_Int32 || bufferType == gdalconstConstants.GDT_UInt32) {
                        if (!splitBands) {
                            ints = new int[nBands * pixels];
                            bands[0].order(ByteOrder.nativeOrder());
                            buff = bands[0].asIntBuffer();
                            buff.get(ints, 0, nBands * pixels);
                            imgBuffer /* !! */  = new DataBufferInt(ints, nBands * pixels);
                        } else {
                            ints = new int[nBands][];
                            for (i = 0; i < nBands; ++i) {
                                ints[i] = new int[pixels];
                                bands[i].order(ByteOrder.nativeOrder());
                                bands[i].asIntBuffer().get(ints[i], 0, pixels);
                            }
                            imgBuffer /* !! */  = new DataBufferInt(ints, pixels);
                        }
                        dataBufferType = 3;
                    } else if (bufferType == gdalconstConstants.GDT_Float32) {
                        if (!splitBands) {
                            floats = new float[nBands * pixels];
                            bands[0].order(ByteOrder.nativeOrder());
                            buff = bands[0].asFloatBuffer();
                            buff.get(floats, 0, nBands * pixels);
                            imgBuffer /* !! */  = new DataBufferFloat(floats, nBands * pixels);
                        } else {
                            floats = new float[nBands][];
                            for (i = 0; i < nBands; ++i) {
                                floats[i] = new float[pixels];
                                bands[i].order(ByteOrder.nativeOrder());
                                bands[i].asFloatBuffer().get(floats[i], 0, pixels);
                            }
                            imgBuffer /* !! */  = new DataBufferFloat(floats, pixels);
                        }
                        dataBufferType = 4;
                    } else if (bufferType == gdalconstConstants.GDT_Float64) {
                        if (!splitBands) {
                            doubles = new double[nBands * pixels];
                            bands[0].order(ByteOrder.nativeOrder());
                            buff = bands[0].asDoubleBuffer();
                            buff.get(doubles, 0, nBands * pixels);
                            imgBuffer /* !! */  = new DataBufferDouble(doubles, nBands * pixels);
                        } else {
                            doubles = new double[nBands][];
                            for (i = 0; i < nBands; ++i) {
                                doubles[i] = new double[pixels];
                                bands[i].order(ByteOrder.nativeOrder());
                                bands[i].asDoubleBuffer().get(doubles[i], 0, pixels);
                            }
                            imgBuffer /* !! */  = new DataBufferDouble(doubles, pixels);
                        }
                        dataBufferType = 5;
                    } else {
                        GDALImageReader.LOGGER.info("The specified data type is actually unsupported: " + bufferType);
                    }
                }
                sampleModel /* !! */  = splitBands ? new BandedSampleModel(dataBufferType, dstWidth, dstHeight, dstWidth, banks, offsets) : new PixelInterleavedSampleModel(dataBufferType, dstWidth, dstHeight, nBands, dstWidth * nBands, offsets);
                var37_51 = null;
                if (pBand == null) break block56;
            }
            catch (Throwable var36_55) {
                block58: {
                    block57: {
                        var37_52 = null;
                        if (pBand != null) {
                            try {
                                pBand.delete();
                            }
                            catch (Throwable e) {
                                if (!GDALImageReader.LOGGER.isLoggable(Level.FINEST)) break block57;
                                GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                    }
                    if (dataset != null) {
                        try {
                            GDALUtilities.closeDataSet(dataset);
                        }
                        catch (Throwable e) {
                            if (!GDALImageReader.LOGGER.isLoggable(Level.FINEST)) break block58;
                            GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                    }
                }
                throw var36_55;
            }
            try {
                pBand.delete();
            }
            catch (Throwable e) {
                if (!GDALImageReader.LOGGER.isLoggable(Level.FINEST)) break block56;
                GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
            }
        }
        if (dataset != null) {
            try {
                GDALUtilities.closeDataSet(dataset);
            }
            catch (Throwable e) {
                if (GDALImageReader.LOGGER.isLoggable(Level.FINEST)) {
                    GDALImageReader.LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
        return Raster.createWritableRaster(sampleModel /* !! */ , imgBuffer /* !! */ , null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getDatasetSource(Object myInput) {
        if (this.datasetSource != null) return this.datasetSource;
        if (myInput instanceof File) {
            this.datasetSource = (File)myInput;
            return this.datasetSource;
        } else if (myInput instanceof FileImageInputStreamExt) {
            this.datasetSource = ((FileImageInputStreamExt)myInput).getFile();
            return this.datasetSource;
        } else {
            if (!(this.input instanceof URL)) throw new RuntimeException("Unable to retrieve the Data Source for the provided input");
            URL tempURL = (URL)this.input;
            if (!tempURL.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("Not a supported Input");
            this.datasetSource = Utilities.urlToFile((URL)tempURL);
        }
        return this.datasetSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        boolean isInputDecodable;
        block29: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Setting Input");
            }
            if (this.imageInputStream != null) {
                this.reset();
                this.imageInputStream = null;
            }
            if (input == null) {
                throw new IllegalArgumentException("The provided input is null!");
            }
            if (input instanceof File) {
                this.datasetSource = (File)input;
                try {
                    this.imageInputStream = ImageIO.createImageInputStream(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create a valid input stream ", e);
                }
            } else if (input instanceof FileImageInputStreamExt) {
                this.datasetSource = ((FileImageInputStreamExt)input).getFile();
                this.imageInputStream = (ImageInputStream)input;
            } else if (input instanceof URL) {
                URL tempURL = (URL)input;
                if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                    try {
                        this.datasetSource = Utilities.urlToFile((URL)tempURL);
                        this.imageInputStream = ImageIO.createImageInputStream(input);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create a valid input stream ", e);
                    }
                }
            } else if (input instanceof URIImageInputStream) {
                this.imageInputStream = (URIImageInputStream)input;
                this.datasetSource = null;
                this.uriSource = ((URIImageInputStream)input).getUri();
            }
            isInputDecodable = false;
            if (this.imageInputStream != null) {
                Dataset dataSet = null;
                if (this.datasetSource != null) {
                    dataSet = GDALUtilities.acquireDataSet(this.datasetSource.getAbsolutePath(), gdalconstConstants.GA_ReadOnly);
                } else if (this.uriSource != null) {
                    String urisource = this.uriSource.toString();
                    dataSet = GDALUtilities.acquireDataSet(urisource, gdalconstConstants.GA_ReadOnly);
                }
                if (dataSet != null) {
                    try {
                        isInputDecodable = ((GDALImageReaderSpi)this.getOriginatingProvider()).isDecodable(dataSet);
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        block30: {
                            Object var8_11 = null;
                            try {
                                GDALUtilities.closeDataSet(dataSet);
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block30;
                                LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        GDALUtilities.closeDataSet(dataSet);
                    }
                    catch (Throwable e) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                        break block29;
                    }
                }
                isInputDecodable = false;
            }
        }
        if (!isInputDecodable) {
            StringBuilder sb = new StringBuilder();
            if (this.imageInputStream == null) {
                sb.append("Unable to create a valid ImageInputStream for the provided input:");
                sb.append(GDALUtilities.NEWLINE);
                sb.append(input.toString());
            } else {
                sb.append("The Provided input is not supported by this reader");
            }
            throw new RuntimeException(sb.toString());
        }
        super.setInput(this.imageInputStream, seekForwardOnly, ignoreMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Map<String, GDALCommonIIOImageMetadata> map = this.datasetMetadataMap;
        synchronized (map) {
            if (this.imageInputStream != null) {
                try {
                    this.imageInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.imageInputStream = null;
            this.datasetMetadataMap.clear();
            this.datasetNames = null;
        }
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
        this.isInitialized = false;
        this.nSubdatasets = -1;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(4);
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        this.imageType = new ImageTypeSpecifier(item.getColorModel(), item.getSampleModel());
        l.add(this.imageType);
        return l.iterator();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        int nDestBands;
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        int width = item.getWidth();
        int height = item.getHeight();
        SampleModel itemSampleModel = item.getSampleModel();
        int itemNBands = itemSampleModel.getNumBands();
        BufferedImage bi = null;
        ImageReadParam imageReadParam = param == null ? this.getDefaultReadParam() : param;
        ImageTypeSpecifier imageType = imageReadParam.getDestinationType();
        SampleModel destSampleModel = null;
        if (imageType != null) {
            destSampleModel = imageType.getSampleModel();
            nDestBands = destSampleModel.getNumBands();
        } else {
            bi = imageReadParam.getDestination();
            nDestBands = bi != null ? bi.getSampleModel().getNumBands() : itemNBands;
        }
        GDALImageReader.checkReadParamBandSettings(imageReadParam, itemNBands, nDestBands);
        int[] srcBands = imageReadParam.getSourceBands();
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        GDALImageReader.computeRegions(imageReadParam, width, height, bi, srcRegion, destRegion);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Source Region = " + srcRegion.toString());
            LOGGER.fine("Destination Region = " + destRegion.toString());
        }
        if (bi == null) {
            if (imageType == null) {
                ColorModel cm = item.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands), false, null);
            } else {
                ColorModel cm = imageType.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands, destSampleModel), false, null);
            }
        } else {
            Raster readRaster = this.readDatasetRaster(item, srcRegion, destRegion, srcBands);
            WritableRaster raster = bi.getRaster().createWritableChild(0, 0, bi.getWidth(), bi.getHeight(), 0, 0, null);
            raster.setRect(destRegion.x, destRegion.y, readRaster);
        }
        return bi;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param).getData();
    }

    @Override
    public BufferedImage read(int imageIndex) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("read(imageIndex)");
        }
        return this.read(imageIndex, null);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting NumImages");
        }
        this.initialize();
        return this.nSubdatasets;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getHeight();
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileHeight();
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileWidth();
    }

    public String getProjection(int imageIndex) {
        return this.getDatasetMetadata(imageIndex).getProjection();
    }

    public double[] getGeoTransform(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGeoTransformation();
    }

    public List<? extends GCP> getGCPs(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGCPs();
    }

    public String getGCPProjection(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpProjection();
    }

    public int getGCPCount(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpNumber();
    }

    public double getNoDataValue(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getNoDataValue(band);
    }

    public double getOffset(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getOffset(band);
    }

    public double getScale(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getScale(band);
    }

    public double getMinimum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMinimum(band);
    }

    public double getMaximum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMaximum(band);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.initialize();
        return new GDALCommonIIOStreamMetadata(this.datasetNames);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex);
    }
}

