/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.util.Set;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.v1_1_0.DefaultWFSStrategy;
import org.geotools.filter.v1_0.OGCConfiguration;
import org.geotools.xml.Configuration;

public class GeoServerStrategy
extends DefaultWFSStrategy {
    private static Configuration filter_1_0_0_Configuration = new OGCConfiguration();
    private static final String GEOSERVER_WRONG_FORMAT_NAME = "text/gml; subtype=gml/3.1.1";

    public String getDefaultOutputFormat(WFSProtocol wfs, WFSOperationType op) {
        try {
            return super.getDefaultOutputFormat(wfs, op);
        }
        catch (IllegalArgumentException e) {
            Set<String> supportedOutputFormats = wfs.getSupportedGetFeatureOutputFormats();
            if (supportedOutputFormats.contains(GEOSERVER_WRONG_FORMAT_NAME)) {
                return "text/xml; subtype=gml/3.1.1";
            }
            throw new IllegalArgumentException("Server does not support 'text/xml; subtype=gml/3.1.1' output format: " + supportedOutputFormats);
        }
    }

    protected Configuration getFilterConfiguration() {
        return filter_1_0_0_Configuration;
    }
}

