/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.SortBy;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentFeatureCollection
implements SimpleFeatureCollection {
    protected ContentFeatureSource featureSource;
    protected Query query;
    protected SimpleFeatureType featureType;
    protected ContentState state;
    protected List<CollectionListener> listeners = new ArrayList<CollectionListener>(2);
    protected final Set open = new HashSet();
    FeatureListener listener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            if (ContentFeatureCollection.this.listeners.isEmpty()) {
                return;
            }
            ContentFeatureCollection collection = ContentFeatureCollection.this;
            CollectionEvent event = new CollectionEvent(collection, featureEvent);
            CollectionListener[] notify = ContentFeatureCollection.this.listeners.toArray(new CollectionListener[ContentFeatureCollection.this.listeners.size()]);
            for (int i = 0; i < notify.length; ++i) {
                CollectionListener listener = notify[i];
                try {
                    listener.collectionChanged(event);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    };

    protected ContentFeatureCollection(ContentFeatureSource featureSource, Query query) {
        this.featureSource = featureSource;
        this.query = query;
        this.featureType = query.getPropertyNames() != Query.ALL_NAMES ? SimpleFeatureTypeBuilder.retype(featureSource.getSchema(), query.getPropertyNames()) : featureSource.getSchema();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.featureSource.accepts(this.query, visitor, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(CollectionListener listener) {
        List<CollectionListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                this.featureSource.addFeatureListener(this.listener);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(CollectionListener listener) {
        List<CollectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.featureSource.removeFeatureListener(this.listener);
            }
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            return new WrappingFeatureIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> iterator) {
        iterator.close();
    }

    @Override
    public Iterator iterator() {
        try {
            return new WrappingIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(Iterator close) {
        try {
            ((WrappingIterator)close).delegate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ReferencedEnvelope getBounds() {
        try {
            return this.featureSource.getBounds(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        try {
            return this.featureSource.getCount(this.query);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(SimpleFeature o) {
        return this.addAll(Collections.singletonList(o));
    }

    ContentFeatureStore ensureFeatureStore() {
        if (this.featureSource instanceof ContentFeatureStore) {
            return (ContentFeatureStore)this.featureSource;
        }
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public boolean addAll(Collection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures(c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addAll(FeatureCollection c) {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            List<FeatureId> ids = featureStore.addFeatures(c);
            return ids.size() == c.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        ContentFeatureStore featureStore = this.ensureFeatureStore();
        try {
            featureStore.removeFeatures(this.query.getFilter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void purge() {
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return this.sort((org.opengis.filter.sort.SortBy)order);
    }

    @Override
    public SimpleFeatureCollection sort(org.opengis.filter.sort.SortBy sort) {
        Query query = new DefaultQuery();
        query.setSortBy(new org.opengis.filter.sort.SortBy[]{sort});
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        Query query = new DefaultQuery();
        query.setFilter(filter);
        query = DataUtilities.mixQueries(this.query, query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getID() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingIterator
    implements Iterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WrappingFeatureIterator
    implements SimpleFeatureIterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            try {
                return this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

