/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.util.Converters;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.EMFUtils;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public abstract class AbstractComplexEMFBinding
extends AbstractComplexBinding {
    EFactory factory;
    Class type;

    public AbstractComplexEMFBinding() {
    }

    public AbstractComplexEMFBinding(EFactory factory) {
        this.factory = factory;
    }

    public AbstractComplexEMFBinding(EFactory factory, Class type) {
        this(factory);
        this.type = type;
    }

    public Class getType() {
        if (this.type != null) {
            return this.type;
        }
        String pkg = this.factory.getClass().getPackage().getName();
        if (pkg.endsWith(".impl")) {
            pkg = pkg.substring(0, pkg.length() - 5);
        }
        String localName = this.getTarget().getLocalPart();
        try {
            return Class.forName(pkg + "." + localName);
        }
        catch (ClassNotFoundException e) {
            int i = localName.indexOf(95);
            if (i != -1) {
                String className = localName.substring(i + 1) + "Type";
                try {
                    return Class.forName(pkg + "." + className);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Could not map an EMF model class to:" + localName);
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (EObject.class.isAssignableFrom(this.getType()) && this.factory != null) {
            EObject eObject = this.createEObject(value);
            if (eObject == null) {
                return value;
            }
            this.setProperties(eObject, node, false);
            this.setProperties(eObject, node, true);
            if (instance.getElementDeclaration().getTypeDefinition().getBaseType() instanceof XSDTypeDefinition && value != null && EMFUtils.has(eObject, "value")) {
                this.setProperty(eObject, "value", value, false);
            }
            return eObject;
        }
        return value;
    }

    protected EObject createEObject(Object value) throws Exception {
        if (value == null || !this.getType().isAssignableFrom(value.getClass())) {
            Method create;
            String className = this.getType().getName();
            int index = className.lastIndexOf(46);
            if (index != -1) {
                className = className.substring(index + 1);
            }
            if ((create = this.factory.getClass().getMethod("create" + className, null)) == null) {
                return null;
            }
            return (EObject)create.invoke((Object)this.factory, null);
        }
        return (EObject)value;
    }

    void setProperties(EObject eObject, Node node, boolean lax) {
        String property;
        for (Node child : node.getChildren()) {
            property = child.getComponent().getName();
            this.setProperty(eObject, property, child.getValue(), lax);
        }
        for (Node att : node.getAttributes()) {
            property = att.getComponent().getName();
            this.setProperty(eObject, property, att.getValue(), lax);
        }
    }

    protected void setProperty(EObject eObject, String property, Object value, boolean lax) {
        block17: {
            try {
                List features;
                if (EMFUtils.has(eObject, property)) {
                    if (lax && EMFUtils.isSet(eObject, property)) {
                        return;
                    }
                    try {
                        if (EMFUtils.isCollection(eObject, property)) {
                            EMFUtils.add(eObject, property, value);
                        } else {
                            EMFUtils.set(eObject, property, value);
                        }
                        break block17;
                    }
                    catch (ClassCastException e) {
                        EStructuralFeature feature = EMFUtils.feature(eObject, property);
                        Class<?> target = feature.getEType().getInstanceClass();
                        Object converted = this.convert(value, target, e);
                        try {
                            EMFUtils.set(eObject, property, converted);
                            break block17;
                        }
                        catch (ClassCastException e1) {
                            try {
                                Method g = eObject.getClass().getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1), null);
                                if (g == null) {
                                    throw e;
                                }
                                target = g.getReturnType();
                                converted = this.convert(value, target, e);
                                EMFUtils.set(eObject, property, converted);
                                break block17;
                            }
                            catch (Exception e2) {
                                throw e;
                            }
                        }
                    }
                }
                if (lax && value != null && (features = EMFUtils.features(eObject, value.getClass())).size() == 1) {
                    EStructuralFeature feature = (EStructuralFeature)features.get(0);
                    if (EMFUtils.isCollection(eObject, feature)) {
                        EMFUtils.add(eObject, feature, value);
                    } else if (!eObject.eIsSet(feature)) {
                        eObject.eSet(feature, value);
                    }
                }
            }
            catch (RuntimeException e) {
                String msg = "Unable to set property: " + property + " for eobject: " + this.getTarget();
                throw new RuntimeException(msg, e);
            }
        }
    }

    private Object convert(Object value, Class target, RuntimeException toThrow) throws RuntimeException {
        Object converted = value;
        if (converted != null && !converted.getClass().isAssignableFrom(target)) {
            converted = Converters.convert(value, target);
        }
        if (converted == null) {
            throw toThrow;
        }
        return converted;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof EObject) {
            String stripped;
            EObject eObject = (EObject)object;
            if (EMFUtils.has(eObject, name.getLocalPart())) {
                return EMFUtils.get(eObject, name.getLocalPart());
            }
            if (name.getLocalPart().contains("_") && EMFUtils.has(eObject, stripped = name.getLocalPart().replaceAll("_", ""))) {
                return EMFUtils.get(eObject, stripped);
            }
        }
        return null;
    }
}

