/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.DashedShape;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class StyledShapePainter {
    private static AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final Logger LOGGER = Logging.getLogger((String)StyledShapePainter.class.getName());
    LabelCache labelCache;

    public StyledShapePainter(LabelCache labelCache) {
        this.labelCache = labelCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics, Shape shape, Style2D style, double scale) throws FactoryException, TransformException {
        if (style == null) {
            LOGGER.severe("ShapePainter has been asked to paint a null style!!");
            return;
        }
        if (!style.isScaleInRange(scale)) {
            LOGGER.fine("Out of scale");
            return;
        }
        if (style instanceof IconStyle2D) {
            AffineTransform temp = graphics.getTransform();
            try {
                IconStyle2D icoStyle = (IconStyle2D)style;
                Icon icon = icoStyle.getIcon();
                graphics.setComposite(icoStyle.getComposite());
                float dx = -((float)((double)icon.getIconWidth() / 2.0 + (double)icoStyle.getDisplacementX()));
                float dy = -((float)((double)icon.getIconHeight() / 2.0 + (double)icoStyle.getDisplacementY()));
                float[] coords = new float[2];
                PathIterator citer = shape.getPathIterator(IDENTITY_TRANSFORM);
                AffineTransform markAT = new AffineTransform(temp);
                while (!citer.isDone()) {
                    citer.currentSegment(coords);
                    markAT.setTransform(temp);
                    markAT.translate(coords[0] + dx, coords[1] + dy);
                    markAT.rotate(icoStyle.getRotation());
                    graphics.setTransform(markAT);
                    icon.paintIcon(null, graphics, 0, 0);
                    citer.next();
                }
            }
            finally {
                graphics.setTransform(temp);
            }
        } else if (style instanceof MarkStyle2D) {
            PathIterator citer = shape.getPathIterator(IDENTITY_TRANSFORM);
            float[] coords = new float[2];
            MarkStyle2D ms2d = (MarkStyle2D)style;
            while (!citer.isDone()) {
                citer.currentSegment(coords);
                Shape transformedShape = ms2d.getTransformedShape(coords[0], coords[1]);
                if (transformedShape == null) continue;
                if (ms2d.getFill() != null) {
                    graphics.setPaint(ms2d.getFill());
                    graphics.setComposite(ms2d.getFillComposite());
                    graphics.fill(transformedShape);
                }
                if (ms2d.getContour() != null) {
                    graphics.setPaint(ms2d.getContour());
                    graphics.setStroke(ms2d.getStroke());
                    graphics.setComposite(ms2d.getContourComposite());
                    graphics.draw(transformedShape);
                }
                citer.next();
            }
        } else if (style instanceof GraphicStyle2D) {
            float[] coords = new float[2];
            PathIterator iter = shape.getPathIterator(IDENTITY_TRANSFORM);
            iter.currentSegment(coords);
            GraphicStyle2D gs2d = (GraphicStyle2D)style;
            while (!iter.isDone()) {
                iter.currentSegment(coords);
                this.renderImage(graphics, coords[0], coords[1], gs2d.getImage(), gs2d.getRotation(), gs2d.getOpacity());
                iter.next();
            }
        } else {
            LineStyle2D ls2d;
            Rectangle2D.Double scaledRect;
            double height;
            double width;
            AffineTransform at;
            Rectangle2D rect;
            BufferedImage image;
            TexturePaint tp;
            Paint paint;
            if (style instanceof PolygonStyle2D) {
                PolygonStyle2D ps2d = (PolygonStyle2D)style;
                if (ps2d.getFill() != null) {
                    paint = ps2d.getFill();
                    if (paint instanceof TexturePaint) {
                        tp = (TexturePaint)paint;
                        image = tp.getImage();
                        rect = tp.getAnchorRect();
                        at = graphics.getTransform();
                        width = rect.getWidth() * at.getScaleX();
                        height = rect.getHeight() * at.getScaleY();
                        scaledRect = new Rectangle2D.Double(0.0, 0.0, width, height);
                        paint = new TexturePaint(image, scaledRect);
                    }
                    graphics.setPaint(paint);
                    graphics.setComposite(ps2d.getFillComposite());
                    graphics.fill(shape);
                }
                if (ps2d.getGraphicFill() != null) {
                    this.paintGraphicFill(graphics, shape, ps2d.getGraphicFill(), scale);
                }
            }
            if (style instanceof LineStyle2D && (ls2d = (LineStyle2D)style).getStroke() != null) {
                if (ls2d.getGraphicStroke() != null) {
                    this.drawWithGraphicsStroke(graphics, this.dashShape(shape, ls2d.getStroke()), ls2d.getGraphicStroke());
                } else {
                    paint = ls2d.getContour();
                    if (paint instanceof TexturePaint) {
                        tp = (TexturePaint)paint;
                        image = tp.getImage();
                        rect = tp.getAnchorRect();
                        at = graphics.getTransform();
                        width = rect.getWidth() * at.getScaleX();
                        height = rect.getHeight() * at.getScaleY();
                        scaledRect = new Rectangle2D.Double(0.0, 0.0, width, height);
                        paint = new TexturePaint(image, scaledRect);
                    }
                    Stroke stroke = ls2d.getStroke();
                    if (graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON && stroke instanceof BasicStroke) {
                        BasicStroke bs = (BasicStroke)stroke;
                        stroke = new BasicStroke(bs.getLineWidth() + 0.5f, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
                    }
                    graphics.setPaint(paint);
                    graphics.setStroke(stroke);
                    graphics.setComposite(ls2d.getContourComposite());
                    graphics.draw(shape);
                }
            }
        }
    }

    Shape dashShape(Shape shape, Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return shape;
        }
        BasicStroke bs = (BasicStroke)stroke;
        if (bs.getDashArray() == null || bs.getDashArray().length == 0) {
            return shape;
        }
        return new DashedShape(shape, bs.getDashArray(), bs.getDashPhase());
    }

    private GeomCollectionIterator getPathIterator(LiteShape2 shape) {
        GeometryCollection gc;
        if (shape.getGeometry() instanceof GeometryCollection) {
            gc = (GeometryCollection)shape.getGeometry();
        } else {
            Geometry[] gs = new Geometry[]{shape.getGeometry()};
            gc = shape.getGeometry().getFactory().createGeometryCollection(gs);
        }
        GeomCollectionIterator citer = new GeomCollectionIterator(gc, IDENTITY_TRANSFORM, false, 1.0);
        return citer;
    }

    private void drawWithGraphicsStroke(Graphics2D graphics, Shape shape, Style2D graphicStroke) {
        double imageSize;
        PathIterator pi = shape.getPathIterator(null);
        double[] coords = new double[4];
        if (graphicStroke instanceof MarkStyle2D) {
            imageSize = ((MarkStyle2D)graphicStroke).getSize();
        } else if (graphicStroke instanceof IconStyle2D) {
            imageSize = ((IconStyle2D)graphicStroke).getIcon().getIconWidth();
        } else {
            GraphicStyle2D gs = (GraphicStyle2D)graphicStroke;
            imageSize = gs.getImage().getWidth() - gs.getBorder();
        }
        double[] first = new double[2];
        double[] previous = new double[2];
        int type = pi.currentSegment(coords);
        first[0] = coords[0];
        first[1] = coords[1];
        previous[0] = coords[0];
        previous[1] = coords[1];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("starting at " + first[0] + "," + first[1]);
        }
        pi.next();
        double remainder = imageSize / 2.0;
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("moving to " + coords[0] + "," + coords[1]);
                    }
                    remainder = imageSize / 2.0;
                    break;
                }
                case 4: {
                    coords[0] = first[0];
                    coords[1] = first[1];
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("closing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                }
                case 1: {
                    double dy;
                    double dx;
                    double len;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("drawing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                    if ((len = Math.sqrt((dx = coords[0] - previous[0]) * dx + (dy = coords[1] - previous[1]) * dy)) < remainder) {
                        remainder -= len;
                        break;
                    }
                    double theta = Math.atan2(dx, dy);
                    dx = Math.sin(theta) * imageSize;
                    dy = Math.cos(theta) * imageSize;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("dx = " + dx + " dy " + dy + " step = " + Math.sqrt(dx * dx + dy * dy));
                    }
                    double rotation = -(theta - 1.5707963267948966);
                    double x = previous[0] + Math.sin(theta) * remainder;
                    double y = previous[1] + Math.cos(theta) * remainder;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("len =" + len + " imageSize " + imageSize);
                    }
                    double dist = 0.0;
                    for (dist = remainder; dist < len; dist += imageSize) {
                        this.renderGraphicsStroke(graphics, x, y, graphicStroke, rotation, 1.0f);
                        x += dx;
                        y += dy;
                    }
                    remainder = dist - len;
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("loop end dist " + dist + " len " + len + " " + (len - dist));
                    break;
                }
                default: {
                    LOGGER.warning("default branch reached in drawWithGraphicStroke");
                }
            }
            previous[0] = coords[0];
            previous[1] = coords[1];
            pi.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderGraphicsStroke(Graphics2D graphics, double x, double y, Style2D style, double rotation, float opacity) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("drawing GraphicsStroke@" + x + "," + y);
        }
        graphics.setComposite(AlphaComposite.getInstance(3, opacity));
        if (style instanceof GraphicStyle2D) {
            BufferedImage image = ((GraphicStyle2D)style).getImage();
            this.renderImage(graphics, x, y, image, rotation, opacity);
        } else if (style instanceof MarkStyle2D) {
            MarkStyle2D ms2d = (MarkStyle2D)style;
            Shape transformedShape = ms2d.getTransformedShape((float)x, (float)y, (float)rotation);
            if (transformedShape != null) {
                if (ms2d.getFill() != null) {
                    graphics.setPaint(ms2d.getFill());
                    graphics.fill(transformedShape);
                }
                if (ms2d.getContour() != null) {
                    graphics.setPaint(ms2d.getContour());
                    graphics.setStroke(ms2d.getStroke());
                    graphics.draw(transformedShape);
                }
            }
        } else if (style instanceof IconStyle2D) {
            IconStyle2D icons = (IconStyle2D)style;
            Icon icon = icons.getIcon();
            AffineTransform markAT = new AffineTransform(graphics.getTransform());
            markAT.translate(x, y);
            markAT.rotate(rotation);
            markAT.translate((double)(-icon.getIconWidth()) / 2.0, (double)(-icon.getIconHeight()) / 2.0);
            AffineTransform temp = graphics.getTransform();
            try {
                graphics.setTransform(markAT);
                icon.paintIcon(null, graphics, 0, 0);
            }
            finally {
                graphics.setTransform(temp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(Graphics2D graphics, double x, double y, BufferedImage image, double rotation, float opacity) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("drawing Image @" + x + "," + y);
        }
        AffineTransform markAT = new AffineTransform();
        markAT.translate(x, y);
        markAT.rotate(rotation);
        markAT.translate((double)(-image.getWidth()) / 2.0, (double)(-image.getHeight()) / 2.0);
        graphics.setComposite(AlphaComposite.getInstance(3, opacity));
        Object interpolation = graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (interpolation == null) {
            interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        try {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawRenderedImage(image, markAT);
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        }
    }

    private void paintGraphicFill(Graphics2D graphics, Shape shape, Style2D graphicFill, double scale) throws TransformException, FactoryException {
        Rectangle2D boundsShape = shape.getBounds2D();
        Rectangle2D.Double stippleSize = null;
        if (graphicFill instanceof MarkStyle2D) {
            Rectangle2D boundsFill = ((MarkStyle2D)graphicFill).getShape().getBounds2D();
            double size = ((MarkStyle2D)graphicFill).getSize();
            double aspect = boundsFill.getHeight() > 0.0 && boundsFill.getWidth() > 0.0 ? boundsFill.getWidth() / boundsFill.getHeight() : 1.0;
            stippleSize = new Rectangle2D.Double(0.0, 0.0, size * aspect, size);
        } else if (graphicFill instanceof IconStyle2D) {
            Icon icon = ((IconStyle2D)graphicFill).getIcon();
            stippleSize = new Rectangle2D.Double(0.0, 0.0, icon.getIconWidth(), icon.getIconHeight());
        } else {
            return;
        }
        int nStippleX = (int)Math.ceil(boundsShape.getWidth() / ((RectangularShape)stippleSize).getWidth());
        int nStippleY = (int)Math.ceil(boundsShape.getHeight() / ((RectangularShape)stippleSize).getHeight());
        Graphics2D g = (Graphics2D)graphics.create();
        g.clip(shape);
        Shape clipShape = g.getClip();
        for (int i = 0; i < nStippleX; ++i) {
            for (int j = 0; j < nStippleY; ++j) {
                double translateY;
                double translateX = boundsShape.getMinX() + (double)i * ((RectangularShape)stippleSize).getWidth();
                if (!clipShape.intersects(translateX, translateY = boundsShape.getMinY() + (double)j * ((RectangularShape)stippleSize).getHeight(), ((RectangularShape)stippleSize).getWidth(), ((RectangularShape)stippleSize).getHeight())) continue;
                LiteShape2 stippleShape = this.createStippleShape(stippleSize, translateX, translateY);
                this.paint(g, (Shape)stippleShape, graphicFill, scale);
            }
        }
    }

    private LiteShape2 createStippleShape(Rectangle2D stippleSize, double translateX, double translateY) throws TransformException, FactoryException {
        GeometryFactory geomFactory = new GeometryFactory();
        Coordinate coord = new Coordinate(stippleSize.getCenterX() + translateX, stippleSize.getCenterY() + translateY);
        Point geom = geomFactory.createPoint(coord);
        AffineTransform2D identityTransf = new AffineTransform2D(new AffineTransform());
        Decimator nullDecimator = new Decimator(-1.0, -1.0);
        LiteShape2 stippleShape = new LiteShape2((Geometry)geom, (MathTransform)identityTransf, nullDecimator, false);
        return stippleShape;
    }
}

