/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.directory.DirectoryFeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileRendererUtil;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.index.quadtree.StoreException;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.OpacityFinder;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.shape.FilterTransformer;
import org.geotools.renderer.shape.GeometryFilterChecker;
import org.geotools.renderer.shape.IndexInfo;
import org.geotools.renderer.shape.IntegratingLabelCache;
import org.geotools.renderer.shape.MultiLineShape;
import org.geotools.renderer.shape.MultiPointShape;
import org.geotools.renderer.shape.PolygonShape;
import org.geotools.renderer.shape.SimpleGeometry;
import org.geotools.renderer.shape.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class ShapefileRenderer
implements GTRenderer {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.renderer.shape");
    private static final double TOLERANCE = 1.0E-6;
    private static final GeometryFactory geomFactory = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private static final Coordinate[] COORDS = new Coordinate[5];
    private static final MultiPolygon MULTI_POLYGON_GEOM;
    private static final Polygon POLYGON_GEOM;
    private static final LinearRing LINE_GEOM;
    private static final MultiLineString MULTI_LINE_GEOM;
    private static final Point POINT_GEOM;
    private static final MultiPoint MULTI_POINT_GEOM;
    public static final String SCALE_ACCURATE = "ACCURATE";
    public static final String SCALE_OGC = "OGC";
    private String scaleComputationMethodDEFAULT = "ACCURATE";
    public static final DefaultRenderListener DEFAULT_LISTENER;
    private static final IndexInfo STREAMING_RENDERER_INFO;
    static int NUM_SAMPLES;
    private RenderingHints hints;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    private boolean renderingStopRequested;
    private boolean concatTransforms;
    private MapContext context;
    LabelCache labelCache = new LabelCacheImpl();
    private List<RenderListener> renderListeners = new CopyOnWriteArrayList<RenderListener>();
    boolean caching = false;
    private double scaleDenominator;
    private Object defaultGeom;
    IndexInfo[] layerIndexInfo;
    StreamingRenderer delegate;
    int[] attributeIndexing;
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private Map decimators = new HashMap();
    public static final String TEXT_RENDERING_STRING = "STRING";
    public static final String TEXT_RENDERING_OUTLINE = "OUTLINE";
    public static final String TEXT_RENDERING_KEY = "textRenderingMethod";
    private String textRenderingModeDEFAULT = "STRING";
    public static final String LABEL_CACHE_KEY = "labelCache";
    public static final String FORCE_CRS_KEY = "forceCRS";
    public static final String DPI_KEY = "dpi";
    public static final String DECLARED_SCALE_DENOM_KEY = "declaredScaleDenominator";
    public static final String MEMORY_PRE_LOADING_KEY = "memoryPreloadingEnabled";
    public static final String OPTIMIZED_DATA_LOADING_KEY = "optimizedDataLoadingEnabled";
    public static final String SCALE_COMPUTATION_METHOD_KEY = "scaleComputationMethod";
    private Map rendererHints = null;

    public ShapefileRenderer(MapContext context) {
        this.setContext(context);
    }

    public ShapefileRenderer() {
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapArea, (Rectangle)paintArea));
    }

    private void processStylers(Graphics2D graphics, ShapefileDataStore datastore, Query query, Envelope bbox, Rectangle screenSize, MathTransform mt, Style style, IndexInfo info, Transaction transaction, String layerId) throws IOException {
        SimpleFeatureType type;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("processing " + style.getFeatureTypeStyles().length + " stylers");
        }
        FeatureTypeStyle[] featureStylers = style.getFeatureTypeStyles();
        try {
            type = this.createFeatureType(query, style, datastore);
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            LOGGER.logp(Level.WARNING, "org.geotools.renderer.shape.ShapefileRenderer", "processStylers", "Could not prep style for rendering", e);
            return;
        }
        for (int i = 0; i < featureStylers.length; ++i) {
            double standardDpi;
            int j;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("processing style " + i);
            }
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = datastore.getSchema().getTypeName();
            if (typeName == null || !FeatureTypes.isDecendedFrom((FeatureType)datastore.getSchema(), null, (String)fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ArrayList<Rule> ruleList = new ArrayList<Rule>();
            ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
            for (int j2 = 0; j2 < rules.length; ++j2) {
                Rule r;
                Filter f;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("processing rule " + j2);
                }
                if ((f = (r = rules[j2]).getFilter()) != null) {
                    GeometryFilterChecker checker = new GeometryFilterChecker();
                    f.accept((FilterVisitor)checker, null);
                    if (checker.isGeometryFilterPresent()) {
                        DuplicatingStyleVisitor duplicator = new DuplicatingStyleVisitor();
                        r.accept((StyleVisitor)duplicator);
                        r = (Rule)duplicator.getCopy();
                        FilterTransformer transformer = new FilterTransformer(mt);
                        r.setFilter((Filter)r.getFilter().accept((FilterVisitor)transformer, null));
                    }
                }
                if (!this.isWithInScale(r)) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio((double)this.scaleDenominator, (Map)this.rendererHints);
            UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
            for (j = 0; j < ruleList.size(); ++j) {
                rescaleVisitor.visit((Rule)ruleList.get(j));
                ruleList.set(j, (Rule)rescaleVisitor.getCopy());
            }
            for (j = 0; j < elseRuleList.size(); ++j) {
                rescaleVisitor.visit((Rule)elseRuleList.get(j));
                elseRuleList.set(j, (Rule)rescaleVisitor.getCopy());
            }
            double dpi = RendererUtilities.getDpi((Map)this.getRendererHints());
            if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
                int j3;
                double scaleFactor = dpi / standardDpi;
                RescaleStyleVisitor dpiVisitor = new RescaleStyleVisitor(scaleFactor);
                for (j3 = 0; j3 < ruleList.size(); ++j3) {
                    dpiVisitor.visit((Rule)ruleList.get(j3));
                    ruleList.set(j3, (Rule)dpiVisitor.getCopy());
                }
                for (j3 = 0; j3 < elseRuleList.size(); ++j3) {
                    dpiVisitor.visit((Rule)elseRuleList.get(j3));
                    elseRuleList.set(j3, (Rule)dpiVisitor.getCopy());
                }
            }
            NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
            Set modifiedFIDs = this.processTransaction(graphics, bbox, mt, (DataStore)datastore, transaction, typeName, query, ruleList, elseRuleList, scaleRange, layerId);
            if (ruleList.size() <= 0 && elseRuleList.size() <= 0) continue;
            this.processShapefile(graphics, datastore, bbox, screenSize, mt, info, type, query, ruleList, elseRuleList, modifiedFIDs, scaleRange, layerId);
        }
    }

    private Set processTransaction(Graphics2D graphics, Envelope bbox, MathTransform transform, DataStore ds, Transaction transaction, String typename, Query query, List ruleList, List elseRuleList, NumberRange scaleRange, String layerId) {
        if (transaction == Transaction.AUTO_COMMIT) {
            return Collections.EMPTY_SET;
        }
        TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)ds);
        if (state == null) {
            return Collections.EMPTY_SET;
        }
        Set<String> fids = new HashSet();
        Map modified = null;
        Map added = null;
        Diff diff = null;
        try {
            diff = state.diff(typename);
            modified = diff.modified2;
            added = diff.added;
            fids = new HashSet();
        }
        catch (IOException e) {
            fids = Collections.EMPTY_SET;
            return fids;
        }
        if (!diff.isEmpty()) {
            Iterator modifiedIter = modified.keySet().iterator();
            Iterator addedIter = added.values().iterator();
            while (modifiedIter.hasNext() || addedIter.hasNext()) {
                try {
                    SimpleFeature feature;
                    if (this.renderingStopRequested) break;
                    boolean doElse = true;
                    if (modifiedIter.hasNext()) {
                        String fid = (String)modifiedIter.next();
                        feature = (SimpleFeature)modified.get(fid);
                        fids.add(fid);
                    } else {
                        feature = (SimpleFeature)addedIter.next();
                    }
                    if (feature == TransactionStateDiff.NULL || !query.getFilter().evaluate((Object)feature)) continue;
                    for (Rule r : ruleList) {
                        Filter filter;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("applying rule: " + r.toString());
                        }
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("this rule applies ...");
                        }
                        if ((filter = r.getFilter()) != null && !filter.evaluate((Object)feature)) continue;
                        doElse = false;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("processing Symobolizer ...");
                        }
                        Symbolizer[] symbolizers = r.getSymbolizers();
                        try {
                            this.processSymbolizers(graphics, feature, symbolizers, scaleRange, transform, layerId);
                        }
                        catch (Exception e) {
                            this.fireErrorEvent(e);
                            continue;
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("... done!");
                    }
                    if (doElse) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("rules with an else filter");
                        }
                        for (Rule r : elseRuleList) {
                            Symbolizer[] symbolizers = r.getSymbolizers();
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("processing Symobolizer ...");
                            }
                            try {
                                this.processSymbolizers(graphics, feature, symbolizers, scaleRange, transform, layerId);
                            }
                            catch (Exception e) {
                                this.fireErrorEvent(e);
                                continue;
                            }
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("... done!");
                        }
                    }
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.finer("feature rendered event ...");
                }
                catch (RuntimeException e) {
                    this.fireErrorEvent(e);
                }
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processShapefile(Graphics2D graphics, ShapefileDataStore datastore, Envelope bbox, Rectangle screenSize, MathTransform mt, IndexInfo info, SimpleFeatureType type, Query query, List ruleList, List elseRuleList, Set modifiedFIDs, NumberRange scaleRange, String layerId) throws IOException {
        int miss;
        int hit;
        block84: {
            IndexedDbaseFileReader dbfreader = null;
            IndexInfo.Reader shpreader = null;
            FIDReader fidReader = null;
            hit = 0;
            miss = 0;
            try {
                graphics = (Graphics2D)graphics.create();
                graphics.clip(screenSize);
                if (type.getAttributeCount() > 1) {
                    try {
                        dbfreader = ShapefileRendererUtil.getDBFReader(datastore);
                    }
                    catch (Exception e) {
                        this.fireErrorEvent(e);
                    }
                }
                OpacityFinder opacityFinder = new OpacityFinder(this.getAcceptableSymbolizers(type.getGeometryDescriptor()));
                for (Rule rule : ruleList) {
                    rule.accept((StyleVisitor)opacityFinder);
                }
                if (datastore instanceof IndexedShapefileDataStore) {
                    ((IndexedShapefileDataStore)datastore).createSpatialIndex(false);
                }
                boolean useJTS = true;
                try {
                    shpreader = new IndexInfo.Reader(info, ShapefileRendererUtil.getShpReader(datastore, bbox, screenSize, mt, opacityFinder.hasOpacity, useJTS), bbox);
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    try {
                        if (dbfreader != null) {
                            dbfreader.close();
                        }
                    }
                    finally {
                        try {
                            if (shpreader != null) {
                                shpreader.close();
                            }
                        }
                        finally {
                            if (fidReader != null) {
                                fidReader.close();
                            }
                        }
                    }
                    return;
                }
                try {
                    fidReader = ShapefileRendererUtil.getFidReader(datastore, shpreader);
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    try {
                        if (dbfreader != null) {
                            dbfreader.close();
                        }
                    }
                    finally {
                        try {
                            if (shpreader != null) {
                                shpreader.close();
                            }
                        }
                        finally {
                            if (fidReader != null) {
                                fidReader.close();
                            }
                        }
                    }
                    return;
                }
                SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
                while (true) {
                    try {
                        while (true) {
                            if (this.renderingStopRequested) {
                                break block84;
                            }
                            if (!shpreader.hasNext()) {
                                break block84;
                            }
                            boolean doElse = true;
                            String nextFid = null;
                            if (fidReader.hasNext()) {
                                try {
                                    nextFid = fidReader.next();
                                }
                                catch (NoSuchElementException invalidIndex) {
                                    this.fireErrorEvent(new IllegalStateException("Skipping invalid FID; Please regenerate your index.", invalidIndex));
                                }
                            } else {
                                this.fireErrorEvent(new IllegalStateException("Skipping invalid FID; shape and index are out of sync please regenerate index."));
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("trying to read geometry ...");
                            }
                            if (nextFid == null || modifiedFIDs.contains(nextFid)) {
                                shpreader.next();
                                if (dbfreader == null || dbfreader.IsRandomAccessEnabled()) continue;
                                dbfreader.skip();
                                continue;
                            }
                            int recno = shpreader.getRecordNumber();
                            ShapefileReader.Record record = shpreader.next();
                            Object geom = record.shape();
                            if (geom == null) {
                                ++miss;
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.finest("skipping geometry");
                                }
                                if (dbfreader == null || dbfreader.IsRandomAccessEnabled()) continue;
                                dbfreader.skip();
                                continue;
                            }
                            ++hit;
                            if (dbfreader != null && dbfreader.IsRandomAccessEnabled()) {
                                dbfreader.goTo(recno);
                            }
                            SimpleFeature feature = this.createFeature(fbuilder, record, (DbaseFileReader)dbfreader, nextFid);
                            if (!query.getFilter().evaluate((Object)feature)) continue;
                            if (this.renderingStopRequested) {
                                break block84;
                            }
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("... done: " + geom.toString());
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.fine("... done: " + type.getTypeName());
                            }
                            for (Rule r : ruleList) {
                                Filter filter;
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("applying rule: " + r.toString());
                                }
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("this rule applies ...");
                                }
                                if ((filter = r.getFilter()) != null && !filter.evaluate((Object)feature)) continue;
                                doElse = false;
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("processing Symobolizer ...");
                                }
                                Symbolizer[] symbolizers = r.getSymbolizers();
                                this.processSymbolizers(graphics, feature, geom, symbolizers, scaleRange, useJTS, layerId, screenSize);
                                if (!LOGGER.isLoggable(Level.FINER)) continue;
                                LOGGER.finer("... done!");
                            }
                            if (doElse) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("rules with an else filter");
                                }
                                for (Rule r : elseRuleList) {
                                    Symbolizer[] symbolizers = r.getSymbolizers();
                                    if (LOGGER.isLoggable(Level.FINER)) {
                                        LOGGER.finer("processing Symobolizer ...");
                                    }
                                    this.processSymbolizers(graphics, feature, geom, symbolizers, scaleRange, useJTS, layerId, screenSize);
                                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                                    LOGGER.finer("... done!");
                                }
                            }
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("feature rendered event ...");
                        }
                    }
                    catch (Exception e) {
                        this.fireErrorEvent(e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                try {
                    if (dbfreader != null) {
                        dbfreader.close();
                    }
                }
                finally {
                    try {
                        if (shpreader != null) {
                            shpreader.close();
                        }
                    }
                    finally {
                        if (fidReader != null) {
                            fidReader.close();
                        }
                    }
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, type.getTypeName() + "): hit " + hit + " miss " + miss);
        }
    }

    private Class[] getAcceptableSymbolizers(GeometryDescriptor defaultGeometry) {
        Class binding = defaultGeometry.getType().getBinding();
        if (Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding)) {
            return new Class[]{PointSymbolizer.class, LineSymbolizer.class, PolygonSymbolizer.class};
        }
        return new Class[]{PointSymbolizer.class, LineSymbolizer.class};
    }

    SimpleFeature createFeature(SimpleFeatureBuilder builder, ShapefileReader.Record record, DbaseFileReader dbfreader, String id) throws Exception {
        SimpleFeatureType type = builder.getFeatureType();
        if (type.getAttributeCount() == 1) {
            builder.add(this.getGeom(record.shape(), type.getGeometryDescriptor()));
            return builder.buildFeature(id);
        }
        dbfreader.read();
        for (int i = 0; i < type.getAttributeCount() - 1; ++i) {
            builder.add(dbfreader.readField(this.attributeIndexing[i]));
        }
        builder.add(this.getGeom(record.shape(), type.getGeometryDescriptor()));
        return builder.buildFeature(id);
    }

    private Object getGeom(Object geom, GeometryDescriptor defaultGeometry) {
        if (geom instanceof Geometry) {
            return geom;
        }
        return this.getGeom(defaultGeometry);
    }

    private Object getGeom(GeometryDescriptor defaultGeometry) {
        Class binding = defaultGeometry.getType().getBinding();
        if (MultiPolygon.class.isAssignableFrom(binding)) {
            return MULTI_POLYGON_GEOM;
        }
        if (MultiLineString.class.isAssignableFrom(binding)) {
            return MULTI_LINE_GEOM;
        }
        if (Point.class.isAssignableFrom(binding)) {
            return POINT_GEOM;
        }
        if (MultiPoint.class.isAssignableFrom(binding)) {
            return MULTI_POINT_GEOM;
        }
        return null;
    }

    SimpleFeatureType createFeatureType(Query query, Style style, ShapefileDataStore ds) throws SchemaException, IOException {
        SimpleFeatureType schema = ds.getSchema();
        String[] attributes = this.findStyleAttributes(query == null ? Query.ALL : query, style, schema);
        AttributeDescriptor[] types = new AttributeDescriptor[attributes.length];
        this.attributeIndexing = new int[attributes.length];
        if (attributes.length == 1 && attributes[0].equals(schema.getGeometryDescriptor().getLocalName())) {
            types[0] = schema.getDescriptor(attributes[0]);
            if (types[0] == null) {
                throw new IllegalArgumentException("Attribute " + attributes[0] + " does not exist. Maybe it has just been spelled wrongly?");
            }
        } else {
            block0: for (int i = 0; i < types.length; ++i) {
                types[i] = schema.getDescriptor(attributes[i]);
                if (types[i] == null) {
                    throw new IllegalArgumentException("Attribute " + attributes[i] + " does not exist. Maybe it has just been spelled wrongly?");
                }
                for (int j = 0; j < schema.getAttributeCount(); ++j) {
                    if (!schema.getDescriptor(j).getLocalName().equals(attributes[i])) continue;
                    this.attributeIndexing[i] = j - 1;
                    continue block0;
                }
            }
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(schema.getName());
        tb.addAll(types);
        tb.setDefaultGeometry(schema.getGeometryDescriptor().getLocalName());
        return tb.buildFeatureType();
    }

    private String[] findStyleAttributes(Query query, Style style, SimpleFeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        FilterAttributeExtractor qae = new FilterAttributeExtractor();
        query.getFilter().accept((FilterVisitor)qae, null);
        LinkedHashSet<String> ftsAttributes = new LinkedHashSet<String>(sae.getAttributeNameSet());
        ftsAttributes.addAll(qae.getAttributeNameSet());
        if (sae.getDefaultGeometryUsed() && !ftsAttributes.contains(schema.getGeometryDescriptor().getLocalName())) {
            ftsAttributes.add(schema.getGeometryDescriptor().getLocalName());
        } else {
            ftsAttributes.remove(schema.getGeometryDescriptor().getLocalName());
            ftsAttributes.add(schema.getGeometryDescriptor().getLocalName());
        }
        return ftsAttributes.toArray(new String[0]);
    }

    private void processSymbolizers(Graphics2D graphics, SimpleFeature feature, Object geom, Symbolizer[] symbolizers, NumberRange scaleRange, boolean isJTS, String layerId, Rectangle screenSize) {
        for (int m = 0; m < symbolizers.length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            if (this.renderingStopRequested) break;
            if (symbolizers[m] instanceof TextSymbolizer) {
                try {
                    this.labelCache.put(layerId, (TextSymbolizer)symbolizers[m], (Feature)feature, new LiteShape2((Geometry)feature.getDefaultGeometry(), null, null, false, false), scaleRange);
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                }
                continue;
            }
            try {
                Shape shape;
                Style2D style = this.styleFactory.createStyle((Object)feature, symbolizers[m], (Range)scaleRange);
                if (isJTS) {
                    Geometry g = symbolizers[m] instanceof PointSymbolizer ? RendererUtilities.getCentroid((Geometry)((Geometry)geom)) : (Geometry)geom;
                    double size = RendererUtilities.getStyle2DSize((Style2D)style) + 10.0;
                    Envelope env = new Envelope(screenSize.getMinX(), screenSize.getMaxX(), screenSize.getMinY(), screenSize.getMaxY());
                    env.expandBy(size);
                    GeometryClipper clipper = new GeometryClipper(env);
                    Geometry clipped = clipper.clip(g, false);
                    if (clipped == null) continue;
                    shape = new LiteShape2(clipped, null, null, false);
                    this.painter.paint(graphics, shape, style, this.scaleDenominator);
                    continue;
                }
                shape = symbolizers[m] instanceof PointSymbolizer ? new LiteShape2(RendererUtilities.getCentroid((Geometry)((Geometry)feature.getDefaultGeometry())), null, null, false, false) : this.getShape((SimpleGeometry)geom);
                this.painter.paint(graphics, shape, style, this.scaleDenominator);
                continue;
            }
            catch (Exception e) {
                this.fireErrorEvent(e);
            }
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private void processSymbolizers(Graphics2D graphics, SimpleFeature feature, Symbolizer[] symbolizers, NumberRange scaleRange, MathTransform transform, String layerId) throws TransformException, FactoryException {
        for (int m = 0; m < symbolizers.length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            Geometry g = (Geometry)feature.getDefaultGeometry();
            if (symbolizers[m] instanceof PointSymbolizer) {
                g = RendererUtilities.getCentroid((Geometry)g);
            }
            LiteShape2 shape = new LiteShape2(g, transform, this.getDecimator(transform), false);
            if (symbolizers[m] instanceof TextSymbolizer) {
                this.labelCache.put(layerId, (TextSymbolizer)symbolizers[m], (Feature)feature, shape, scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle((Object)feature, symbolizers[m], (Range)scaleRange);
            this.painter.paint(graphics, (Shape)shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private Decimator getDecimator(MathTransform mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
        Decimator decimator = null;
        if (mathTransform != null) {
            decimator = (Decimator)this.decimators.get(mathTransform);
        }
        if (decimator == null) {
            decimator = new Decimator(mathTransform.inverse());
            this.decimators.put(mathTransform, decimator);
        }
        return decimator;
    }

    private Shape getShape(SimpleGeometry geom) {
        if (geom.type == ShapeType.ARC || geom.type == ShapeType.ARCM || geom.type == ShapeType.ARCZ) {
            return new MultiLineShape(geom);
        }
        if (geom.type == ShapeType.POLYGON || geom.type == ShapeType.POLYGONM || geom.type == ShapeType.POLYGONZ) {
            return new PolygonShape(geom);
        }
        if (geom.type == ShapeType.POINT || geom.type == ShapeType.POINTM || geom.type == ShapeType.POINTZ || geom.type == ShapeType.MULTIPOINT || geom.type == ShapeType.MULTIPOINTM || geom.type == ShapeType.MULTIPOINTZ) {
            return new MultiPointShape(geom);
        }
        return null;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove(listener);
    }

    private void fireFeatureRenderedEvent(SimpleFeature feature) {
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                RenderListener listener = this.renderListeners.get(i);
                listener.featureRenderer(feature);
            }
        }
    }

    private void fireErrorEvent(Exception e) {
        if (this.renderListeners.size() > 0) {
            for (int i = 0; i < this.renderListeners.size(); ++i) {
                try {
                    RenderListener listener = this.renderListeners.get(i);
                    listener.errorOccurred(e);
                    continue;
                }
                catch (RuntimeException ignore) {
                    LOGGER.fine("Provided RenderListener could not handle error message:" + ignore);
                    LOGGER.throwing(this.getClass().getName(), "fireErrorEvent", ignore);
                }
            }
        }
    }

    protected void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public void stopRendering() {
        try {
            if (this.delegate != null) {
                this.delegate.stopRendering();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public MapContext getContext() {
        return this.context;
    }

    public boolean isConcatTransforms() {
        return this.concatTransforms;
    }

    public void setConcatTransforms(boolean concatTransforms) {
        this.concatTransforms = concatTransforms;
    }

    public IndexInfo useIndex(ShapefileDataStore ds) throws IOException, StoreException {
        IndexInfo info;
        ShpFiles shpFiles = ShapefileRendererUtil.getShpFiles(ds);
        if (ds.isLocal()) {
            if (!shpFiles.exists(ShpFileType.SHX)) {
                info = new IndexInfo(IndexType.NONE, shpFiles);
                LOGGER.fine("No indexing");
            } else if (shpFiles.exists(ShpFileType.QIX)) {
                info = new IndexInfo(IndexType.QIX, shpFiles);
                LOGGER.fine("Using quad tree");
            } else {
                info = new IndexInfo(IndexType.NONE, shpFiles);
                LOGGER.fine("No indexing");
            }
        } else {
            info = new IndexInfo(IndexType.NONE, shpFiles);
            LOGGER.fine("No indexing");
        }
        return info;
    }

    public void setJava2DHints(RenderingHints hints) {
        this.hints = hints;
    }

    public RenderingHints getJava2DHints() {
        return this.hints;
    }

    public void setRendererHints(Map hints) {
        if (hints != null && hints.containsKey(LABEL_CACHE_KEY)) {
            LabelCache cache = (LabelCache)hints.get(LABEL_CACHE_KEY);
            if (cache == null) {
                throw new NullPointerException("Label_Cache_Hint has a null value for the labelcache");
            }
            this.labelCache = cache;
            this.painter = new StyledShapePainter(cache);
        }
        if (hints != null && hints.containsKey("lineWidthOptimization")) {
            this.styleFactory.setLineOptimizationEnabled(Boolean.TRUE.equals(hints.get("lineWidthOptimization")));
        }
        if (hints != null && hints.containsKey("vectorRenderingEnabled")) {
            this.styleFactory.setVectorRenderingEnabled(Boolean.TRUE.equals(hints.get("vectorRenderingEnabled")));
        }
        this.rendererHints = hints;
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    public void setContext(MapContext context) {
        if (context == null) {
            context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        this.context = context;
        MapLayer[] layers = context.getLayers();
        this.layerIndexInfo = new IndexInfo[layers.length];
        int i = 0;
        for (MapLayer layer : layers) {
            FeatureSource fs = layer.getFeatureSource();
            DataStore ds = (DataStore)fs.getDataStore();
            if (ds instanceof ShapefileDataStore) {
                ShapefileDataStore sds = (ShapefileDataStore)ds;
                try {
                    this.layerIndexInfo[i] = this.useIndex(sds);
                }
                catch (Exception e) {
                    this.layerIndexInfo[i] = new IndexInfo(IndexType.NONE, ShapefileRendererUtil.getShpFiles(sds));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Exception while trying to use index" + e.getLocalizedMessage());
                    }
                }
            } else {
                this.layerIndexInfo[i] = STREAMING_RENDERER_INFO;
            }
            ++i;
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            ReferencedEnvelope mapArea = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)worldToScreen, (CoordinateReferenceSystem)this.getContext().getCoordinateReferenceSystem());
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope envelope, AffineTransform transform) {
        if (transform == null) {
            throw new NullPointerException("Transform is required");
        }
        if (this.hints != null) {
            graphics.setRenderingHints(this.hints);
        }
        if (graphics == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.renderingStopRequested = false;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Affine Transform is " + transform);
        }
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(transform);
            transform = atg;
        }
        try {
            this.setScaleDenominator(this.computeScale(envelope, this.context.getCoordinateReferenceSystem(), paintArea, transform, this.rendererHints));
        }
        catch (Exception e) {
            LOGGER.throwing("RendererUtilities", "calculateScale(envelope, coordinateReferenceSystem, imageWidth, imageHeight, hints)", e);
            this.setScaleDenominator(1.0 / transform.getScaleX());
        }
        MapLayer[] layers = this.context.getLayers();
        CoordinateReferenceSystem destinationCrs = this.context.getCoordinateReferenceSystem();
        this.labelCache.start();
        this.labelCache.clear();
        if (this.labelCache instanceof LabelCacheImpl) {
            ((LabelCacheImpl)this.labelCache).setLabelRenderingMode(LabelCacheImpl.LabelRenderingMode.valueOf((String)this.getTextRenderingMethod()));
        }
        for (int i = 0; i < layers.length; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.renderingStopRequested) {
                return;
            }
            if (this.layerIndexInfo[i] == STREAMING_RENDERER_INFO) {
                this.renderWithStreamingRenderer(currLayer, graphics, paintArea, envelope, transform);
                continue;
            }
            this.labelCache.startLayer("" + i);
            ReferencedEnvelope bbox = envelope;
            try {
                DefaultQuery query;
                MathTransform mt;
                FeatureSource featureSource;
                block22: {
                    featureSource = currLayer.getFeatureSource();
                    if (featureSource instanceof DirectoryFeatureSource) {
                        featureSource = ((DirectoryFeatureSource)featureSource).unwrap();
                    }
                    GeometryDescriptor geom = featureSource.getSchema().getGeometryDescriptor();
                    CoordinateReferenceSystem dataCRS = this.getForceCRSHint() == null ? geom.getCoordinateReferenceSystem() : this.getForceCRSHint();
                    mt = null;
                    CoordinateOperation op = null;
                    if (dataCRS != null) {
                        try {
                            if (dataCRS != null) {
                                op = CRS.getCoordinateOperationFactory(true).createOperation(dataCRS, destinationCrs);
                                mt = op.getMathTransform();
                                bbox = bbox.transform(dataCRS, true, 10);
                                break block22;
                            }
                            LOGGER.log(Level.WARNING, "Could not reproject the bounding boxes as data CRS was null, proceeding in non reprojecting mode");
                            op = null;
                            mt = null;
                        }
                        catch (Exception e) {
                            this.fireErrorEvent(e);
                            LOGGER.log(Level.WARNING, "Could not reproject the bounding boxes, proceeding in non reprojecting mode", e);
                            op = null;
                            mt = null;
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "Data CRS is unknown, proceeding in non reprojecting mode");
                    }
                }
                MathTransform at = ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new GeneralMatrix(transform));
                mt = mt == null ? at : ReferencingFactoryFinder.getMathTransformFactory(null).createConcatenatedTransform(mt, at);
                ShapefileDataStore ds = (ShapefileDataStore)featureSource.getDataStore();
                Transaction transaction = Transaction.AUTO_COMMIT;
                if (featureSource instanceof FeatureStore) {
                    transaction = ((SimpleFeatureStore)featureSource).getTransaction();
                }
                if ((query = new DefaultQuery(currLayer.getQuery())).getFilter() != null) {
                    FilterTransformer transformer = new FilterTransformer(mt);
                    Filter transformedFilter = (Filter)query.getFilter().accept((FilterVisitor)transformer, null);
                    query.setFilter(transformedFilter);
                }
                this.processStylers(graphics, ds, (Query)query, (Envelope)bbox, paintArea, mt, currLayer.getStyle(), this.layerIndexInfo[i], transaction, "" + i);
            }
            catch (Exception exception) {
                Exception e = new Exception("Exception rendering layer " + currLayer, exception);
                this.fireErrorEvent(e);
            }
            this.labelCache.endLayer("" + i, graphics, paintArea);
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        }
    }

    private String getTextRenderingMethod() {
        if (this.rendererHints == null) {
            return this.textRenderingModeDEFAULT;
        }
        String result = (String)this.rendererHints.get(TEXT_RENDERING_KEY);
        if (result == null) {
            return this.textRenderingModeDEFAULT;
        }
        return result;
    }

    private String getScaleComputationMethod() {
        if (this.rendererHints == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        String result = (String)this.rendererHints.get(SCALE_COMPUTATION_METHOD_KEY);
        if (result == null) {
            return this.scaleComputationMethodDEFAULT;
        }
        return result;
    }

    private double computeScale(ReferencedEnvelope envelope, CoordinateReferenceSystem crs, Rectangle paintArea, AffineTransform worldToScreen, Map hints) {
        if (this.getScaleComputationMethod().equals(SCALE_ACCURATE)) {
            try {
                return RendererUtilities.calculateScale((ReferencedEnvelope)envelope, (int)paintArea.width, (int)paintArea.height, (Map)hints);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        if (XAffineTransform.getRotation(worldToScreen) != 0.0) {
            return RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (AffineTransform)worldToScreen, (Map)hints);
        }
        return RendererUtilities.calculateOGCScale((ReferencedEnvelope)envelope, (int)paintArea.width, (Map)hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWithStreamingRenderer(MapLayer layer, Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope envelope, AffineTransform transform) {
        RenderListener listener;
        block5: {
            DefaultMapContext context = null;
            listener = null;
            try {
                context = new DefaultMapContext(new MapLayer[]{layer}, envelope.getCoordinateReferenceSystem());
                this.delegate = new StreamingRenderer();
                this.delegate.setContext((MapContext)context);
                this.delegate.setJava2DHints(this.getJava2DHints());
                HashMap<String, IntegratingLabelCache> rendererHints2 = new HashMap<String, IntegratingLabelCache>(this.getRendererHints() != null ? this.getRendererHints() : Collections.EMPTY_MAP);
                rendererHints2.put(LABEL_CACHE_KEY, new IntegratingLabelCache(this.labelCache));
                this.delegate.setRendererHints(rendererHints2);
                listener = new RenderListener(){

                    public void featureRenderer(SimpleFeature feature) {
                        ShapefileRenderer.this.fireFeatureRenderedEvent(feature);
                    }

                    public void errorOccurred(Exception e) {
                        ShapefileRenderer.this.fireErrorEvent(e);
                    }
                };
                this.delegate.addRenderListener(listener);
                this.delegate.paint(graphics, paintArea, envelope, transform);
                if (context == null) break block5;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    context.clearLayerList();
                }
                if (listener != null && this.delegate != null) {
                    this.delegate.removeRenderListener(listener);
                }
                this.delegate = null;
                throw throwable;
            }
            context.clearLayerList();
        }
        if (listener != null && this.delegate != null) {
            this.delegate.removeRenderListener(listener);
        }
        this.delegate = null;
    }

    private CoordinateReferenceSystem getForceCRSHint() {
        if (this.rendererHints == null) {
            return null;
        }
        Object crs = this.rendererHints.get(FORCE_CRS_KEY);
        if (crs instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)crs;
        }
        return null;
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.context.getCoordinateReferenceSystem()));
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea, AffineTransform worldToScreen) {
        this.paint(graphics, paintArea, new ReferencedEnvelope(mapArea, this.context.getCoordinateReferenceSystem()), worldToScreen);
    }

    static {
        ShapefileRenderer.COORDS[0] = new Coordinate(0.0, 0.0);
        ShapefileRenderer.COORDS[1] = new Coordinate(5.0, 0.0);
        ShapefileRenderer.COORDS[2] = new Coordinate(5.0, 5.0);
        ShapefileRenderer.COORDS[3] = new Coordinate(0.0, 5.0);
        ShapefileRenderer.COORDS[4] = new Coordinate(0.0, 0.0);
        LINE_GEOM = geomFactory.createLinearRing(COORDS);
        MULTI_LINE_GEOM = geomFactory.createMultiLineString(new LineString[]{LINE_GEOM});
        POLYGON_GEOM = geomFactory.createPolygon(LINE_GEOM, new LinearRing[0]);
        MULTI_POLYGON_GEOM = geomFactory.createMultiPolygon(new Polygon[]{POLYGON_GEOM});
        POINT_GEOM = geomFactory.createPoint(COORDS[2]);
        MULTI_POINT_GEOM = geomFactory.createMultiPoint(COORDS);
        DEFAULT_LISTENER = new DefaultRenderListener();
        STREAMING_RENDERER_INFO = new IndexInfo(IndexType.NONE, null);
        NUM_SAMPLES = 200;
    }

    private static class DefaultRenderListener
    implements RenderListener {
        private DefaultRenderListener() {
        }

        public void featureRenderer(SimpleFeature feature) {
        }

        public void errorOccurred(Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

