/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.captcha;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.wicket.IClusterable;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaptchaImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private final IModel<String> challengeId;
    private Integer challengeIdhashCode;
    private List<CharAttributes> charAttsList;
    private final List<String> fontNames = Arrays.asList("Helvetica", "Arial", "Courier");
    private final int fontSize;
    private final int fontStyle;
    private int height = 0;
    private transient SoftReference<byte[]> imageData;
    private final int margin;
    private int width = 0;

    private static int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    private static String randomString(int min, int max) {
        int num = CaptchaImageResource.randomInt(min, max);
        byte[] b = new byte[num];
        for (int i = 0; i < num; ++i) {
            b[i] = (byte)CaptchaImageResource.randomInt(97, 122);
        }
        return new String(b);
    }

    public CaptchaImageResource() {
        this(CaptchaImageResource.randomString(6, 8));
    }

    public CaptchaImageResource(String challengeId) {
        this((IModel<String>)new Model((Serializable)((Object)challengeId)));
    }

    public CaptchaImageResource(IModel<String> challengeId) {
        this(challengeId, 48, 30);
    }

    public CaptchaImageResource(IModel<String> challengeId, int fontSize, int margin) {
        this.challengeId = challengeId;
        this.fontStyle = 1;
        this.fontSize = fontSize;
        this.margin = margin;
    }

    public CaptchaImageResource(String challengeId, int fontSize, int margin) {
        this((IModel<String>)new Model((Serializable)((Object)challengeId)), fontSize, margin);
    }

    public final String getChallengeId() {
        return (String)this.challengeId.getObject();
    }

    public final IModel<String> getChallengeIdModel() {
        return this.challengeId;
    }

    public final void invalidate() {
        this.challengeIdhashCode = null;
        this.imageData = null;
    }

    protected final byte[] getImageData() {
        byte[] data = null;
        if (this.imageData != null && this.challengeIdhashCode != null && this.challengeIdhashCode.equals(((String)this.challengeId.getObject()).hashCode())) {
            data = this.imageData.get();
        }
        if (data == null) {
            data = this.render();
            this.imageData = new SoftReference<byte[]>(data);
            this.setLastModifiedTime(Time.now());
        }
        return data;
    }

    private Font getFont(String fontName) {
        return new Font(fontName, this.fontStyle, this.fontSize);
    }

    private final byte[] render() {
        Shape shape;
        AffineTransform textAt;
        TextLayout text;
        this.width = this.margin * 2;
        this.height = this.margin * 2;
        char[] chars = ((String)this.challengeId.getObject()).toCharArray();
        this.charAttsList = new ArrayList<CharAttributes>();
        for (int i = 0; i < chars.length; ++i) {
            String fontName = this.fontNames.get(CaptchaImageResource.randomInt(0, this.fontNames.size()));
            double rotation = Math.toRadians(CaptchaImageResource.randomInt(-35, 35));
            int rise = CaptchaImageResource.randomInt(this.margin / 2, this.margin);
            Random ran = new Random();
            double shearX = ran.nextDouble() * 0.2;
            double shearY = ran.nextDouble() * 0.2;
            CharAttributes cf = new CharAttributes(chars[i], fontName, rotation, rise, shearX, shearY);
            this.charAttsList.add(cf);
            text = new TextLayout(chars[i] + "", this.getFont(fontName), new FontRenderContext(null, false, false));
            textAt = new AffineTransform();
            textAt.rotate(rotation);
            textAt.shear(shearX, shearY);
            shape = text.getOutline(textAt);
            this.width += (int)shape.getBounds2D().getWidth();
            if (this.height >= (int)shape.getBounds2D().getHeight() + rise) continue;
            this.height = (int)shape.getBounds2D().getHeight() + rise;
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D gfx = (Graphics2D)image.getGraphics();
        gfx.setBackground(Color.WHITE);
        int curWidth = this.margin;
        for (int i = 0; i < this.charAttsList.size(); ++i) {
            CharAttributes cf = this.charAttsList.get(i);
            text = new TextLayout(cf.getChar() + "", this.getFont(cf.getName()), gfx.getFontRenderContext());
            textAt = new AffineTransform();
            textAt.translate(curWidth, this.height - cf.getRise());
            textAt.rotate(cf.getRotation());
            textAt.shear(cf.getShearX(), cf.getShearY());
            shape = text.getOutline(textAt);
            curWidth = (int)((double)curWidth + shape.getBounds().getWidth());
            gfx.setXORMode(Color.BLACK);
            gfx.fill(shape);
        }
        int dx = CaptchaImageResource.randomInt(this.width, 2 * this.width);
        int dy = CaptchaImageResource.randomInt(this.width, 2 * this.height);
        int x = CaptchaImageResource.randomInt(0, this.width / 2);
        int y = CaptchaImageResource.randomInt(0, this.height / 2);
        gfx.setXORMode(Color.BLACK);
        gfx.setStroke(new BasicStroke(CaptchaImageResource.randomInt(this.fontSize / 8, this.fontSize / 2)));
        gfx.drawOval(x, y, dx, dy);
        WritableRaster rstr = image.getRaster();
        int[] vColor = new int[3];
        int[] oldColor = new int[3];
        Random vRandom = new Random(System.currentTimeMillis());
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                rstr.getPixel(x, y, oldColor);
                vColor[0] = 0 + (int)(Math.floor((double)vRandom.nextFloat() * 1.03) * 255.0);
                vColor[0] = vColor[0] ^ 170 + (int)(vRandom.nextFloat() * 80.0f);
                vColor[0] = vColor[0] ^ oldColor[0];
                vColor[1] = vColor[0];
                vColor[2] = vColor[0];
                rstr.setPixel(x, y, vColor);
            }
        }
        return this.toImageData(image);
    }

    private static final class CharAttributes
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final char c;
        private final String name;
        private final int rise;
        private final double rotation;
        private final double shearX;
        private final double shearY;

        CharAttributes(char c, String name, double rotation, int rise, double shearX, double shearY) {
            this.c = c;
            this.name = name;
            this.rotation = rotation;
            this.rise = rise;
            this.shearX = shearX;
            this.shearY = shearY;
        }

        char getChar() {
            return this.c;
        }

        String getName() {
            return this.name;
        }

        int getRise() {
            return this.rise;
        }

        double getRotation() {
            return this.rotation;
        }

        double getShearX() {
            return this.shearX;
        }

        double getShearY() {
            return this.shearY;
        }
    }
}

