/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;

public class RepGroupProtocol
extends TextProtocol {
    public static final String VERSION = "2";
    public final TextProtocol.MessageOp ENSURE_NODE = new TextProtocol.MessageOp("ENREQ", EnsureNode.class);
    public final TextProtocol.MessageOp ENSURE_OK = new TextProtocol.MessageOp("ENRESP", EnsureOK.class);
    public final TextProtocol.MessageOp REMOVE_MEMBER = new TextProtocol.MessageOp("RMREQ", RemoveMember.class);
    public final TextProtocol.MessageOp GROUP_REQ = new TextProtocol.MessageOp("GREQ", GroupRequest.class);
    public final TextProtocol.MessageOp GROUP_RESP = new TextProtocol.MessageOp("GRESP", GroupResponse.class);
    public final TextProtocol.MessageOp RGFAIL_RESP = new TextProtocol.MessageOp("GRFAIL", Fail.class);

    public RepGroupProtocol(String groupName, NameIdPair nameIdPair, RepImpl repImpl) {
        super(VERSION, groupName, nameIdPair, repImpl);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.ENSURE_NODE, this.ENSURE_OK, this.REMOVE_MEMBER, this.GROUP_REQ, this.GROUP_RESP, this.RGFAIL_RESP});
        this.setTimeouts(repImpl, RepParams.REP_GROUP_OPEN_TIMEOUT, RepParams.REP_GROUP_READ_TIMEOUT);
    }

    public class Fail
    extends TextProtocol.Fail {
        final FailReason reason;

        public Fail(FailReason reason, String message) {
            super(RepGroupProtocol.this, message);
            this.reason = reason;
        }

        public Fail(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.reason = FailReason.valueOf(this.nextPayloadToken());
        }

        public String wireFormat() {
            return super.wireFormat() + "|" + this.reason.toString();
        }

        public FailReason getReason() {
            return this.reason;
        }
    }

    public class GroupResponse
    extends TextProtocol.ResponseMessage {
        final RepGroupImpl group;

        public GroupResponse(RepGroupImpl group) {
            super(RepGroupProtocol.this);
            this.group = group;
        }

        public GroupResponse(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.group = RepGroupImpl.deserializeHex(tokens, this.getCurrentTokenPosition());
        }

        public RepGroupImpl getGroup() {
            return this.group;
        }

        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.GROUP_RESP;
        }

        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.group.serializeHex();
        }
    }

    public class EnsureOK
    extends TextProtocol.OK {
        private final NameIdPair nameIdPair;

        public EnsureOK(NameIdPair nameIdPair) {
            super(RepGroupProtocol.this);
            this.nameIdPair = nameIdPair;
        }

        public EnsureOK(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.nameIdPair = new NameIdPair(this.nextPayloadToken(), Integer.parseInt(this.nextPayloadToken()));
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.ENSURE_OK;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nameIdPair.getName() + "|" + Integer.toString(this.nameIdPair.getId());
        }
    }

    public class EnsureNode
    extends TextProtocol.RequestMessage {
        final RepNodeImpl node;

        public EnsureNode(RepNodeImpl node) {
            super(RepGroupProtocol.this);
            assert (node.getType() == NodeType.MONITOR);
            this.node = node;
        }

        public EnsureNode(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
            this.node = RepGroupImpl.hexDeserializeNode(this.nextPayloadToken());
        }

        public RepNodeImpl getNode() {
            return this.node;
        }

        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.ENSURE_NODE;
        }

        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + RepGroupImpl.serializeHex(this.node);
        }
    }

    public class GroupRequest
    extends TextProtocol.RequestMessage {
        public GroupRequest() {
            super(RepGroupProtocol.this);
        }

        public GroupRequest(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, line, tokens);
        }

        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.GROUP_REQ;
        }

        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix();
        }
    }

    public class RemoveMember
    extends TextProtocol.RequestMessage {
        final String nodeName;

        public RemoveMember(String memberName) {
            super(RepGroupProtocol.this);
            this.nodeName = memberName;
        }

        public RemoveMember(String requestLine, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(RepGroupProtocol.this, requestLine, tokens);
            this.nodeName = this.nextPayloadToken();
        }

        public TextProtocol.MessageOp getOp() {
            return RepGroupProtocol.this.REMOVE_MEMBER;
        }

        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailReason {
        DEFAULT,
        MEMBER_NOT_FOUND,
        IS_MASTER;

    }
}

