/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.FileHandleSource;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileSource;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogBufferPool;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LSNStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class LogManager {
    private static final String DEBUG_NAME = LogManager.class.getName();
    protected LogBufferPool logBufferPool;
    protected Latch logWriteLatch;
    private final boolean doChecksumOnRead;
    private final FileManager fileManager;
    protected EnvironmentImpl envImpl;
    private final boolean readOnly;
    private final int readBufferSize;
    private long lastLsnAtRecovery = -1L;
    private final StatGroup stats;
    private final LongStat nRepeatFaultReads;
    private final LongStat nTempBufferWrites;
    private final LSNStat endOfLog;
    private TestHook readHook;
    private final Queue<LazyQueueEntry> lazyLogQueue = new ConcurrentLinkedQueue<LazyQueueEntry>();

    public LogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        this.envImpl = envImpl;
        this.fileManager = envImpl.getFileManager();
        DbConfigManager configManager = envImpl.getConfigManager();
        this.readOnly = readOnly;
        this.logBufferPool = new LogBufferPool(this.fileManager, envImpl);
        this.doChecksumOnRead = configManager.getBoolean(EnvironmentParams.LOG_CHECKSUM_READ);
        this.logWriteLatch = new Latch(DEBUG_NAME);
        this.readBufferSize = configManager.getInt(EnvironmentParams.LOG_FAULT_READ_SIZE);
        this.stats = new StatGroup("I/O", "Log file opens, fsyncs, reads, writes, cache misses.");
        this.nRepeatFaultReads = new LongStat(this.stats, LogStatDefinition.LOGMGR_REPEAT_FAULT_READS);
        this.nTempBufferWrites = new LongStat(this.stats, LogStatDefinition.LOGMGR_TEMP_BUFFER_WRITES);
        this.endOfLog = new LSNStat(this.stats, LogStatDefinition.LOGMGR_END_OF_LOG);
    }

    public boolean getChecksumOnRead() {
        return this.doChecksumOnRead;
    }

    public long getLastLsnAtRecovery() {
        return this.lastLsnAtRecovery;
    }

    public void setLastLsnAtRecovery(long lastLsnAtRecovery) {
        this.lastLsnAtRecovery = lastLsnAtRecovery;
    }

    public void resetPool(DbConfigManager configManager) throws DatabaseException {
        this.logBufferPool.reset(configManager);
    }

    public long logForceFlush(LogEntry entry, boolean fsyncRequired, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, fsyncRequired, false, false, -1L, null, repContext);
    }

    public long logForceFlip(LogEntry entry) throws DatabaseException {
        return this.log(entry, Provisional.NO, true, false, true, false, -1L, null, ReplicationContext.NO_REPLICATE);
    }

    public long log(LogEntry entry, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, Provisional.NO, false, false, false, false, -1L, null, repContext);
    }

    public void logLazily(LogEntry entry, ReplicationContext repContext) {
        this.lazyLogQueue.add(new LazyQueueEntry(entry, repContext));
    }

    public long log(LogEntry entry, boolean isProvisional, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, isProvisional ? Provisional.YES : Provisional.NO, false, false, false, backgroundIO, oldNodeLsn, nodeDb, repContext);
    }

    public long log(LogEntry entry, Provisional provisional, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        return this.log(entry, provisional, false, false, false, backgroundIO, oldNodeLsn, nodeDb, repContext);
    }

    private long log(LogEntry entry, Provisional provisional, boolean flushRequired, boolean fsyncRequired, boolean forceNewLogFile, boolean backgroundIO, long oldNodeLsn, DatabaseImpl nodeDb, ReplicationContext repContext) throws DatabaseException {
        LogItem item = new LogItem();
        item.entry = entry;
        item.provisional = provisional;
        item.oldLsn = oldNodeLsn;
        item.repContext = repContext;
        LogContext context = new LogContext();
        context.flushRequired = flushRequired;
        context.fsyncRequired = fsyncRequired;
        context.forceNewLogFile = forceNewLogFile;
        context.backgroundIO = backgroundIO;
        context.nodeDb = nodeDb;
        this.log(item, context);
        return item.newLsn;
    }

    public void log(LogItem item, LogContext context) throws DatabaseException {
        this.multiLog(new LogItem[]{item}, context);
    }

    public void multiLog(LogItem[] itemArray, LogContext context) throws DatabaseException {
        if (this.readOnly || itemArray.length == 0) {
            return;
        }
        try {
            LazyQueueEntry lqe = this.lazyLogQueue.poll();
            while (lqe != null) {
                LogItem item = new LogItem();
                item.entry = lqe.entry;
                item.provisional = Provisional.NO;
                item.oldLsn = -1L;
                item.repContext = lqe.repContext;
                LogContext lqeContext = new LogContext();
                lqeContext.flushRequired = false;
                lqeContext.fsyncRequired = false;
                lqeContext.forceNewLogFile = false;
                lqeContext.backgroundIO = false;
                lqeContext.nodeDb = null;
                this.serialLog(new LogItem[]{item}, lqeContext);
                lqe = this.lazyLogQueue.poll();
            }
            for (LogItem item : itemArray) {
                LogEntry logEntry = item.entry;
                item.oldSize = logEntry.getLastLoggedSize();
                if (!logEntry.getLogType().marshallOutsideLatch()) continue;
                item.header = new LogEntryHeader(logEntry, item.provisional, item.repContext);
                item.buffer = this.marshallIntoBuffer(item.header, logEntry);
            }
            this.serialLog(itemArray, context);
        }
        catch (BufferOverflowException e) {
            throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        if (context.fsyncRequired) {
            this.fileManager.groupSync();
        }
        for (LogItem item : itemArray) {
            if (!item.repContext.inReplicationStream()) continue;
            assert (item.header.getVLSN() != null) : "Unexpected null vlsn: " + item.header + " " + item.repContext;
            this.envImpl.registerVLSN(item);
        }
        this.envImpl.getCheckpointer().wakeupAfterWrite();
        if (context.wakeupCleaner) {
            this.envImpl.getUtilizationTracker().activateCleaner();
        }
        if (context.backgroundIO) {
            this.envImpl.updateBackgroundWrites(context.totalNewSize, this.logBufferPool.getLogBufferSize());
        }
    }

    abstract void serialLog(LogItem[] var1, LogContext var2) throws IOException, DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialLogInternal(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        LogItem firstItem = itemArray[0];
        LogItem lastItem = itemArray[itemArray.length - 1];
        for (LogItem item : itemArray) {
            Object var25_23;
            int entrySize;
            boolean marshallOutsideLatch = item.buffer != null;
            boolean isFirstItem = item == firstItem;
            boolean isLastItem = item == lastItem;
            LogEntryType entryType = item.entry.getLogType();
            if (item.oldLsn != -1L) {
                if (context.obsoleteDupsAllowed) {
                    tracker.countObsoleteNodeDupsAllowed(item.oldLsn, entryType, item.oldSize, context.nodeDb);
                } else {
                    tracker.countObsoleteNode(item.oldLsn, entryType, item.oldSize, context.nodeDb);
                }
            }
            if (marshallOutsideLatch) {
                entrySize = item.buffer.limit();
                assert (item.header != null);
            } else {
                assert (item.header == null);
                item.header = new LogEntryHeader(item.entry, item.provisional, item.repContext);
                entrySize = item.header.getSize() + item.header.getItemSize();
            }
            if (isFirstItem && context.forceNewLogFile) {
                this.fileManager.forceNewLogFile();
            }
            boolean flippedFile = this.fileManager.bumpLsn(entrySize);
            long currentLsn = -1L;
            boolean usedTemporaryBuffer = false;
            boolean success = false;
            try {
                Object var23_22;
                currentLsn = this.fileManager.getLastUsedLsn();
                if (tracker.countNewLogEntry(currentLsn, entryType, entrySize, context.nodeDb)) {
                    context.wakeupCleaner = true;
                }
                if (item.entry.isDeleted()) {
                    tracker.countObsoleteNodeInexact(currentLsn, entryType, entrySize, context.nodeDb);
                }
                if (!marshallOutsideLatch) {
                    assert (item.buffer == null);
                    item.buffer = this.marshallIntoBuffer(item.header, item.entry);
                }
                if (entrySize != item.buffer.limit()) {
                    throw EnvironmentFailureException.unexpectedState("Logged entry entrySize= " + entrySize + " but marshalledSize=" + item.buffer.limit() + " type=" + entryType + " currentLsn=" + DbLsn.getNoFormatString(currentLsn));
                }
                LogBuffer useLogBuffer = this.logBufferPool.getWriteBuffer(entrySize, flippedFile);
                item.buffer = item.header.addPostMarshallingInfo(this.envImpl, item.buffer, this.fileManager.getPrevEntryOffset(), item.repContext);
                useLogBuffer.latchForWrite();
                try {
                    ByteBuffer useBuffer = useLogBuffer.getDataBuffer();
                    if (useBuffer.capacity() - useBuffer.position() < entrySize) {
                        this.fileManager.writeLogBuffer(new LogBuffer(item.buffer, currentLsn), false);
                        usedTemporaryBuffer = true;
                        assert (useBuffer.position() == 0);
                        this.nTempBufferWrites.increment();
                    } else {
                        useBuffer.put(item.buffer);
                    }
                    var23_22 = null;
                    useLogBuffer.release();
                }
                catch (Throwable throwable) {
                    var23_22 = null;
                    useLogBuffer.release();
                    throw throwable;
                }
                success = true;
                var25_23 = null;
                if (!success) {
                    this.fileManager.restoreLastPosition();
                    if (item.header.getVLSN() != null) {
                        this.envImpl.decrementVLSN();
                    }
                }
            }
            catch (Throwable throwable) {
                var25_23 = null;
                if (!success) {
                    this.fileManager.restoreLastPosition();
                    if (item.header.getVLSN() != null) {
                        this.envImpl.decrementVLSN();
                    }
                }
                throw throwable;
            }
            if (!usedTemporaryBuffer) {
                this.logBufferPool.writeCompleted(currentLsn, isLastItem && context.flushRequired, context.fsyncRequired);
            }
            item.entry.postLogWork(currentLsn);
            item.newLsn = currentLsn;
            context.totalNewSize += entrySize;
        }
        if (context.packedObsoleteInfo != null) {
            context.packedObsoleteInfo.countObsoleteInfo(tracker, context.nodeDb);
        }
        if (context.obsoleteWriteLockInfo != null) {
            for (WriteLockInfo info : context.obsoleteWriteLockInfo) {
                tracker.countObsoleteNode(info.getAbortLsn(), null, info.getAbortLogSize(), info.getAbortDb());
            }
        }
    }

    private ByteBuffer marshallIntoBuffer(LogEntryHeader header, LogEntry entry) {
        int entrySize = header.getSize() + header.getItemSize();
        ByteBuffer destBuffer = ByteBuffer.allocate(entrySize);
        header.writeToLog(destBuffer);
        entry.writeEntry(header, destBuffer);
        destBuffer.flip();
        return destBuffer;
    }

    ByteBuffer putIntoBuffer(LogEntry entry, long prevLogEntryOffset) {
        LogEntryHeader header = new LogEntryHeader(entry, Provisional.NO, ReplicationContext.NO_REPLICATE);
        assert (entry.getLogType() != LogEntryType.LOG_LN_TRANSACTIONAL);
        ByteBuffer destBuffer = this.marshallIntoBuffer(header, entry);
        return header.addPostMarshallingInfo(this.envImpl, destBuffer, prevLogEntryOffset, ReplicationContext.NO_REPLICATE);
    }

    public LogEntry getLogEntry(long lsn) throws FileNotFoundException {
        return this.getLogEntry(lsn, false).getEntry();
    }

    public LogEntry getLogEntryAllowInvisibleAtRecovery(long lsn) throws FileNotFoundException {
        return this.getLogEntry(lsn, this.envImpl.isInInit()).getEntry();
    }

    public WholeEntry getLogEntryAllowInvisible(long lsn) throws FileNotFoundException {
        return this.getLogEntry(lsn, true);
    }

    private WholeEntry getLogEntry(long lsn, boolean invisibleReadAllowed) throws FileNotFoundException {
        this.envImpl.checkIfInvalid();
        try {
            LogSource logSource = this.getLogSource(lsn);
            return this.getLogEntryFromLogSource(lsn, logSource, invisibleReadAllowed);
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
    }

    public LogEntry getLogEntryHandleFileNotFound(long lsn) throws DatabaseException {
        try {
            return this.getLogEntry(lsn);
        }
        catch (FileNotFoundException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
        }
    }

    LogEntry getLogEntryAllowChecksumException(long lsn) throws ChecksumException, FileNotFoundException, DatabaseException {
        return this.getLogEntryFromLogSource(lsn, this.getLogSource(lsn), false).getEntry();
    }

    LogEntry getLogEntryAllowChecksumException(long lsn, RandomAccessFile file, int logVersion) throws ChecksumException, DatabaseException {
        return this.getLogEntryFromLogSource(lsn, new FileSource(file, this.readBufferSize, this.fileManager, DbLsn.getFileNumber(lsn), logVersion), false).getEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WholeEntry getLogEntryFromLogSource(long lsn, LogSource logSource, boolean invisibleReadAllowed) throws ChecksumException, DatabaseException {
        WholeEntry wholeEntry;
        block14: {
            try {
                long fileOffset = DbLsn.getFileOffset(lsn);
                ByteBuffer entryBuffer = logSource.getBytes(fileOffset);
                if (entryBuffer.remaining() < 14) {
                    throw new ChecksumException("Incomplete log entry header, size=" + entryBuffer.remaining() + " lsn=" + DbLsn.getNoFormatString(lsn));
                }
                LogEntryHeader header = new LogEntryHeader(entryBuffer, logSource.getLogVersion());
                if (header.isVariableLength()) {
                    if (entryBuffer.remaining() < header.getVariablePortionSize()) {
                        throw new ChecksumException("Incomplete log entry header, size=" + entryBuffer.remaining() + " varSize=" + header.getVariablePortionSize() + " lsn=" + DbLsn.getNoFormatString(lsn));
                    }
                    header.readVariablePortion(entryBuffer);
                }
                ChecksumValidator validator = null;
                if (this.doChecksumOnRead) {
                    int itemStart = entryBuffer.position();
                    if (header.isInvisible()) {
                        LogEntryHeader.turnOffInvisible(entryBuffer, itemStart - header.getSize());
                    }
                    validator = new ChecksumValidator();
                    int headerSizeMinusChecksum = header.getSizeMinusChecksum();
                    entryBuffer.position(itemStart - headerSizeMinusChecksum);
                    validator.update(entryBuffer, headerSizeMinusChecksum);
                    entryBuffer.position(itemStart);
                }
                int itemSize = header.getItemSize();
                if (entryBuffer.remaining() < itemSize) {
                    entryBuffer = logSource.getBytes(fileOffset + (long)header.getSize(), itemSize);
                    this.nRepeatFaultReads.increment();
                }
                if (this.doChecksumOnRead) {
                    validator.update(entryBuffer, itemSize);
                    validator.validate(header.getChecksum(), lsn);
                }
                if (header.isInvisible() && !invisibleReadAllowed) {
                    throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Read invisible log entry at " + DbLsn.getNoFormatString(lsn) + " " + header);
                }
                assert (LogEntryType.isValidType(header.getType())) : "Read non-valid log entry type: " + header.getType();
                LogEntry logEntry = LogEntryType.findType(header.getType()).getNewLogEntry();
                logEntry.readEntry(header, entryBuffer, true);
                if (this.readHook != null) {
                    try {
                        this.readHook.doIOHook();
                    }
                    catch (IOException e) {
                        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
                    }
                }
                wholeEntry = new WholeEntry(header, logEntry);
                Object var14_13 = null;
                if (logSource == null) break block14;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var14_14 = null;
                    if (logSource == null) break block15;
                    logSource.release();
                }
                throw throwable;
            }
            logSource.release();
        }
        return wholeEntry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getByteBufferFromLog(long lsn) throws DatabaseException {
        ByteBuffer byteBuffer;
        this.envImpl.checkIfInvalid();
        LogSource logSource = null;
        try {
            try {
                logSource = this.getLogSource(lsn);
                long fileOffset = DbLsn.getFileOffset(lsn);
                ByteBuffer entryBuffer = logSource.getBytes(fileOffset);
                int startingPosition = entryBuffer.position();
                int amountRemaining = entryBuffer.remaining();
                assert (amountRemaining >= 22);
                LogEntryHeader header = new LogEntryHeader(entryBuffer, logSource.getLogVersion());
                int totalSize = header.getSize() + header.getItemSize();
                if (amountRemaining < totalSize) {
                    entryBuffer = logSource.getBytes(fileOffset, totalSize);
                    this.nRepeatFaultReads.increment();
                }
                entryBuffer.position(startingPosition);
                ByteBuffer singleEntryBuffer = ByteBuffer.allocate(totalSize);
                entryBuffer.limit(startingPosition + totalSize);
                singleEntryBuffer.put(entryBuffer);
                singleEntryBuffer.position(0);
                byteBuffer = singleEntryBuffer;
                Object var14_13 = null;
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
            }
            catch (ChecksumException e) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            logSource.release();
            throw throwable;
        }
        logSource.release();
        return byteBuffer;
    }

    public Object getEntry(long lsn) throws FileNotFoundException, DatabaseException {
        LogEntry entry = this.getLogEntry(lsn);
        return entry.getMainItem();
    }

    public Object getEntryHandleFileNotFound(long lsn) {
        LogEntry entry = this.getLogEntryHandleFileNotFound(lsn);
        return entry.getMainItem();
    }

    public LogSource getLogSource(long lsn) throws FileNotFoundException, ChecksumException, DatabaseException {
        LogBuffer logBuffer = this.logBufferPool.getReadBufferByLsn(lsn);
        if (logBuffer == null) {
            try {
                long fileNum = DbLsn.getFileNumber(lsn);
                return new FileHandleSource(this.fileManager.getFileHandle(fileNum), this.readBufferSize, this.fileManager);
            }
            catch (DatabaseException e) {
                e.addErrorMessage("lsn= " + DbLsn.getNoFormatString(lsn));
                throw e;
            }
        }
        return logBuffer;
    }

    public LogBuffer getReadBufferByLsn(long lsn) {
        assert (DbLsn.getFileOffset(lsn) != 0L) : "Read of lsn " + DbLsn.getNoFormatString(lsn) + " is illegal because file header entry is not in the log buffer";
        return this.logBufferPool.getReadBufferByLsn(lsn);
    }

    public void flush() throws DatabaseException {
        if (!this.readOnly) {
            this.flushInternal();
            this.fileManager.syncLogEnd();
        }
    }

    public void flushNoSync() throws DatabaseException {
        if (!this.readOnly) {
            this.flushInternal();
        }
    }

    abstract void flushInternal() throws DatabaseException;

    public StatGroup loadStats(StatsConfig config) throws DatabaseException {
        if (!config.getFast()) {
            this.loadEndOfLogStat();
        }
        StatGroup copyStats = this.stats.cloneGroup(config.getClear());
        copyStats.addAll(this.logBufferPool.loadStats(config));
        copyStats.addAll(this.fileManager.loadStats(config));
        return copyStats;
    }

    public abstract TrackedFileSummary getUnflushableTrackedSummary(long var1) throws DatabaseException;

    TrackedFileSummary getUnflushableTrackedSummaryInternal(long file) {
        return this.envImpl.getUtilizationTracker().getUnflushableTrackedSummary(file);
    }

    public abstract void removeTrackedFile(TrackedFileSummary var1) throws DatabaseException;

    protected void removeTrackedFileInternal(TrackedFileSummary tfs) {
        tfs.reset();
    }

    public abstract void countObsoleteNode(long var1, LogEntryType var3, int var4, DatabaseImpl var5, boolean var6) throws DatabaseException;

    void countObsoleteNodeInternal(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb, boolean countExact) {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        if (countExact) {
            tracker.countObsoleteNode(lsn, type, size, nodeDb);
        } else {
            tracker.countObsoleteNodeInexact(lsn, type, size, nodeDb);
        }
    }

    public abstract void countObsoleteNodeDupsAllowed(long var1, LogEntryType var3, int var4, DatabaseImpl var5) throws DatabaseException;

    void countObsoleteNodeDupsAllowedInternal(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        tracker.countObsoleteNodeDupsAllowed(lsn, type, size, nodeDb);
    }

    public abstract void transferToUtilizationTracker(LocalUtilizationTracker var1) throws DatabaseException;

    void transferToUtilizationTrackerInternal(LocalUtilizationTracker localTracker) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        localTracker.transferToUtilizationTracker(tracker);
    }

    public abstract void countObsoleteDb(DatabaseImpl var1) throws DatabaseException;

    void countObsoleteDbInternal(DatabaseImpl db) {
        db.countObsoleteDb(this.envImpl.getUtilizationTracker(), -1L);
    }

    public abstract boolean removeDbFileSummary(DatabaseImpl var1, Long var2) throws DatabaseException;

    boolean removeDbFileSummaryInternal(DatabaseImpl db, Long fileNum) {
        return db.removeDbFileSummary(fileNum);
    }

    public abstract void loadEndOfLogStat() throws DatabaseException;

    void loadEndOfLogStatInternal() {
        this.endOfLog.set(this.fileManager.getLastUsedLsn());
    }

    public void setReadHook(TestHook hook) {
        this.readHook = hook;
    }

    private static class LazyQueueEntry {
        private final LogEntry entry;
        private final ReplicationContext repContext;

        private LazyQueueEntry(LogEntry entry, ReplicationContext repContext) {
            this.entry = entry;
            this.repContext = repContext;
        }
    }
}

