/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.tree.Key;
import com.sleepycat.util.keyrange.KeyRange;
import java.io.Serializable;

public class DatabaseEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] data;
    private int dlen = 0;
    private int doff = 0;
    private int offset = 0;
    private int size = 0;
    private boolean partial = false;
    public static int MAX_DUMP_BYTES = 100;

    public String toString() {
        StringBuffer sb = new StringBuffer("<DatabaseEntry");
        if (this.partial) {
            sb.append(" partial=\"true");
            sb.append("\" doff=\"").append(this.doff);
            sb.append("\" dlen=\"").append(this.dlen);
            sb.append("\"");
        }
        sb.append(" offset=\"").append(this.offset);
        sb.append("\" size=\"").append(this.size);
        sb.append("\" data=\"").append(this.dumpData());
        if (this.size - 1 > MAX_DUMP_BYTES) {
            sb.append(" ... ").append(this.size - MAX_DUMP_BYTES + " bytes not shown ");
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public DatabaseEntry() {
    }

    public DatabaseEntry(byte[] data) {
        this.data = data;
        if (data != null) {
            this.size = data.length;
        }
    }

    public DatabaseEntry(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.size = data == null ? 0 : data.length;
    }

    public void setData(byte[] data, int offset, int size) {
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    public void setPartial(int doff, int dlen, boolean partial) {
        this.setPartialOffset(doff);
        this.setPartialLength(dlen);
        this.setPartial(partial);
    }

    public int getPartialLength() {
        return this.dlen;
    }

    public void setPartialLength(int dlen) {
        this.dlen = dlen;
    }

    public int getPartialOffset() {
        return this.doff;
    }

    public void setPartialOffset(int doff) {
        this.doff = doff;
    }

    public boolean getPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    String dumpData() {
        return Key.DUMP_TYPE.dumpByteArray(KeyRange.getByteArray(this, MAX_DUMP_BYTES));
    }

    public boolean equals(Object o) {
        if (!(o instanceof DatabaseEntry)) {
            return false;
        }
        DatabaseEntry e = (DatabaseEntry)o;
        if ((this.partial || e.partial) && (this.partial != e.partial || this.dlen != e.dlen || this.doff != e.doff)) {
            return false;
        }
        if (this.data == null && e.data == null) {
            return true;
        }
        if (this.data == null || e.data == null) {
            return false;
        }
        if (this.size != e.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[this.offset + i] == e.data[e.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        if (this.data != null) {
            for (int i = 0; i < this.size; ++i) {
                hash += this.data[this.offset + i];
            }
        }
        return hash;
    }
}

