/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.wms.web.publish.LegendGraphicAjaxUpdater;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleNameRenderer;
import org.geoserver.wms.web.publish.StylesModel;

public class WMSLayerConfig
extends LayerConfigurationPanel {
    public WMSLayerConfig(String id, IModel layerModel) {
        super(id, layerModel);
        this.add(new Component[]{new CheckBox("queryableEnabled", (IModel)new PropertyModel((Object)layerModel, "queryable"))});
        WebMarkupContainer styleContainer = new WebMarkupContainer("styles");
        this.add(new Component[]{styleContainer});
        ResourceInfo resource = ((LayerInfo)layerModel.getObject()).getResource();
        styleContainer.setVisible(resource instanceof CoverageInfo || resource instanceof FeatureTypeInfo);
        StylesModel styles = new StylesModel();
        PropertyModel defaultStyleModel = new PropertyModel((Object)layerModel, "defaultStyle");
        DropDownChoice defaultStyle = new DropDownChoice("defaultStyle", (IModel)defaultStyleModel, (IModel)styles, (IChoiceRenderer)new StyleChoiceRenderer());
        defaultStyle.setRequired(true);
        styleContainer.add(new Component[]{defaultStyle});
        Image defStyleImg = new Image("defaultStyleLegendGraphic");
        defStyleImg.setOutputMarkupId(true);
        styleContainer.add(new Component[]{defStyleImg});
        String wmsURL = this.getRequest().getRelativePathPrefixToContextRoot();
        wmsURL = wmsURL + (wmsURL.endsWith("/") ? "wms?" : "/wms?");
        final LegendGraphicAjaxUpdater defaultStyleUpdater = new LegendGraphicAjaxUpdater(wmsURL, defStyleImg, (IModel)defaultStyleModel);
        defaultStyle.add(new IBehavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                defaultStyleUpdater.updateStyleImage(target);
            }
        }});
        LiveCollectionModel stylesModel = LiveCollectionModel.set((IModel)new PropertyModel((Object)layerModel, "styles"));
        Palette extraStyles = new Palette("extraStyles", (IModel)stylesModel, (IModel)styles, new StyleNameRenderer(), 10, false){

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.availableHeader"));
            }
        };
        styleContainer.add(new Component[]{extraStyles});
        TextField renderingBuffer = new TextField("renderingBuffer", (IModel)new MapModel((IModel)new PropertyModel((Object)layerModel, "metadata"), "buffer"), Integer.class);
        renderingBuffer.add((IValidator)NumberValidator.minimum((long)0L));
        styleContainer.add(new Component[]{renderingBuffer});
        this.add(new Component[]{new TextField("wmsPath", (IModel)new PropertyModel((Object)layerModel, "path"))});
    }
}

