/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PolygonNotOverlappingLineValidation
extends PolygonLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureSource polySource1 = (SimpleFeatureSource)layers.get(this.getPolygonTypeRef());
        SimpleFeatureSource polySource2 = (SimpleFeatureSource)layers.get(this.getRestrictedLineTypeRef());
        Object[] poly1 = polySource1.getFeatures().toArray();
        Object[] poly2 = polySource2.getFeatures().toArray();
        if (!envelope.contains((Envelope)polySource1.getBounds())) {
            results.error((SimpleFeature)poly1[0], "Polygon Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)polySource2.getBounds())) {
            results.error((SimpleFeature)poly1[0], "Restricted Polygon Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < poly1.length; ++i) {
            SimpleFeature tmp = (SimpleFeature)poly1[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            for (int j = 0; j < poly2.length; ++j) {
                SimpleFeature tmp2 = (SimpleFeature)poly2[j];
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (!gt2.touches(gt)) continue;
                return false;
            }
        }
        return true;
    }
}

