/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import simple.http.serve.Content;
import simple.http.serve.Context;
import simple.http.serve.FileIndexer;
import simple.http.serve.FileLocator;
import simple.http.serve.Format;
import simple.http.serve.FormatFactory;
import simple.http.serve.Index;
import simple.http.serve.Locator;
import simple.http.serve.StreamContent;
import simple.util.FileProperties;
import simple.util.net.Path;

public class FileContext
implements Context {
    protected FileIndexer indexer;
    protected Locator locator;
    protected Format format;
    protected File base;

    public FileContext() {
        this(new File("."));
    }

    public FileContext(File base) {
        this(base, base);
    }

    public FileContext(File base, File path) {
        this(base, new File[]{path});
    }

    public FileContext(File base, File[] list) {
        this(base, new FileLocator(list));
    }

    public FileContext(File base, Locator locator) {
        this.indexer = new FileIndexer(locator, base);
        this.format = FormatFactory.getInstance();
        this.locator = locator;
        this.base = base;
    }

    public String getBasePath() {
        return this.base.getAbsolutePath();
    }

    public String getRealPath(String target) {
        return this.getIndex(target).getRealPath();
    }

    public String getRequestPath(String target) {
        return this.getIndex(target).getRequestPath();
    }

    public File getFile(String target) {
        return this.getIndex(target).getFile();
    }

    public File getDirectory(String target) {
        return this.getIndex(target).getDirectory();
    }

    public Path getPath(String target) {
        return this.getIndex(target).getPath();
    }

    public Locale getLocale(String target) {
        return this.getIndex(target).getLocale();
    }

    public String getContentType(String target) {
        return this.getIndex(target).getContentType();
    }

    public String getName(String target) {
        return this.getIndex(target).getName();
    }

    public Index getIndex(String target) {
        return this.indexer.getIndex(target);
    }

    public Content getContent(String target) throws IOException {
        return new StreamContent(this, target);
    }

    public Properties getProperties(String target) throws IOException {
        return new FileProperties(this.getFile(target));
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Format getFormat() {
        return this.format;
    }
}

