/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.generated.parsers.ParseException;

public class CQLException
extends ParseException {
    private static final long serialVersionUID = 8873756073711225699L;
    protected Throwable cause = null;
    private String cqlSource = null;
    private IToken currentToken = null;

    public CQLException(String message, IToken token, Throwable cause, String cqlSource) {
        super(message);
        assert (message != null) : "message can not be null";
        assert (cqlSource != null) : "cqlSource can not be null";
        this.currentToken = token;
        this.cause = cause;
        this.cqlSource = cqlSource;
    }

    public CQLException(String message, IToken token, String cqlSource) {
        this(message, token, null, cqlSource);
    }

    public CQLException(String message, String cqlSource) {
        this(message, null, null, cqlSource);
    }

    public CQLException(String message) {
        this(message, null, null, "");
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getMessage() {
        return super.getMessage() + ". Parsing : " + this.cqlSource + ". Current Token : \"" + ((Object)this.currentToken).toString() + "\"";
    }

    public String getSyntaxError() {
        if (this.currentToken == null) {
            return this.getMessage();
        }
        StringBuffer msg = new StringBuffer(this.cqlSource);
        msg.append('\n');
        IToken curToken = this.currentToken;
        while (curToken.hasNext()) {
            curToken = curToken.next();
        }
        int column = curToken.beginColumn() - 1;
        for (int i = 0; i < column; ++i) {
            msg.append(' ');
        }
        msg.append('^').append('\n');
        msg.append(super.getMessage());
        return msg.toString();
    }
}

