/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.GML2Profile;
import org.geoserver.wfs.xml.GML3Profile;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geoserver.wfs.xml.XSProfile;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureTypeSchemaBuilder {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    WFSInfo wfs;
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;
    protected List profiles;
    protected String gmlNamespace;
    protected String gmlSchemaLocation;
    protected String baseType;
    protected String substitutionGroup;
    protected Map<String, String> describeFeatureTypeParams;
    protected String gmlPrefix;
    protected Configuration xmlConfiguration;

    protected FeatureTypeSchemaBuilder(GeoServer gs) {
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
        this.catalog = gs.getCatalog();
        this.resourceLoader = gs.getCatalog().getResourceLoader();
        this.profiles = new ArrayList();
        this.profiles.add(new XSProfile());
    }

    public XSDSchema build(FeatureTypeInfo featureTypeInfo, String baseUrl) throws IOException {
        return this.build(new FeatureTypeInfo[]{featureTypeInfo}, baseUrl);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl) throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema schema = factory.createXSDSchema();
        schema.setSchemaForSchemaQNamePrefix("xsd");
        schema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setElementFormDefault(XSDForm.get((int)0));
        HashMap<String, ArrayList<FeatureTypeInfo>> ns2featureTypeInfos = new HashMap<String, ArrayList<FeatureTypeInfo>>();
        for (int i = 0; i < featureTypeInfos.length; ++i) {
            String prefix = featureTypeInfos[i].getNamespace().getPrefix();
            ArrayList<FeatureTypeInfo> l = (ArrayList<FeatureTypeInfo>)ns2featureTypeInfos.get(prefix);
            if (l == null) {
                l = new ArrayList<FeatureTypeInfo>();
            }
            l.add(featureTypeInfos[i]);
            ns2featureTypeInfos.put(prefix, l);
        }
        if (baseUrl == null) {
            baseUrl = this.wfs.getSchemaBaseURL();
        }
        if (ns2featureTypeInfos.entrySet().size() == 1) {
            String targetPrefix = (String)ns2featureTypeInfos.keySet().iterator().next();
            String targetNamespace = this.catalog.getNamespaceByPrefix(targetPrefix).getURI();
            schema.setTargetNamespace(targetNamespace);
            schema.getQNamePrefixToNamespaceMap().put(targetPrefix, targetNamespace);
            for (NamespaceInfo nameSpaceinfo : this.catalog.getNamespaces()) {
                if (schema.getQNamePrefixToNamespaceMap().containsKey(nameSpaceinfo.getPrefix())) continue;
                schema.getQNamePrefixToNamespaceMap().put(nameSpaceinfo.getPrefix(), nameSpaceinfo.getURI());
            }
            try {
                FeatureType featureType = featureTypeInfos[0].getFeatureType();
                Object schemaUri = featureType.getUserData().get("schemaURI");
                if (schemaUri != null) {
                    assert (schemaUri instanceof String);
                    if (!this.findTypeInSchema(featureTypeInfos[0], schema, factory)) {
                        this.addInclude(schema, factory, targetNamespace, (String)schemaUri);
                    }
                    return schema;
                }
            }
            catch (IOException e) {
                logger.warning("Unable to get schema location for feature type '" + featureTypeInfos[0].getPrefixedName() + "'. Reason: '" + e.getMessage() + "'. Building the schema manually instead.");
            }
            XSDImport imprt = factory.createXSDImport();
            imprt.setNamespace(this.gmlNamespace);
            imprt.setSchemaLocation(ResponseUtils.buildSchemaURL((String)baseUrl, (String)this.gmlSchemaLocation));
            XSDSchema gmlSchema = this.gmlSchema();
            imprt.setResolvedSchema(gmlSchema);
            schema.getContents().add((Object)imprt);
            schema.getQNamePrefixToNamespaceMap().put(this.gmlPrefix, this.gmlNamespace);
            schema.getQNamePrefixToNamespaceMap().put("gml", "http://www.opengis.net/gml");
            for (int i = 0; i < featureTypeInfos.length; ++i) {
                try {
                    this.buildSchemaContent(featureTypeInfos[i], schema, factory, baseUrl);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not build xml schema for type: " + featureTypeInfos[i].getName(), e);
                }
            }
        } else {
            ArrayList<String> importedNamespaces = new ArrayList<String>(ns2featureTypeInfos.size() + 1);
            for (Map.Entry entry : ns2featureTypeInfos.entrySet()) {
                String prefix = (String)entry.getKey();
                List types = (List)entry.getValue();
                StringBuffer typeNames = new StringBuffer();
                for (FeatureTypeInfo info : types) {
                    FeatureType featureType = info.getFeatureType();
                    Object schemaUri = featureType.getUserData().get("schemaURI");
                    if (schemaUri != null) {
                        assert (schemaUri instanceof String);
                        String namespaceURI = featureType.getName().getNamespaceURI();
                        this.addImport(schema, factory, namespaceURI, (String)schemaUri, importedNamespaces);
                        importedNamespaces.add(namespaceURI);
                        continue;
                    }
                    typeNames.append(info.getPrefixedName()).append(",");
                }
                if (typeNames.length() <= 0) continue;
                typeNames.setLength(typeNames.length() - 1);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.describeFeatureTypeParams);
                params.put("typeName", typeNames.toString().trim());
                String schemaLocation = ResponseUtils.buildURL((String)baseUrl, (String)"wfs", params, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
                String namespace = this.catalog.getNamespaceByPrefix(prefix).getURI();
                XSDImport imprt = factory.createXSDImport();
                imprt.setNamespace(namespace);
                imprt.setSchemaLocation(schemaLocation);
                schema.getContents().add((Object)imprt);
            }
        }
        return schema;
    }

    private void addInclude(XSDSchema schema, XSDFactory factory, String nsURI, String schemaLocation) {
        XSDInclude xsdInclude = factory.createXSDInclude();
        xsdInclude.setSchemaLocation(schemaLocation);
        schema.getContents().add((Object)xsdInclude);
        schema.updateElement();
    }

    private void addImport(XSDSchema schema, XSDFactory factory, String nsURI, String schemaURI, List<String> importedNamespaces) {
        if (!importedNamespaces.contains(nsURI)) {
            XSDImport xsdImport = factory.createXSDImport();
            xsdImport.setNamespace(nsURI);
            xsdImport.setSchemaLocation(schemaURI);
            schema.getContents().add((Object)xsdImport);
            importedNamespaces.add(nsURI);
        }
    }

    public XSDSchema addApplicationTypes(XSDSchema wfsSchema) throws IOException {
        List featureTypeInfos = this.catalog.getFeatureTypes();
        for (FeatureTypeInfo meta : featureTypeInfos) {
            if (!meta.enabled()) continue;
            XSDSchema schema = this.build(new FeatureTypeInfo[]{meta}, null);
            String prefix = meta.getNamespace().getPrefix();
            String namespaceURI = meta.getNamespace().getURI();
            wfsSchema.getQNamePrefixToNamespaceMap().put(prefix, namespaceURI);
            Iterator t = schema.getTypeDefinitions().iterator();
            while (t.hasNext()) {
                wfsSchema.getTypeDefinitions().add(t.next());
            }
            Iterator e = schema.getElementDeclarations().iterator();
            while (e.hasNext()) {
                wfsSchema.getElementDeclarations().add(e.next());
            }
            for (Map.Entry entry : schema.getQNamePrefixToNamespaceMap().entrySet()) {
                if (wfsSchema.getQNamePrefixToNamespaceMap().containsKey(entry.getKey())) continue;
                wfsSchema.getQNamePrefixToNamespaceMap().put(entry.getKey(), entry.getValue());
            }
        }
        return wfsSchema;
    }

    boolean findTypeInSchema(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory) throws IOException {
        String ws = featureTypeMeta.getStore().getWorkspace().getName();
        String ds = featureTypeMeta.getStore().getName();
        String name = featureTypeMeta.getName();
        File schemaFile = null;
        try {
            schemaFile = this.resourceLoader.find("workspaces/" + ws + "/" + ds + "/" + name + "/schema.xsd");
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (schemaFile != null) {
            List resolvers = Schemas.findSchemaLocationResolvers((Configuration)this.xmlConfiguration);
            ArrayList<1> locators = new ArrayList<1>();
            locators.add(new XSDSchemaLocator(){

                public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                    if (FeatureTypeSchemaBuilder.this.gmlNamespace.equals(namespaceURI)) {
                        return FeatureTypeSchemaBuilder.this.gmlSchema();
                    }
                    return null;
                }
            });
            XSDSchema ftSchema = null;
            try {
                ftSchema = Schemas.parse((String)schemaFile.getAbsolutePath(), locators, (List)resolvers);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to parse schema: " + schemaFile.getAbsolutePath(), e);
            }
            if (ftSchema != null) {
                if (ftSchema.getSchemaForSchemaQNamePrefix() != null) {
                    schema.setSchemaForSchemaQNamePrefix(ftSchema.getSchemaForSchemaQNamePrefix());
                }
                EList contents = ftSchema.getContents();
                boolean hasElement = false;
                Iterator i = contents.iterator();
                while (i.hasNext()) {
                    XSDElementDeclaration element;
                    XSDImport imprt;
                    XSDSchemaContent content = (XSDSchemaContent)i.next();
                    content.setElement(null);
                    if (content instanceof XSDImport && this.gmlNamespace.equals((imprt = (XSDImport)content).getNamespace())) {
                        i.remove();
                    }
                    if (content instanceof XSDElementDeclaration) {
                        if (this.contains((XSDNamedComponent)content, (List)schema.getElementDeclarations())) {
                            i.remove();
                        }
                    } else if (content instanceof XSDTypeDefinition && this.contains((XSDNamedComponent)content, (List)schema.getTypeDefinitions())) {
                        i.remove();
                    }
                    if (hasElement || !(content instanceof XSDElementDeclaration) || !name.equals((element = (XSDElementDeclaration)content).getName()) || !featureTypeMeta.getNamespace().getURI().equals(element.getTargetNamespace())) continue;
                    hasElement = true;
                }
                if (!hasElement) {
                    XSDElementDeclaration element = factory.createXSDElementDeclaration();
                    element.setName(featureTypeMeta.getName());
                    element.setTargetNamespace(featureTypeMeta.getNamespace().getURI());
                    element.setSubstitutionGroupAffiliation(schema.resolveElementDeclaration(this.gmlNamespace, this.substitutionGroup));
                    ArrayList<XSDComplexTypeDefinition> candidates = new ArrayList<XSDComplexTypeDefinition>();
                    block5: for (XSDTypeDefinition type : ftSchema.getTypeDefinitions()) {
                        if (!(type instanceof XSDComplexTypeDefinition)) continue;
                        for (XSDTypeDefinition base = type.getBaseType(); base != null; base = base.getBaseType()) {
                            if (this.baseType.equals(base.getName()) && this.gmlNamespace.equals(base.getTargetNamespace())) {
                                candidates.add((XSDComplexTypeDefinition)type);
                                continue block5;
                            }
                            if (base.equals(base.getBaseType())) continue block5;
                        }
                    }
                    if (candidates.size() != 1) {
                        throw new IllegalStateException("Could not determine feature type for generated element. Must specify explicitly in schema.xsd.");
                    }
                    element.setTypeDefinition((XSDTypeDefinition)candidates.get(0));
                    schema.getContents().add((Object)element);
                }
                schema.getContents().addAll((Collection)contents);
                schema.updateElement();
                return true;
            }
        }
        return false;
    }

    private void buildSchemaContent(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory, String baseUrl) throws IOException {
        if (!this.findTypeInSchema(featureTypeMeta, schema, factory)) {
            XSDComplexTypeDefinition xsdComplexType = this.buildComplexSchemaContent((ComplexType)featureTypeMeta.getFeatureType(), schema, factory);
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(featureTypeMeta.getName());
            element.setSubstitutionGroupAffiliation(schema.resolveElementDeclaration(this.gmlNamespace, this.substitutionGroup));
            element.setTypeDefinition((XSDTypeDefinition)xsdComplexType);
            schema.getContents().add((Object)element);
            schema.updateElement();
        }
    }

    private XSDComplexTypeDefinition buildComplexSchemaContent(ComplexType complexType, XSDSchema schema, XSDFactory factory) {
        XSDComplexTypeDefinition xsdComplexType = factory.createXSDComplexTypeDefinition();
        xsdComplexType.setName(complexType.getName().getLocalPart() + "Type");
        xsdComplexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        xsdComplexType.setBaseTypeDefinition((XSDTypeDefinition)schema.resolveComplexTypeDefinition(this.gmlNamespace, this.baseType));
        XSDModelGroup group = factory.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        for (PropertyDescriptor pd : complexType.getDescriptors()) {
            AttributeDescriptor attribute;
            if (!(pd instanceof AttributeDescriptor) || this.filterAttributeType(attribute = (AttributeDescriptor)pd)) continue;
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            Name typeName = attribute.getType().getName();
            if (!typeName.getLocalPart().equals(XS.ANYTYPE.getLocalPart()) || !typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                if (attribute.getType() instanceof ComplexType) {
                    if (schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart()) == null) {
                        this.buildComplexSchemaContent((ComplexType)attribute.getType(), schema, factory);
                    }
                } else {
                    Class binding = attribute.getType().getBinding();
                    typeName = this.findTypeName(binding);
                    if (typeName == null) {
                        throw new NullPointerException("Could not find a type for property: " + attribute.getName() + " of type: " + binding.getName());
                    }
                }
            }
            XSDTypeDefinition type = schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart());
            element.setTypeDefinition(type);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        xsdComplexType.setContent((XSDComplexTypeContent)particle);
        schema.getContents().add((Object)xsdComplexType);
        return xsdComplexType;
    }

    boolean contains(XSDNamedComponent c, List l) {
        boolean contains = false;
        Iterator i = l.iterator();
        while (!contains && i.hasNext()) {
            XSDNamedComponent e = (XSDNamedComponent)i.next();
            if (!e.getName().equals(c.getName())) continue;
            if (e.getTargetNamespace() == null) {
                contains = c.getTargetNamespace() == null;
                continue;
            }
            contains = e.getTargetNamespace().equals(c.getTargetNamespace());
        }
        return contains;
    }

    Name findTypeName(Class binding) {
        for (TypeMappingProfile profile : this.profiles) {
            Name name = profile.name(binding);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    protected abstract XSDSchema gmlSchema();

    protected boolean filterAttributeType(AttributeDescriptor attribute) {
        return "name".equals(attribute.getName()) || "description".equals(attribute.getName()) || "boundedBy".equals(attribute.getName());
    }

    public static final class GML3
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml3Schema;

        public GML3(GeoServer gs) {
            super(gs);
            this.profiles.add(new GML3Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/3.1.1/base/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.1.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new org.geotools.gml3.GMLConfiguration();
        }

        protected XSDSchema gmlSchema() {
            if (gml3Schema == null) {
                gml3Schema = this.xmlConfiguration.schema();
            }
            return gml3Schema;
        }

        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "metaDataProperty".equals(attribute.getName()) || "location".equals(attribute.getName());
        }
    }

    public static final class GML2
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml2Schema;

        public GML2(GeoServer gs) {
            super(gs);
            this.profiles.add(new GML2Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/2.1.2/feature.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeParams = ResponseUtils.params((String[])new String[]{"request", "DescribeFeatureType", "version", "1.0.0", "service", "WFS"});
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new GMLConfiguration();
        }

        protected XSDSchema gmlSchema() {
            if (gml2Schema == null) {
                gml2Schema = this.xmlConfiguration.schema();
            }
            return gml2Schema;
        }
    }
}

