/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class DescribeFeatureType {
    private Catalog catalog;
    private WFSInfo wfs;

    public DescribeFeatureType(WFSInfo wfs, Catalog catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setWFS(WFSInfo wfs) {
        this.wfs = wfs;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeType request) throws WFSException {
        ArrayList names = new ArrayList(request.getTypeName());
        boolean citeConformance = this.getWFS().isCiteCompliant();
        if (!citeConformance) {
            ArrayList<QName> hackedNames = new ArrayList<QName>(names.size());
            NamespaceInfo defaultNameSpace = this.catalog.getDefaultNamespace();
            if (defaultNameSpace == null) {
                throw new IllegalStateException("No default namespace configured in GeoServer");
            }
            String defaultNsUri = defaultNameSpace.getURI();
            for (QName name : names) {
                String nsUri = name.getNamespaceURI();
                if ("http://www.opengis.net/wfs".equals(nsUri)) {
                    name = new QName(defaultNsUri, name.getLocalPart());
                }
                hackedNames.add(name);
            }
            names = hackedNames;
        }
        List infos = this.catalog.getFeatureTypes();
        ArrayList<FeatureTypeInfo> requested = new ArrayList<FeatureTypeInfo>();
        if (!names.isEmpty()) {
            block1: for (QName name : names) {
                for (FeatureTypeInfo meta : infos) {
                    if (!meta.enabled()) continue;
                    String namespace = meta.getNamespace().getURI();
                    String local = meta.getName();
                    if (!namespace.equals(name.getNamespaceURI()) || !local.equals(name.getLocalPart())) continue;
                    requested.add(meta);
                    continue block1;
                }
                String msg = "Could not find type: " + name;
                if (citeConformance) {
                    msg = msg + ". \nStrict WFS protocol conformance is being applied.\nMake sure the type name is correctly qualified";
                }
                throw new WFSException(msg);
            }
        } else {
            for (FeatureTypeInfo ftInfo : infos) {
                if (!ftInfo.enabled()) continue;
                requested.add(ftInfo);
            }
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

