/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.util.io.SerializableChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IObjectStreamFactory {
    public ObjectInputStream newObjectInputStream(InputStream var1) throws IOException;

    public ObjectOutputStream newObjectOutputStream(OutputStream var1) throws IOException;

    static class 3 {
        static /* synthetic */ Class class$org$apache$wicket$util$io$IObjectStreamFactory$DefaultObjectStreamFactory;
    }

    public static final class DefaultObjectStreamFactory
    implements IObjectStreamFactory {
        private static final Logger log = LoggerFactory.getLogger((Class)(3.class$org$apache$wicket$util$io$IObjectStreamFactory$DefaultObjectStreamFactory == null ? (3.class$org$apache$wicket$util$io$IObjectStreamFactory$DefaultObjectStreamFactory = 3.class$("org.apache.wicket.util.io.IObjectStreamFactory$DefaultObjectStreamFactory")) : 3.class$org$apache$wicket$util$io$IObjectStreamFactory$DefaultObjectStreamFactory));

        public ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
            return new ObjectInputStream(this, in){
                private final /* synthetic */ DefaultObjectStreamFactory this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    try {
                        return super.resolveClass(desc);
                    }
                    catch (ClassNotFoundException ex1) {
                        Class<?> candidate;
                        block5: {
                            DefaultObjectStreamFactory.access$000().debug("Class not found by the object outputstream itself, trying the IClassResolver");
                            candidate = null;
                            try {
                                Application application = Application.get();
                                IApplicationSettings applicationSettings = application.getApplicationSettings();
                                IClassResolver classResolver = applicationSettings.getClassResolver();
                                candidate = classResolver.resolveClass(className);
                                if (candidate == null) {
                                    candidate = super.resolveClass(desc);
                                }
                            }
                            catch (WicketRuntimeException ex) {
                                if (!(ex.getCause() instanceof ClassNotFoundException)) break block5;
                                throw (ClassNotFoundException)ex.getCause();
                            }
                        }
                        return candidate;
                    }
                }
            };
        }

        public ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            return new ObjectOutputStream(this, oos){
                private final /* synthetic */ ObjectOutputStream val$oos;
                private final /* synthetic */ DefaultObjectStreamFactory this$0;
                {
                    this.this$0 = this$0;
                    this.val$oos = val$oos;
                }

                protected final void writeObjectOverride(Object obj) throws IOException {
                    try {
                        this.val$oos.writeObject(obj);
                    }
                    catch (IOException e) {
                        if (SerializableChecker.isAvailable()) {
                            new SerializableChecker((NotSerializableException)e).writeObject(obj);
                            throw e;
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        DefaultObjectStreamFactory.access$000().error("error writing object " + obj + ": " + e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }

                public void flush() throws IOException {
                    this.val$oos.flush();
                }

                public void close() throws IOException {
                    this.val$oos.close();
                }
            };
        }

        static /* synthetic */ Logger access$000() {
            return log;
        }
    }
}

