/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.resource.IPropertiesChangeListener;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.util.watch.ModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFactory
implements IPropertiesFactory {
    private static final Logger log = LoggerFactory.getLogger((Class)PropertiesFactory.class);
    private final List afterReloadListeners = new ArrayList();
    private final Map propertiesCache = new ConcurrentHashMap();
    private final Application application;

    public PropertiesFactory(Application application) {
        this.application = application;
    }

    public void addListener(IPropertiesChangeListener listener) {
        if (!this.afterReloadListeners.contains(listener)) {
            this.afterReloadListeners.add(listener);
        }
    }

    public final void clearCache() {
        this.propertiesCache.clear();
    }

    public Properties load(Class clazz, String path) {
        Properties properties = (Properties)this.propertiesCache.get(path);
        if (properties == null) {
            IResourceStream stream = this.application.getResourceSettings().getResourceStreamLocator().locate(clazz, path);
            if (stream != null) {
                properties = this.loadPropertiesFileAndWatchForChanges(path, stream);
            }
            if (properties == null) {
                this.propertiesCache.put(path, Properties.EMPTY_PROPERTIES);
            } else {
                this.propertiesCache.put(path, properties);
            }
        }
        if (properties == Properties.EMPTY_PROPERTIES) {
            properties = null;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties loadPropertiesFile(String key, IResourceStream resourceStream) {
        Properties props = (Properties)this.propertiesCache.get(key);
        if (props != null) {
            return props;
        }
        if (resourceStream == null) {
            props = new Properties(key, ValueMap.EMPTY_MAP);
        } else {
            ValueMap strings = null;
            try {
                try {
                    String ext;
                    String location;
                    BufferedInputStream in = new BufferedInputStream(resourceStream.getInputStream());
                    boolean loadAsXml = false;
                    if (resourceStream instanceof IFixedLocationResourceStream && (location = ((IFixedLocationResourceStream)((Object)resourceStream)).locationAsString()) != null && "xml".equals(ext = Strings.lastPathComponent(location, '.').toLowerCase())) {
                        loadAsXml = true;
                    }
                    java.util.Properties properties = new java.util.Properties();
                    if (loadAsXml) {
                        Streams.loadFromXml(properties, in);
                    } else {
                        properties.load(in);
                    }
                    strings = new ValueMap();
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String property = (String)enumeration.nextElement();
                        strings.put(property, properties.getProperty(property));
                    }
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (ResourceStreamNotFoundException e) {
                log.warn("Unable to find resource " + resourceStream, (Throwable)e);
                strings = ValueMap.EMPTY_MAP;
            }
            catch (IOException e) {
                log.warn("Unable to access resource " + resourceStream, (Throwable)e);
                strings = ValueMap.EMPTY_MAP;
            }
            props = new Properties(key, strings);
        }
        return props;
    }

    private final Properties loadPropertiesFileAndWatchForChanges(final String key, final IResourceStream resourceStream) {
        ModificationWatcher watcher = this.application.getResourceSettings().getResourceWatcher(true);
        if (watcher != null) {
            watcher.add(resourceStream, new IChangeListener(){

                public void onChange() {
                    log.info("A properties files has changed. Removing all entries from the cache. Resource: " + resourceStream);
                    PropertiesFactory.this.clearCache();
                    PropertiesFactory.this.application.getResourceSettings().getLocalizer().clearCache();
                    Iterator iter = PropertiesFactory.this.afterReloadListeners.iterator();
                    while (iter.hasNext()) {
                        IPropertiesChangeListener listener = (IPropertiesChangeListener)iter.next();
                        try {
                            listener.propertiesChanged(key);
                        }
                        catch (Throwable ex) {
                            log.error("PropertiesReloadListener has thrown an exception: " + ex.getMessage());
                        }
                    }
                }
            });
        }
        log.info("Loading properties files from " + resourceStream);
        return this.loadPropertiesFile(key, resourceStream);
    }

    protected final Map getCache() {
        return this.propertiesCache;
    }
}

