/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import org.apache.wicket.Application;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebResponse;

public final class EmptyAjaxRequestTarget
implements IRequestTarget {
    private static final int HASH = 26219491;
    private static final EmptyAjaxRequestTarget instance = new EmptyAjaxRequestTarget();

    private EmptyAjaxRequestTarget() {
    }

    public static final EmptyAjaxRequestTarget getInstance() {
        return instance;
    }

    public void respond(RequestCycle requestCycle) {
        WebResponse response = (WebResponse)requestCycle.getResponse();
        String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        response.setCharacterEncoding(encoding);
        response.setContentType("text/xml; charset=" + encoding);
        response.setDateHeader("Expires", System.currentTimeMillis());
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.write("<?xml version=\"1.0\" encoding=\"");
        response.write(encoding);
        response.write("\"?><ajax-response></ajax-response>");
    }

    public void detach(RequestCycle requestCycle) {
    }

    public boolean equals(Object obj) {
        return obj instanceof EmptyAjaxRequestTarget;
    }

    public int hashCode() {
        return 26219491;
    }

    public String toString() {
        return "EmptyAjaxRequestTarget";
    }
}

