/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResourceGuard
implements IPackageResourceGuard {
    private static final Logger log = LoggerFactory.getLogger((Class)PackageResourceGuard.class);
    private Set blockedExtensions = new HashSet(4);
    private Set blockedFiles = new HashSet(4);

    public PackageResourceGuard() {
        this.blockedExtensions.add("properties");
        this.blockedExtensions.add("class");
        this.blockedExtensions.add("java");
        this.blockedFiles.add("applicationContext.xml");
        this.blockedFiles.add("log4j.xml");
    }

    public boolean accept(Class scope, String path) {
        String absolutePath = Packages.absolutePath(scope, path);
        return this.acceptAbsolutePath(absolutePath);
    }

    protected boolean acceptAbsolutePath(String path) {
        int ixExtension = path.lastIndexOf(46);
        int len = path.length();
        String ext = ixExtension <= 0 || ixExtension == len || path.lastIndexOf(47) + 1 == ixExtension ? null : path.substring(ixExtension + 1).toLowerCase();
        if ("html".equals(ext) && this.getClass().getClassLoader().getResource(path.replaceAll("\\.html", ".class")) != null) {
            log.warn("Access denied to shared (static) resource because it is a Wicket markup file: " + path);
            return false;
        }
        if (!this.acceptExtension(ext)) {
            log.warn("Access denied to shared (static) resource because of the file extension: " + path);
            return false;
        }
        String filename = Strings.lastPathComponent(path, '/');
        if (!this.acceptFile(filename)) {
            log.warn("Access denied to shared (static) resource because of the file name: " + path);
            return false;
        }
        if (Strings.isEmpty(Application.get().getResourceSettings().getParentFolderPlaceholder()) && path.indexOf("..".toString()) > -1) {
            log.warn("Access to parent directories via '..' is by default disabled for shared resources: " + path);
            return false;
        }
        return true;
    }

    protected boolean acceptExtension(String extension) {
        return !this.blockedExtensions.contains(extension);
    }

    protected boolean acceptFile(String file) {
        return !this.blockedFiles.contains(file);
    }

    protected final Set getBlockedExtensions() {
        return this.blockedExtensions;
    }

    protected final Set getBlockedFiles() {
        return this.blockedFiles;
    }

    protected final void setBlockedExtensions(Set blockedExtensions) {
        this.blockedExtensions = blockedExtensions;
    }

    protected final void setBlockedFiles(Set blockedFiles) {
        this.blockedFiles = blockedFiles;
    }
}

