/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.server.ftp.FtpServer;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;

public class FtpData
extends Thread {
    private FtpServer server;
    private InetAddress address;
    private ServerSocket serverSocket;
    private volatile Socket socket;
    private boolean active;
    private int port;

    FtpData(FtpServer ftpServer, InetAddress inetAddress, ServerSocket serverSocket) {
        this.server = ftpServer;
        this.address = inetAddress;
        this.serverSocket = serverSocket;
    }

    FtpData(FtpServer ftpServer, InetAddress inetAddress, int n) {
        this.server = ftpServer;
        this.address = inetAddress;
        this.port = n;
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            FtpData ftpData = this;
            synchronized (ftpData) {
                Socket socket = this.serverSocket.accept();
                if (socket.getInetAddress().equals(this.address)) {
                    this.server.trace("Data connected:" + socket.getInetAddress() + " expected:" + this.address);
                    this.socket = socket;
                    this.notifyAll();
                } else {
                    this.server.trace("Data REJECTED:" + socket.getInetAddress() + " expected:" + this.address);
                    this.close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void connect() throws IOException {
        if (this.active) {
            this.socket = new Socket(this.address, this.port);
        } else {
            this.waitUntilConnected();
        }
    }

    private void waitUntilConnected() {
        while (this.serverSocket != null && this.socket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.server.trace("connected");
    }

    void close() {
        this.serverSocket = null;
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void receive(FileSystem fileSystem, String string) throws IOException, SQLException {
        this.connect();
        try {
            InputStream inputStream = this.socket.getInputStream();
            OutputStream outputStream = fileSystem.openFileOutputStream(string, false);
            IOUtils.copy(inputStream, outputStream);
            outputStream.close();
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void send(FileSystem fileSystem, String string, long l) throws IOException {
        this.connect();
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            InputStream inputStream = fileSystem.openFileInputStream(string);
            IOUtils.skipFully(inputStream, l);
            IOUtils.copy(inputStream, outputStream);
            inputStream.close();
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void send(byte[] byArray) throws IOException {
        this.connect();
        try {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(byArray);
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }
}

