/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPageBinary;
import org.h2.store.PageStore;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;

public class PageScanIndex
extends BaseIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private int headPos;
    private int nextKey;

    public PageScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2) throws SQLException {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            // empty if block
        }
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0) {
            return;
        }
        this.store = this.database.getPageStorage();
        if (n2 == -1 || n2 >= this.store.getPageCount()) {
            n2 = this.store.allocatePage();
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createDataPage());
            pageDataLeaf.write();
        } else {
            this.rowCount = this.getPage(n2).getLastKey();
        }
        this.headPos = n2;
        tableData.setRowCount(this.rowCount);
    }

    public void add(Session session, Row row) throws SQLException {
        row.setPos((int)this.rowCount);
        PageData pageData = this.getPage(this.headPos);
        int n = pageData.addRow(row);
        if (n != 0) {
            int n2 = pageData.getKey(n);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n3 = pageData.getPageId();
            int n4 = this.store.allocatePage();
            pageData2.setPageId(n4);
            pageData2.setParentPageId(this.headPos);
            pageData3.setParentPageId(this.headPos);
            PageDataNode pageDataNode = new PageDataNode(this, n3, 0, this.store.createDataPage());
            pageDataNode.init(pageData2, n2, pageData3);
            pageData2.write();
            pageData3.write();
            pageDataNode.write();
            pageData = pageDataNode;
        }
        ++this.rowCount;
    }

    PageData getPage(int n) throws SQLException {
        PageData pageData;
        DataPageBinary dataPageBinary = this.store.readPage(n);
        dataPageBinary.reset();
        int n2 = dataPageBinary.readInt();
        int n3 = dataPageBinary.readByte() & 0xFF;
        switch (n3) {
            case 2: 
            case 3: {
                pageData = new PageDataLeaf(this, n, n2, dataPageBinary);
                break;
            }
            case 4: {
                pageData = new PageDataNode(this, n, n2, dataPageBinary);
                break;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageData.read();
        return pageData;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public void close(Session session) throws SQLException {
        if (this.store != null) {
            this.store = null;
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.find();
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        long l = 10L * this.tableData.getRowCount(session) + 1000L;
        return l;
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.rowCount == 1L) {
            this.truncate(session);
        } else {
            PageData pageData = this.getPage(this.headPos);
            pageData.remove(row.getPos());
            --this.rowCount;
        }
    }

    public void remove(Session session) throws SQLException {
    }

    public void truncate(Session session) throws SQLException {
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this, this.headPos, 0, this.store.createDataPage());
        pageDataLeaf.write();
        this.rowCount = 0L;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Row getRow(Session session, int n) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.getRow(session, n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(DataPageBinary dataPageBinary) throws SQLException {
        return this.tableData.readRow(dataPageBinary);
    }
}

