/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.result.Row;
import org.h2.store.DataPageBinary;

abstract class PageData {
    protected final PageScanIndex index;
    protected final DataPageBinary data;
    protected int pageId;
    protected int parentPageId;
    protected int entryCount;
    protected int[] keys;

    PageData(PageScanIndex pageScanIndex, int n, int n2, DataPageBinary dataPageBinary) {
        this.index = pageScanIndex;
        this.pageId = n;
        this.parentPageId = n2;
        this.data = dataPageBinary;
    }

    int find(int n) {
        int n2 = 0;
        int n3 = this.entryCount;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.keys[n4];
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            if (n5 == n) {
                return n4;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    abstract void read() throws SQLException;

    abstract int addRow(Row var1) throws SQLException;

    abstract Cursor find() throws SQLException;

    abstract void write() throws SQLException;

    int getKey(int n) {
        return this.keys[n];
    }

    abstract PageData split(int var1) throws SQLException;

    void setPageId(int n) {
        this.pageId = n;
    }

    int getPageId() {
        return this.pageId;
    }

    abstract int getLastKey() throws SQLException;

    abstract PageDataLeaf getFirstLeaf() throws SQLException;

    void setParentPageId(int n) throws SQLException {
        this.parentPageId = n;
        this.remapChildren();
    }

    abstract void remapChildren() throws SQLException;

    abstract boolean remove(int var1) throws SQLException;

    abstract Row getRow(Session var1, int var2) throws SQLException;
}

