/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.config.meta.ServiceContact;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.config.meta.ServiceProvider;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.wmts.WMTSService;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMTSGetCapabilities {
    private static Log log = LogFactory.getLog(WMTSGetCapabilities.class);
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;
    private String baseUrl;

    protected WMTSGetCapabilities(TileLayerDispatcher tld, GridSetBroker gsb, HttpServletRequest servReq) {
        this.tld = tld;
        this.gsb = gsb;
        this.baseUrl = ServletUtils.stringFromMap(servReq.getParameterMap(), servReq.getCharacterEncoding(), "base_url");
        if (this.baseUrl != null) {
            this.baseUrl = this.encodeXmlChars(this.baseUrl);
        }
        if (this.baseUrl == null || this.baseUrl.length() == 0) {
            this.baseUrl = servReq.getRequestURL().toString();
        }
    }

    protected void writeResponse(HttpServletResponse response, RuntimeStats stats) {
        byte[] data = this.generateGetCapabilities().getBytes();
        response.setStatus(200);
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setCharacterEncoding("UTF-8");
        response.setContentLength(data.length);
        stats.log(data.length, Conveyor.CacheResult.OTHER);
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException" + ioe.getMessage()));
        }
    }

    private String generateGetCapabilities() {
        StringBuilder str = new StringBuilder();
        str.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        str.append("<Capabilities xmlns=\"http://www.opengis.net/wmts/1.0\"\n");
        str.append("xmlns:ows=\"http://www.opengis.net/ows/1.1\"\n");
        str.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n");
        str.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        str.append("xmlns:gml=\"http://www.opengis.net/gml\" ");
        str.append("xsi:schemaLocation=\"http://www.opengis.net/wmts/1.0 http://geowebcache.org/schema/opengis/wmts/1.0.0/wmtsGetCapabilities_response.xsd\"\n");
        str.append("version=\"1.0.0\">\n");
        this.serviceIdentification(str);
        this.serviceProvider(str);
        this.operationsMetadata(str);
        this.contents(str);
        str.append("<ServiceMetadataURL xlink:href=\"" + this.baseUrl + "?REQUEST=getcapabilities&amp;VERSION=1.0.0\"/>\n");
        str.append("</Capabilities>");
        return str.toString();
    }

    private void serviceIdentification(StringBuilder str) {
        ServiceInformation servInfo = this.tld.getServiceInformation();
        str.append("<ows:ServiceIdentification>\n");
        if (servInfo != null) {
            this.appendTag(str, "  ", "ows:Title", servInfo.title, "Web Map Tile Service - GeoWebCache");
            this.appendTag(str, "  ", "ows:Abstract", servInfo.description, null);
            if (servInfo != null && servInfo.keywords != null) {
                str.append("  <ows:Keywords>\n");
                Iterator<String> keywordIter = servInfo.keywords.iterator();
                while (keywordIter.hasNext()) {
                    this.appendTag(str, "    ", "ows:Keyword", keywordIter.next(), null);
                }
                str.append("  </ows:Keywords>\n");
            }
        } else {
            str.append("  <ows:Title>Web Map Tile Service - GeoWebCache</ows:Title>\n");
        }
        str.append("  <ows:ServiceType>OGC WMTS</ows:ServiceType>\n");
        str.append("  <ows:ServiceTypeVersion>1.0.0</ows:ServiceTypeVersion>\n");
        if (servInfo != null) {
            this.appendTag(str, "  ", "ows:Fees", servInfo.fees, null);
            this.appendTag(str, "  ", "ows:AccessConstraints", servInfo.accesConstraints, null);
        }
        str.append("</ows:ServiceIdentification>\n");
    }

    private void serviceProvider(StringBuilder str) {
        ServiceInformation servInfo = this.tld.getServiceInformation();
        ServiceProvider servProv = null;
        if (servInfo != null) {
            servProv = servInfo.serviceProvider;
        }
        str.append("<ows:ServiceProvider>\n");
        if (servProv != null) {
            ServiceContact servCont;
            this.appendTag(str, "  ", "ows:ProviderName", servProv.providerName, null);
            if (servProv.providerSite != null) {
                this.appendXlink(str, "  ", "ows:ProviderSite", servProv.providerSite);
            }
            if ((servCont = servProv.serviceContact) != null) {
                str.append("  <ows:ServiceContact>\n");
                this.appendTag(str, "    ", "ows:IndividualName", servCont.individualName, null);
                this.appendTag(str, "    ", "ows:PositionName", servCont.positionName, null);
                str.append("    <ows:ContactInfo>\n");
                if (servCont.phoneNumber != null || servCont.faxNumber != null) {
                    str.append("      <ows:Phone>\n");
                    this.appendTag(str, "      ", "ows:Voice", servCont.phoneNumber, null);
                    this.appendTag(str, "      ", "ows:Facsimile", servCont.faxNumber, null);
                    str.append("      </ows:Phone>\n");
                }
                str.append("      <ows:Address>\n");
                this.appendTag(str, "      ", "ows:DeliveryPoint", servCont.addressStreet, null);
                this.appendTag(str, "      ", "ows:City", servCont.addressCity, null);
                this.appendTag(str, "      ", "ows:AdministrativeArea", servCont.addressAdministrativeArea, null);
                this.appendTag(str, "      ", "ows:PostalCode", servCont.addressPostalCode, null);
                this.appendTag(str, "      ", "ows:Country", servCont.addressCountry, null);
                this.appendTag(str, "      ", "ows:ElectronicMailAddress", servCont.addressEmail, null);
                str.append("      </ows:Address>\n");
                str.append("    </ows:ContactInfo>\n");
                str.append("  </ows:ServiceContact>\n");
            }
        } else {
            this.appendTag(str, "  ", "ows:ProviderName", this.baseUrl, null);
            this.appendXlink(str, "  ", "ows:ProviderSite", this.baseUrl);
            str.append("  <ows:ServiceContact>\n");
            this.appendTag(str, "    ", "ows:IndividualName", "GeoWebCache User", null);
            str.append("  </ows:ServiceContact>\n");
        }
        str.append("</ows:ServiceProvider>\n");
    }

    private void operationsMetadata(StringBuilder str) {
        str.append("<ows:OperationsMetadata>\n");
        this.operation(str, "GetCapabilities", this.baseUrl);
        this.operation(str, "GetTile", this.baseUrl);
        this.operation(str, "GetFeatureInfo", this.baseUrl);
        str.append("</ows:OperationsMetadata>\n");
    }

    private void operation(StringBuilder str, String operationName, String baseUrl) {
        str.append("  <ows:Operation name=\"" + operationName + "\">\n");
        str.append("    <ows:DCP>\n");
        str.append("      <ows:HTTP>\n");
        str.append("        <ows:Get xlink:href=\"" + baseUrl + "?\">\n");
        str.append("          <ows:Constraint name=\"GetEncoding\">\n");
        str.append("            <ows:AllowedValues>\n");
        str.append("              <ows:Value>KVP</ows:Value>\n");
        str.append("            </ows:AllowedValues>\n");
        str.append("          </ows:Constraint>\n");
        str.append("        </ows:Get>\n");
        str.append("      </ows:HTTP>\n");
        str.append("    </ows:DCP>\n");
        str.append("  </ows:Operation>\n");
    }

    private void contents(StringBuilder str) {
        str.append("<Contents>\n");
        Iterator<TileLayer> iter = this.tld.getLayers().values().iterator();
        while (iter.hasNext()) {
            this.layer(str, iter.next(), this.baseUrl);
        }
        Iterator<GridSet> gridSetIter = this.gsb.getGridSets().values().iterator();
        while (gridSetIter.hasNext()) {
            this.tileMatrixSet(str, gridSetIter.next());
        }
        str.append("</Contents>\n");
    }

    private void layer(StringBuilder str, TileLayer layer, String baseurl) {
        str.append("  <Layer>\n");
        LayerMetaInformation layerMeta = layer.getMetaInformation();
        if (layerMeta == null) {
            this.appendTag(str, "    ", "ows:Title", layer.getName(), null);
        } else {
            this.appendTag(str, "    ", "ows:Title", layerMeta.getTitle(), null);
            this.appendTag(str, "    ", "ows:Abstract", layerMeta.getDescription(), null);
        }
        this.layerWGS84BoundingBox(str, layer);
        this.appendTag(str, "    ", "ows:Identifier", layer.getName(), null);
        List<ParameterFilter> filters = null;
        if (!(layer instanceof WMSLayer)) {
            filters = ((WMSLayer)layer).getParameterFilters();
        }
        this.layerStyles(str, layer, filters);
        this.layerFormats(str, layer);
        this.layerInfoFormats(str, layer);
        if (filters != null) {
            this.layerDimensions(str, layer, filters);
        }
        this.layerGridSubSets(str, layer);
        str.append("  </Layer>\n");
    }

    private void layerWGS84BoundingBox(StringBuilder str, TileLayer layer) {
        GridSubset subset = layer.getGridSubsetForSRS(SRS.getEPSG4326());
        if (subset != null) {
            double[] coords = subset.getOriginalExtent().coords;
            str.append("    <ows:WGS84BoundingBox>\n");
            str.append("      <ows:LowerCorner>" + coords[0] + " " + coords[1] + "</ows:LowerCorner>\n");
            str.append("      <ows:UpperCorner>" + coords[2] + " " + coords[3] + "</ows:UpperCorner>\n");
            str.append("    </ows:WGS84BoundingBox>\n");
        }
    }

    private void layerStyles(StringBuilder str, TileLayer layer, List<ParameterFilter> filters) {
        String defStyle = layer.getStyles();
        if (filters == null) {
            str.append("    <Style isDefault=\"true\">\n");
            str.append("      <ows:Identifier>" + WMTSService.encodeDimensionValue(defStyle) + "</ows:Identifier>\n");
            str.append("    </Style>\n");
        } else {
            ParameterFilter stylesFilter = null;
            Iterator<ParameterFilter> iter = filters.iterator();
            while (stylesFilter == null && iter.hasNext()) {
                ParameterFilter filter = iter.next();
                if (!filter.key.equalsIgnoreCase("STYLES")) continue;
                stylesFilter = filter;
            }
            if (stylesFilter != null) {
                String defVal = stylesFilter.defaultValue;
                if (defVal == null) {
                    defVal = defStyle != null ? defStyle : "";
                }
                for (String value : stylesFilter.getLegalValues()) {
                    if (value.equals(defVal)) {
                        str.append("    <Style isDefault=\"true\">\n");
                    } else {
                        str.append("    <Style>\n");
                    }
                    str.append("      <ows:Identifier>" + WMTSService.encodeDimensionValue(value) + "</ows:Identifier>\n");
                    str.append("    </Style>\n");
                }
            }
        }
    }

    private void layerFormats(StringBuilder str, TileLayer layer) {
        Iterator<MimeType> mimeIter = layer.getMimeTypes().iterator();
        while (mimeIter.hasNext()) {
            str.append("    <Format>" + mimeIter.next().getFormat() + "</Format>\n");
        }
    }

    private void layerInfoFormats(StringBuilder str, TileLayer layer) {
        if (!(layer instanceof WMSLayer)) {
            return;
        }
        if (((WMSLayer)layer).isQueryable()) {
            str.append("    <InfoFormat>text/plain</InfoFormat>\n");
            str.append("    <InfoFormat>text/html</InfoFormat>\n");
            str.append("    <InfoFormat>application/vnd.ogc.gml</InfoFormat>\n");
        }
    }

    private void layerDimensions(StringBuilder str, TileLayer layer, List<ParameterFilter> filters) {
        for (ParameterFilter filter : filters) {
            List<String> values;
            if (filter.key.equalsIgnoreCase("STYLES") || (values = filter.getLegalValues()) == null) continue;
            this.dimensionDescription(str, filter, values);
        }
    }

    private void dimensionDescription(StringBuilder str, ParameterFilter filter, List<String> values) {
        str.append("    <Dimension>");
        str.append("      <Identifier>" + filter.key + "</Identifier>");
        String defaultStr = WMTSService.encodeDimensionValue(filter.defaultValue);
        str.append("      <Default>" + this.encodeXmlChars(defaultStr) + "</Default>");
        Iterator<String> iter = values.iterator();
        while (iter.hasNext()) {
            String value = WMTSService.encodeDimensionValue(iter.next());
            str.append("      <Value>" + this.encodeXmlChars(value) + "</Value>");
        }
        str.append("    </Dimension>");
    }

    private void layerGridSubSets(StringBuilder str, TileLayer layer) {
        for (GridSubset gridSubset : layer.getGridSubsets().values()) {
            str.append("    <TileMatrixSetLink>");
            str.append("      <TileMatrixSet>" + gridSubset.getName() + "</TileMatrixSet>\n");
            if (!gridSubset.fullGridSetCoverage()) {
                String[] levelNames = gridSubset.getGridNames();
                long[][] wmtsLimits = gridSubset.getWMTSCoverages();
                str.append("      <TileMatrixSetLimits>\n");
                for (int i = 0; i < levelNames.length; ++i) {
                    str.append("        <TileMatrixLimits>\n");
                    str.append("          <TileMatrix>" + levelNames[i] + "</TileMatrix>\n");
                    str.append("          <MinTileRow>" + wmtsLimits[i][1] + "</MinTileRow>\n");
                    str.append("          <MaxTileRow>" + wmtsLimits[i][3] + "</MaxTileRow>\n");
                    str.append("          <MinTileCol>" + wmtsLimits[i][0] + "</MinTileCol>\n");
                    str.append("          <MaxTileCol>" + wmtsLimits[i][2] + "</MaxTileCol>\n");
                    str.append("        </TileMatrixLimits>\n");
                }
                str.append("      </TileMatrixSetLimits>\n");
            }
            str.append("    </TileMatrixSetLink>");
        }
    }

    private void tileMatrixSet(StringBuilder str, GridSet gridSet) {
        str.append("  <TileMatrixSet>\n");
        str.append("    <ows:Identifier>" + gridSet.getName() + "</ows:Identifier>\n");
        str.append("    <ows:SupportedCRS>urn:ogc:def:crs:EPSG::" + gridSet.getSRS().getNumber() + "</ows:SupportedCRS>\n");
        Grid[] grids = gridSet.getGrids();
        for (int i = 0; i < grids.length; ++i) {
            double[] leftTop = gridSet.getLeftTopCorner(i);
            this.tileMatrix(str, grids[i], leftTop[1], leftTop[0], gridSet.getTileWidth(), gridSet.getTileHeight(), gridSet.getScaleWarning());
        }
        str.append("  </TileMatrixSet>\n");
    }

    private void tileMatrix(StringBuilder str, Grid grid, double top, double left, int tileWidth, int tileHeight, boolean scaleWarning) {
        str.append("    <TileMatrix>\n");
        if (scaleWarning) {
            str.append("      <ows:Abstract>The grid was not well-defined, the scale therefore assumes 1m per map unit.</ows:Abstract>");
        }
        str.append("      <ows:Identifier>" + grid.getName() + "</ows:Identifier>\n");
        str.append("      <ScaleDenominator>" + grid.getScaleDenominator() + "</ScaleDenominator>\n");
        str.append("      <TopLeftCorner>" + top + " " + left + "</TopLeftCorner>\n");
        str.append("      <TileWidth>" + tileWidth + "</TileWidth>\n");
        str.append("      <TileHeight>" + tileHeight + "</TileHeight>\n");
        str.append("      <MatrixWidth>" + grid.getExtent()[0] + "</MatrixWidth>\n");
        str.append("      <MatrixHeight>" + grid.getExtent()[1] + "</MatrixHeight>\n");
        str.append("    </TileMatrix>\n");
    }

    private void appendTag(StringBuilder str, String padding, String tagName, String value, String defaultValue) {
        if (defaultValue == null && value == null) {
            return;
        }
        String escapedValue = value == null ? defaultValue : this.encodeXmlChars(value);
        str.append(padding + "<" + tagName + ">" + escapedValue + "</" + tagName + ">\n");
    }

    private void appendXlink(StringBuilder str, String padding, String tagName, String xlink) {
        String escapedValue = this.encodeXmlChars(xlink);
        str.append(padding + "<" + tagName + " xlink:href=\"" + escapedValue + "\" />\n");
    }

    private String encodeXmlChars(String input) {
        return input.replaceAll("&", "&amp;").replaceAll("%", "&#37;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

