/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.TileRange;

public class TileRangeIterator {
    private final TileRange tr;
    private final DiscontinuousTileRange dtr;
    private final int metaX;
    private final int metaY;
    private long tilesSkippedCount = 0L;
    private long tilesRenderedCount = 0L;
    private long[] lastGridLoc;

    public TileRangeIterator(TileRange tr, int[] metaTilingFactors) {
        this.tr = tr;
        this.metaX = metaTilingFactors[0];
        this.metaY = metaTilingFactors[1];
        this.dtr = tr instanceof DiscontinuousTileRange ? (DiscontinuousTileRange)tr : null;
    }

    public TileRange getTileRange() {
        return this.tr;
    }

    public synchronized long[] nextMetaGridLocation() {
        long y;
        long x;
        long[] levelBounds;
        int z;
        if (this.lastGridLoc == null) {
            z = this.tr.zoomStart;
            levelBounds = this.tr.rangeBounds[z];
            x = levelBounds[0];
            y = levelBounds[1];
        } else {
            z = (int)this.lastGridLoc[2];
            levelBounds = this.tr.rangeBounds[z];
            x = this.lastGridLoc[0] + (long)this.metaX;
            y = this.lastGridLoc[1];
        }
        try {
            while (z <= this.tr.zoomStop) {
                while (y < levelBounds[3]) {
                    while (x < levelBounds[2]) {
                        long[] gridLoc = new long[]{x, y, z};
                        int tileCount = this.tilesForLocation(gridLoc, levelBounds);
                        if (this.checkGridLocation(gridLoc)) {
                            this.tilesRenderedCount += (long)tileCount;
                            this.lastGridLoc = (long[])gridLoc.clone();
                            return gridLoc;
                        }
                        this.tilesSkippedCount += (long)tileCount;
                        x += (long)this.metaX;
                    }
                    x = levelBounds[0];
                    y += (long)this.metaY;
                }
                if (z < this.tr.zoomStop) {
                    levelBounds = this.tr.rangeBounds[z + 1];
                    x = levelBounds[0];
                    y = levelBounds[1];
                }
                ++z;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return null;
    }

    private int tilesForLocation(long[] gridLoc, long[] levelBounds) {
        return (int)Math.min((long)this.metaX, levelBounds[2] - gridLoc[0]) * (int)Math.min((long)this.metaY, levelBounds[3] - gridLoc[1]);
    }

    private boolean checkGridLocation(long[] gridLoc) {
        if (this.dtr == null) {
            return true;
        }
        for (int i = 0; i < this.metaX; ++i) {
            for (int j = 0; j < this.metaY; ++j) {
                long[] subIdx = new long[]{gridLoc[0] + (long)i, gridLoc[1] + (long)j, gridLoc[2]};
                if (!this.dtr.contains(subIdx)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized long getCountSkipped() {
        return this.tilesSkippedCount;
    }

    public synchronized long getCountRendered() {
        return this.tilesRenderedCount;
    }
}

