/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.util.ServletUtils;

public abstract class WMSSourceHelper {
    protected abstract byte[] makeRequest(TileResponseReceiver var1, WMSLayer var2, String var3, String var4) throws GeoWebCacheException;

    public byte[] makeRequest(WMSMetaTile metaTile) throws GeoWebCacheException {
        String wmsParams = metaTile.getWMSParams();
        WMSLayer layer = metaTile.getLayer();
        return this.makeRequest(metaTile, layer, wmsParams, metaTile.getRequestFormat().getFormat());
    }

    public byte[] makeRequest(ConveyorTile tile) throws GeoWebCacheException {
        WMSLayer layer = (WMSLayer)tile.getLayer();
        GridSubset gridSubset = tile.getGridSubset();
        String wmsParams = layer.getWMSRequestTemplate(tile.getMimeType(), WMSLayer.RequestType.MAP);
        StringBuilder strBuilder = new StringBuilder(wmsParams);
        strBuilder.append("&FORMAT=").append(tile.getMimeType().getFormat());
        strBuilder.append("&SRS=").append(layer.backendSRSOverride(gridSubset.getSRS()));
        strBuilder.append("&HEIGHT=").append(gridSubset.getTileHeight());
        strBuilder.append("&WIDTH=").append(gridSubset.getTileWidth());
        BoundingBox bbox = gridSubset.boundsFromIndex(tile.getTileIndex());
        strBuilder.append("&BBOX=").append(bbox);
        strBuilder.append(tile.getFullParameters());
        if (tile.getMimeType() == XMLMime.kml) {
            strBuilder.append("&format_options=").append(ServletUtils.URLEncode("mode:superoverlay;overlaymode:auto"));
        }
        return this.makeRequest(tile, layer, strBuilder.toString(), tile.getMimeType().getMimeType());
    }

    public byte[] makeFeatureInfoRequest(ConveyorTile tile, int x, int y) throws GeoWebCacheException {
        WMSLayer layer = (WMSLayer)tile.getLayer();
        GridSubset gridSubset = tile.getGridSubset();
        String wmsParams = layer.getWMSRequestTemplate(tile.getMimeType(), WMSLayer.RequestType.FEATUREINFO);
        StringBuilder strBuilder = new StringBuilder(wmsParams);
        strBuilder.append("&INFO_FORMAT=").append(tile.getMimeType().getFormat());
        strBuilder.append("&FORMAT=").append(tile.getMimeType().getFormat());
        strBuilder.append("&SRS=").append(layer.backendSRSOverride(gridSubset.getSRS()));
        strBuilder.append("&HEIGHT=").append(gridSubset.getTileHeight());
        strBuilder.append("&WIDTH=").append(gridSubset.getTileWidth());
        BoundingBox bbox = gridSubset.boundsFromIndex(tile.getTileIndex());
        strBuilder.append("&BBOX=").append(bbox);
        strBuilder.append(tile.getFullParameters());
        strBuilder.append("&X=").append(x);
        strBuilder.append("&Y=").append(y);
        return this.makeRequest(tile, layer, strBuilder.toString(), tile.getMimeType().getMimeType());
    }

    protected boolean mimeStringCheck(String requestMime, String responseMime) {
        if (responseMime.equalsIgnoreCase(requestMime)) {
            return true;
        }
        if (responseMime.startsWith(requestMime)) {
            return true;
        }
        return requestMime.startsWith("image/png") && responseMime.startsWith("image/png");
    }
}

