/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.XMLGridSubset;
import org.geowebcache.grid.XMLOldGrid;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.GridLocObj;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSMetaTile;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.wmts.WMTSService;
import org.geowebcache.storage.TileObject;
import org.geowebcache.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayer
extends TileLayer {
    private String[] wmsUrl = null;
    private Integer concurrency = null;
    private String wmsLayers = null;
    private String wmsStyles = null;
    private int[] metaWidthHeight = null;
    protected Integer gutter;
    private String errorMime;
    private String wmsVersion;
    private Boolean tiled;
    private Boolean transparent;
    private String bgColor;
    private String palette;
    private String vendorParameters;
    private String cachePrefix;
    private String expireCache;
    private ArrayList<ExpirationRule> expireCacheList;
    private String expireClients;
    private ArrayList<ExpirationRule> expireClientsList;
    protected Integer backendTimeout;
    protected Boolean cacheBypassAllowed;
    protected Boolean queryable;
    protected String sphericalMercatorOverride;
    protected List<ParameterFilter> parameterFilters;
    private transient int curWmsURL;
    private transient boolean saveExpirationHeaders;
    private transient Lock layerLock;
    private transient boolean layerLocked;
    private transient Condition layerLockedCond;
    private transient Condition[] gridLocConds;
    private transient HashMap<GridLocObj, Boolean> procQueue;
    private transient ParameterFilter[] sortedModParams;
    private transient String[] sortedModParamsKeys;
    private transient boolean stylesIsModParam = false;
    private transient String encodedWMSLayers;
    private transient String encodedWMSStyles;
    private transient String encodedPalette;
    private transient String encodedName;
    private transient WMSSourceHelper sourceHelper = null;
    private static transient Log log = LogFactory.getLog(WMSLayer.class);

    public WMSLayer(String layerName, String[] wmsURL, String wmsStyles, String wmsLayers, List<String> mimeFormats, Hashtable<String, GridSubset> subSets, int[] metaWidthHeight, String vendorParams, boolean queryable) {
        this.name = layerName;
        this.wmsUrl = wmsURL;
        this.wmsLayers = wmsLayers;
        this.wmsStyles = wmsStyles;
        this.mimeFormats = mimeFormats;
        this.subSets = subSets;
        this.metaWidthHeight = metaWidthHeight;
        this.vendorParameters = vendorParams;
        this.transparent = true;
        this.queryable = queryable;
    }

    @Override
    public boolean initialize(GridSetBroker gridSetBroker) {
        if (null == this.sourceHelper) {
            log.warn((Object)(this.name + " is configured without a source, which is a bug unless you're running tests that don't care."));
        }
        this.curWmsURL = 0;
        if (this.expireCacheList == null) {
            this.expireCacheList = new ArrayList(1);
            if (this.expireCache == null) {
                this.expireCacheList.add(new ExpirationRule(0, -2));
            } else {
                int expireCacheInt = Integer.parseInt(this.expireCache);
                if (expireCacheInt == -4) {
                    this.saveExpirationHeaders = true;
                }
                this.expireCacheList.add(new ExpirationRule(0, expireCacheInt));
            }
        }
        if (this.expireClientsList == null) {
            this.expireClientsList = new ArrayList(1);
            if (this.expireClients == null) {
                this.expireClientsList.add(new ExpirationRule(0, 7200));
            } else {
                int expireClientsInt = Integer.parseInt(this.expireClients);
                if (expireClientsInt == -4) {
                    this.saveExpirationHeaders = true;
                } else if (expireClientsInt == -2) {
                    expireClientsInt = 31536000;
                }
                this.expireClientsList.add(new ExpirationRule(0, expireClientsInt));
            }
        }
        if (this.backendTimeout == null) {
            this.backendTimeout = 120;
        }
        this.layerLock = new ReentrantLock();
        this.layerLockedCond = this.layerLock.newCondition();
        this.procQueue = new HashMap();
        try {
            this.initParameters();
        }
        catch (GeoWebCacheException gwce) {
            log.error((Object)gwce.getMessage());
            gwce.printStackTrace();
        }
        if (this.metaWidthHeight == null || this.metaWidthHeight.length != 2) {
            this.metaWidthHeight = new int[2];
            this.metaWidthHeight[0] = 3;
            this.metaWidthHeight[1] = 3;
        }
        if (this.subSets == null) {
            this.subSets = new Hashtable();
        }
        if (this.gridSubsets != null) {
            for (XMLGridSubset xmlGridSubset : this.gridSubsets) {
                GridSubset gridSubset = xmlGridSubset.getGridSubSet(gridSetBroker);
                if (gridSubset == null) {
                    log.error((Object)(xmlGridSubset.getGridSetName() + " is not known by the GridSetBroker, skipping for layer " + this.name));
                    continue;
                }
                this.subSets.put(gridSubset.getName(), gridSubset);
            }
            this.gridSubsets = null;
        }
        if (this.grids != null && !this.grids.isEmpty()) {
            Iterator iter = this.grids.values().iterator();
            while (iter.hasNext()) {
                GridSubset converted = ((XMLOldGrid)iter.next()).convertToGridSubset(gridSetBroker);
                this.subSets.put(converted.getSRS().toString(), converted);
            }
            this.grids = null;
        }
        if (this.subSets.size() == 0) {
            this.subSets.put(gridSetBroker.WORLD_EPSG4326.getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.WORLD_EPSG4326));
            this.subSets.put(gridSetBroker.WORLD_EPSG3857.getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.WORLD_EPSG3857));
        }
        if (this.concurrency == null) {
            this.concurrency = 32;
        }
        this.gridLocConds = new Condition[this.concurrency.intValue()];
        for (int i = 0; i < this.gridLocConds.length; ++i) {
            this.gridLocConds[i] = this.layerLock.newCondition();
        }
        if (this.parameterFilters != null && this.parameterFilters.size() > 0) {
            int i;
            Iterator<ParameterFilter> iter = this.parameterFilters.iterator();
            TreeMap<String, ParameterFilter> tree = new TreeMap<String, ParameterFilter>();
            while (iter.hasNext()) {
                ParameterFilter modParam = iter.next();
                String key = modParam.getKey();
                if (key.equalsIgnoreCase("STYLES")) {
                    this.stylesIsModParam = true;
                }
                tree.put(modParam.getKey(), modParam);
            }
            int arSize = tree.values().size();
            Iterator sortedIter = tree.values().iterator();
            this.sortedModParams = new ParameterFilter[arSize];
            for (i = 0; i < arSize; ++i) {
                this.sortedModParams[i] = (ParameterFilter)sortedIter.next();
            }
            this.sortedModParamsKeys = new String[this.sortedModParams.length];
            for (i = 0; i < this.sortedModParams.length; ++i) {
                this.sortedModParamsKeys[i] = this.sortedModParams[i].getKey();
            }
        }
        if (this.sourceHelper instanceof WMSHttpHelper) {
            for (int i = 0; i < this.wmsUrl.length; ++i) {
                String url = this.wmsUrl[i];
                if (url.endsWith("?")) continue;
                this.wmsUrl[i] = url + "?";
            }
        }
        if (this.gutter == null) {
            this.gutter = 0;
        }
        if (this.requestFilters != null) {
            Iterator iter = this.requestFilters.iterator();
            while (iter.hasNext()) {
                try {
                    ((RequestFilter)iter.next()).initialize(this);
                }
                catch (GeoWebCacheException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        if (this.wmsLayers != null && this.wmsLayers.length() > 0) {
            this.encodedWMSLayers = ServletUtils.URLEncode(this.wmsLayers);
        } else {
            this.encodedName = ServletUtils.URLEncode(this.name);
        }
        if (this.wmsStyles != null) {
            this.encodedWMSStyles = ServletUtils.URLEncode(this.wmsStyles);
        }
        if (this.palette != null) {
            this.encodedPalette = ServletUtils.URLEncode(this.palette);
        }
        return true;
    }

    public byte[] getFeatureInfo(ConveyorTile convTile, int x, int y) throws GeoWebCacheException {
        return this.sourceHelper.makeFeatureInfoRequest(convTile, x, y);
    }

    @Override
    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
        MimeType mime = tile.getMimeType();
        if (mime == null) {
            mime = (MimeType)this.formats.get(0);
        }
        if (!this.formats.contains(mime)) {
            throw new GeoWebCacheException(mime.getFormat() + " is not a supported format for " + this.name);
        }
        String tileGridSetId = tile.getGridSetId();
        long[] gridLoc = tile.getTileIndex();
        this.getGridSubset(tileGridSetId).checkCoverage(gridLoc);
        if (this.tryCacheFetch(tile)) {
            return this.finalizeTile(tile);
        }
        if (mime.supportsTiling()) {
            return this.getMetatilingReponse(tile, true);
        }
        return this.getNonMetatilingReponse(tile, true);
    }

    @Override
    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        if (tile.getMimeType().supportsTiling()) {
            this.getMetatilingReponse(tile, tryCache);
        } else {
            this.getNonMetatilingReponse(tile, tryCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        long[] gridLoc = tile.getTileIndex();
        GridSubset gridSubset = (GridSubset)this.subSets.get(tile.getGridSetId());
        WMSMetaTile metaTile = new WMSMetaTile(this, gridSubset, tile.getMimeType(), this.getFormatModifier(tile.getMimeType()), gridLoc, this.metaWidthHeight[0], this.metaWidthHeight[1], tile.getFullParameters());
        if (this.saveExpirationHeaders) {
            metaTile.setExpiresHeader(-4L);
        }
        long[] metaGridLoc = metaTile.getMetaGridPos();
        GridLocObj metaGlo = new GridLocObj(metaGridLoc, this.gridLocConds.length);
        this.waitForQueue(metaGlo);
        try {
            if (tryCache && this.tryCacheFetch(tile)) {
                this.removeFromQueue(metaGlo);
                ConveyorTile conveyorTile = this.finalizeTile(tile);
                return conveyorTile;
            }
            if (this.saveExpirationHeaders) {
                metaTile.setExpiresHeader(-4L);
            }
            byte[] response = this.sourceHelper.makeRequest(metaTile);
            if (metaTile.getError() || response == null) {
                throw new GeoWebCacheException("Empty metatile, error message: " + metaTile.getErrorMessage());
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
            metaTile.setImageBytes(response);
            boolean useJAI = true;
            if (tile.getMimeType() == ImageMime.jpeg) {
                useJAI = false;
            }
            metaTile.createTiles(gridSubset.getTileHeight(), gridSubset.getTileWidth(), useJAI);
            long[][] gridPositions = metaTile.getTilesGridPositions();
            tile.setContent(this.getTile(gridLoc, gridPositions, metaTile));
            if (this.getExpireCache((int)gridLoc[2]) != -1) {
                this.saveTiles(gridPositions, metaTile, tile);
            }
        }
        finally {
            this.removeFromQueue(metaGlo);
        }
        return this.finalizeTile(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getNonMetatilingReponse(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException {
        long[] gridLoc = tile.getTileIndex();
        GridLocObj glo = new GridLocObj(gridLoc, this.gridLocConds.length);
        this.waitForQueue(glo);
        try {
            if (tryCache && this.tryCacheFetch(tile)) {
                this.removeFromQueue(glo);
                ConveyorTile conveyorTile = tile;
                return conveyorTile;
            }
            if (this.saveExpirationHeaders) {
                tile.setExpiresHeader(-4L);
            }
            if ((tile = this.doNonMetatilingRequest(tile)).getStatus() > 299 || this.getExpireCache((int)gridLoc[2]) != -1) {
                tile.persist();
            }
            if (this.saveExpirationHeaders) {
                this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
            }
        }
        finally {
            this.removeFromQueue(glo);
        }
        return this.finalizeTile(tile);
    }

    public boolean tryCacheFetch(ConveyorTile tile) {
        int expireCache = this.getExpireCache((int)tile.getTileIndex()[2]);
        if (expireCache != -1) {
            try {
                return tile.retrieve((long)expireCache * 1000L);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void setExpirationHeader(HttpServletResponse response, int zoomLevel) {
        int expireValue = this.getExpireClients(zoomLevel);
        if (expireValue == 0) {
            return;
        }
        if (expireValue > 0) {
            response.setHeader("Cache-Control", "max-age=" + expireValue + ", must-revalidate");
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(expireValue));
        } else if (expireValue == -2) {
            long oneYear = 31536000L;
            response.setHeader("Cache-Control", "max-age=" + oneYear);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader((int)oneYear));
        } else if (expireValue == -1) {
            response.setHeader("Cache-Control", "no-cache");
        } else if (expireValue == -4) {
            int seconds = 3600;
            response.setHeader("geowebcache-error", "No real CacheControl information available");
            response.setHeader("Cache-Control", "max-age=" + seconds);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(seconds));
        }
    }

    public void setTileIndexHeader(ConveyorTile tile) {
        tile.servletResp.addHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
    }

    protected void saveTiles(long[][] gridPositions, WMSMetaTile metaTile, ConveyorTile tileProto) throws GeoWebCacheException {
        for (int i = 0; i < gridPositions.length; ++i) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                boolean completed = metaTile.writeTileToStream(i, out);
                if (!completed) {
                    log.error((Object)"metaTile.writeTileToStream returned false, no tiles saved");
                }
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to write image tile to ByteArrayOutputStream: " + ioe.getMessage()));
                ioe.printStackTrace();
            }
            long[] idx = new long[]{gridPositions[i][0], gridPositions[i][1], gridPositions[i][2]};
            TileObject tile = TileObject.createCompleteTileObject(this.getName(), idx, tileProto.getGridSetId(), tileProto.getMimeType().getFormat(), tileProto.getParameters(), out.toByteArray());
            tileProto.getStorageBroker().put(tile);
        }
    }

    private byte[] getTile(long[] gridPos, long[][] gridPositions, WMSMetaTile metaTile) throws GeoWebCacheException {
        for (int i = 0; i < gridPositions.length; ++i) {
            long[] curPos = gridPositions[i];
            if (curPos[0] != gridPos[0] || curPos[1] != gridPos[1] || curPos[2] != gridPos[2]) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                metaTile.writeTileToStream(i, out);
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to write image tile to ByteArrayOutputStream: " + ioe.getMessage()));
                ioe.printStackTrace();
            }
            byte[] data = out.toByteArray();
            return data;
        }
        throw new GeoWebCacheException("Bug: WMSLayer.getTile() didn't have tile...");
    }

    @Override
    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        byte[] response = this.sourceHelper.makeRequest(tile);
        if (tile.getError() || response == null) {
            throw new GeoWebCacheException("Empty tile, error message: " + tile.getErrorMessage());
        }
        tile.setContent(response);
        return tile;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile.servletResp != null) {
            this.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            this.setTileIndexHeader(tile);
        }
        return tile;
    }

    private void initParameters() throws GeoWebCacheException {
        if (this.expireCacheList == null) {
            this.expireCacheList = new ArrayList(1);
            if (this.expireCache == null) {
                this.expireCacheList.add(new ExpirationRule(0, -2));
            } else {
                this.expireCacheList.add(new ExpirationRule(0, Integer.getInteger(this.expireCache)));
            }
        }
        if (this.expireClientsList == null) {
            this.expireClientsList = new ArrayList(1);
            if (this.expireClients == null) {
                this.expireClientsList.add(new ExpirationRule(0, -4));
            } else {
                this.expireClientsList.add(new ExpirationRule(0, Integer.getInteger(this.expireCache)));
            }
        }
        this.formats = new ArrayList();
        if (this.mimeFormats != null) {
            for (String fmt : this.mimeFormats) {
                this.formats.add(MimeType.createFromFormat(fmt));
            }
        }
        if (this.formats.size() == 0) {
            this.formats.add(0, ImageMime.createFromFormat("image/png"));
            this.formats.add(1, ImageMime.createFromFormat("image/jpeg"));
        }
    }

    protected void saveExpirationInformation(int backendExpire) {
        this.saveExpirationHeaders = false;
        try {
            if (this.getExpireCache(0) == -4) {
                if (backendExpire == -1) {
                    this.expireCacheList.set(0, new ExpirationRule(0, 7200));
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireCacheList.set(backendExpire, new ExpirationRule(0, 7200));
                }
                log.trace((Object)("Setting expireCache to: " + this.expireCache));
            }
            if (this.getExpireCache(0) == -4) {
                if (backendExpire == -1) {
                    this.expireClientsList.set(0, new ExpirationRule(0, 7200));
                    log.error((Object)"Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                } else {
                    this.expireClientsList.set(0, new ExpirationRule(0, backendExpire));
                    log.trace((Object)("Setting expireClients to: " + this.expireClients));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MimeType getImageFormat(String strFormat) throws MimeException {
        if (strFormat == null) {
            return (MimeType)this.formats.get(0);
        }
        return MimeType.createFromFormat(strFormat);
    }

    public String getWMSRequestTemplate(MimeType responseFormat, RequestType reqType) {
        FormatModifier mod = this.getFormatModifier(responseFormat);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SERVICE=WMS");
        strBuilder.append("&REQUEST=");
        if (reqType == RequestType.MAP) {
            strBuilder.append("GetMap");
        } else {
            strBuilder.append("GetFeatureInfo");
        }
        strBuilder.append("&VERSION=");
        if (this.wmsVersion != null) {
            strBuilder.append(this.wmsVersion);
        } else {
            strBuilder.append("1.1.0");
        }
        strBuilder.append("&LAYERS=");
        if (this.wmsLayers != null && this.wmsLayers.length() != 0) {
            strBuilder.append(this.encodedWMSLayers);
        } else {
            strBuilder.append(this.encodedName);
        }
        if (reqType == RequestType.FEATUREINFO) {
            strBuilder.append("&QUERY_LAYERS=");
            if (this.wmsLayers != null && this.wmsLayers.length() != 0) {
                strBuilder.append(this.encodedWMSLayers);
            } else {
                strBuilder.append(this.encodedName);
            }
        }
        strBuilder.append("&EXCEPTIONS=");
        if (this.errorMime != null) {
            strBuilder.append(this.errorMime);
        } else {
            strBuilder.append(XMLMime.ogcxml.getMimeType());
        }
        if (!this.stylesIsModParam) {
            strBuilder.append("&STYLES=");
            if (this.wmsStyles != null && this.wmsStyles.length() != 0) {
                strBuilder.append(this.encodedWMSStyles);
            }
        }
        if (reqType == RequestType.MAP) {
            Boolean tmpTransparent = this.transparent;
            if (mod != null && mod.getTransparent() != null) {
                tmpTransparent = mod.getTransparent();
            }
            if (tmpTransparent == null || tmpTransparent.booleanValue()) {
                strBuilder.append("&TRANSPARENT=").append("TRUE");
            } else {
                strBuilder.append("&TRANSPARENT=").append("FALSE");
            }
            String tmpBgColor = this.bgColor;
            if (mod != null && mod.getBgColor() != null) {
                tmpBgColor = mod.getBgColor();
            }
            if (tmpBgColor != null && tmpBgColor.length() != 0) {
                strBuilder.append("&BGCOLOR=").append(tmpBgColor);
            }
            String tmpPalette = this.encodedPalette;
            if (mod != null && mod.getPalette() != null) {
                tmpPalette = mod.getPalette();
            }
            if (tmpPalette != null && tmpPalette.length() != 0) {
                strBuilder.append("&PALETTE=").append(tmpPalette);
            }
        }
        if (this.vendorParameters != null && this.vendorParameters.length() != 0) {
            if (!this.vendorParameters.startsWith("&")) {
                strBuilder.append("&");
            }
            strBuilder.append(this.vendorParameters);
        }
        return strBuilder.toString();
    }

    protected String nextWmsURL() {
        this.curWmsURL = (this.curWmsURL + 1) % this.wmsUrl.length;
        return this.wmsUrl[this.curWmsURL];
    }

    @Override
    public void destroy() {
        this.procQueue.clear();
    }

    @Override
    public int[] getMetaTilingFactors() {
        return this.metaWidthHeight;
    }

    @Override
    public long[] indexFromBounds(String gridSetId, BoundingBox tileBounds) throws GridMismatchException {
        return ((GridSubset)this.subSets.get(gridSetId)).closestIndex(tileBounds);
    }

    @Override
    public MimeType getDefaultMimeType() {
        return (MimeType)this.formats.get(0);
    }

    @Override
    public BoundingBox boundsFromIndex(String gridSetId, long[] gridLoc) {
        return ((GridSubset)this.subSets.get(gridSetId)).boundsFromIndex(gridLoc);
    }

    public long[][] getZoomedInGridLoc(String gridSetId, long[] gridLoc) throws GeoWebCacheException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLayerLock() {
        if (this.layerLock == null) {
            this.layerLocked = true;
            return;
        }
        boolean wait = true;
        while (wait) {
            try {
                this.layerLock.lock();
                this.layerLocked = true;
                if (this.procQueue != null && this.procQueue.size() != 0) continue;
                wait = false;
            }
            finally {
                this.layerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLayerLock() {
        if (this.layerLock == null) {
            this.layerLocked = false;
            return;
        }
        this.layerLock.lock();
        try {
            this.layerLocked = false;
            this.layerLockedCond.signalAll();
        }
        finally {
            this.layerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForQueue(GridLocObj glo) {
        boolean retry = true;
        boolean hasWaited = false;
        while (retry) {
            this.layerLock.lock();
            try {
                if (this.layerLocked) {
                    this.layerLockedCond.await();
                    continue;
                }
                if (this.procQueue.containsKey(glo)) {
                    hasWaited = true;
                    this.gridLocConds[glo.hashCode()].await();
                    continue;
                }
                this.procQueue.put(glo, true);
                retry = false;
            }
            catch (InterruptedException ie) {}
            continue;
            finally {
                this.layerLock.unlock();
            }
        }
        return hasWaited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromQueue(GridLocObj glo) {
        this.layerLock.lock();
        try {
            this.procQueue.remove(glo);
            this.gridLocConds[glo.hashCode()].signalAll();
        }
        finally {
            this.layerLock.unlock();
        }
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.formats;
    }

    public List<ParameterFilter> getParameterFilters() {
        return this.parameterFilters;
    }

    @Override
    public String getStyles() {
        return this.wmsStyles;
    }

    @Override
    public void putTile(ConveyorTile tile) throws GeoWebCacheException {
        GridLocObj glo = new GridLocObj(tile.getTileIndex(), this.gridLocConds.length);
        this.waitForQueue(glo);
        if (this.getExpireCache((int)tile.getTileIndex()[2]) != -1) {
            tile.persist();
        }
        this.removeFromQueue(glo);
    }

    public void setErrorMime(String errormime) {
        this.errorMime = errormime;
    }

    public void addMetaWidthHeight(int w, int h) {
        this.metaWidthHeight[0] = w;
        this.metaWidthHeight[1] = h;
    }

    public void setWMSurl(String[] wmsurl) {
        this.wmsUrl = wmsurl;
    }

    public String[] getWMSurl() {
        return this.wmsUrl;
    }

    @Override
    public Boolean isCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    @Override
    public void setCacheBypassAllowed(boolean allowed) {
        this.cacheBypassAllowed = allowed;
    }

    public boolean isQueryable() {
        return this.queryable != null && this.queryable != false;
    }

    @Override
    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    @Override
    public void setBackendTimeout(int seconds) {
        this.backendTimeout = seconds;
    }

    private int getExpiration(ArrayList<ExpirationRule> list, int zoomLevel) {
        int retVal;
        int length = list.size();
        if (length == 1) {
            retVal = list.get(0).getExpiration();
        } else {
            int i;
            for (i = 1; i <= length && list.get(i).getMinZoom() <= zoomLevel; ++i) {
            }
            retVal = list.get(i - 1).getExpiration();
        }
        if (retVal == -4) {
            return 7200;
        }
        return retVal;
    }

    public int getExpireClients(int zoomLevel) {
        return this.getExpiration(this.expireClientsList, zoomLevel);
    }

    public int getExpireCache(int zoomLevel) {
        return this.getExpiration(this.expireCacheList, zoomLevel);
    }

    public void setSourceHelper(WMSSourceHelper source) {
        log.debug((Object)("Setting sourceHelper on " + this.name));
        this.sourceHelper = source;
    }

    public WMSSourceHelper getSourceHelper() {
        return this.sourceHelper;
    }

    public void setVersion(String version) {
        this.wmsVersion = version;
    }

    public void setTiled(boolean tiled) {
        this.tiled = tiled;
    }

    public boolean getTransparent() {
        return this.transparent == null || this.transparent != false;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public int[] getBackgroundColor() {
        if (this.bgColor == null || this.transparent != null && this.transparent.booleanValue()) {
            return null;
        }
        int[] ret = new int[]{Integer.parseInt(this.bgColor.substring(2, 4), 16), Integer.parseInt(this.bgColor.substring(4, 6), 16), Integer.parseInt(this.bgColor.substring(6, 8), 16)};
        return ret;
    }

    @Override
    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        byte[] data = this.sourceHelper.makeRequest(tile);
        tile.setContent(data);
        return tile;
    }

    public String[] getModifiableParameters(Map<String, String[]> map, String encoding) throws GeoWebCacheException {
        String[] paramStrs = new String[2];
        if (this.sortedModParamsKeys == null) {
            return null;
        }
        String[] values = ServletUtils.selectedStringsFromMap(map, encoding, this.sortedModParamsKeys);
        StringBuilder strModifiers = new StringBuilder();
        StringBuilder strFull = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            String value = WMTSService.decodeDimensionValue(values[i]);
            ParameterFilter modParam = this.sortedModParams[i];
            if (value == null || value.length() == 0) {
                if (modParam.getDefaultValue() == null) continue;
                strFull.append("&").append(modParam.getKey()).append("=").append(modParam.getDefaultValue());
                continue;
            }
            String filteredValue = ServletUtils.URLEncode(modParam.apply(value));
            strModifiers.append("&").append(modParam.getKey()).append("=").append(filteredValue);
        }
        paramStrs[1] = strModifiers.toString();
        paramStrs[0] = strFull.append((CharSequence)strModifiers).toString();
        return paramStrs;
    }

    public void mergeWith(WMSLayer otherLayer) throws GeoWebCacheException {
        if (otherLayer.parameterFilters != null) {
            if (this.parameterFilters != null) {
                Iterator<ParameterFilter> iter = otherLayer.parameterFilters.iterator();
                while (iter.hasNext()) {
                    this.parameterFilters.add(iter.next());
                }
            } else {
                this.parameterFilters = otherLayer.parameterFilters;
            }
        }
    }

    public String backendSRSOverride(SRS srs) {
        if (this.sphericalMercatorOverride != null && srs.equals(SRS.getEPSG3857())) {
            return this.sphericalMercatorOverride;
        }
        return srs.toString();
    }

    private Object readResolve() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        MAP,
        FEATUREINFO;

    }
}

