/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.ErrorMime;
import org.geowebcache.service.ServiceException;
import org.geowebcache.util.ServletUtils;

public class WMSHttpHelper
extends WMSSourceHelper {
    private static Log log = LogFactory.getLog(WMSHttpHelper.class);

    protected byte[] makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, String wmsParams, String expectedMimeType) throws GeoWebCacheException {
        int backendTries;
        byte[] data = null;
        URL wmsBackendUrl = null;
        for (backendTries = 0; data == null && backendTries < layer.getWMSurl().length; ++backendTries) {
            String requestUrl = layer.nextWmsURL() + wmsParams;
            try {
                wmsBackendUrl = new URL(requestUrl);
            }
            catch (MalformedURLException maue) {
                throw new GeoWebCacheException("Malformed URL: " + requestUrl + " " + maue.getMessage());
            }
            data = this.connectAndCheckHeaders(tileRespRecv, wmsBackendUrl, wmsParams, expectedMimeType, layer.backendTimeout);
        }
        if (data == null) {
            String msg = "All backends (" + backendTries + ") failed, " + "last one: " + wmsBackendUrl.toString() + "\n\n" + tileRespRecv.getErrorMessage();
            tileRespRecv.setError();
            tileRespRecv.setErrorMessage(msg);
            throw new GeoWebCacheException(msg);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] connectAndCheckHeaders(TileResponseReceiver tileRespRecv, URL wmsBackendUrl, String wmsParams, String requestMime, int backendTimeout) throws GeoWebCacheException {
        byte[] ret;
        block22: {
            ret = null;
            HttpURLConnection wmsBackendCon = null;
            int responseCode = -1;
            int responseLength = -1;
            try {
                String expireValue;
                long expire;
                try {
                    wmsBackendCon = (HttpURLConnection)wmsBackendUrl.openConnection();
                    wmsBackendCon.setConnectTimeout(backendTimeout * 1000);
                    wmsBackendCon.setReadTimeout(backendTimeout * 1000);
                    responseCode = wmsBackendCon.getResponseCode();
                    responseLength = wmsBackendCon.getContentLength();
                }
                catch (ConnectException ce) {
                    log.error((Object)("Error forwarding request " + wmsBackendUrl.toString() + " " + ce.getMessage()));
                    byte[] byArray = null;
                    wmsBackendCon.disconnect();
                    return byArray;
                }
                catch (IOException ioe) {
                    log.error((Object)("Error forwarding request " + wmsBackendUrl.toString() + " " + ioe.getMessage()));
                    byte[] byArray = null;
                    wmsBackendCon.disconnect();
                    return byArray;
                }
                tileRespRecv.setStatus(responseCode);
                if (responseCode != 200 && responseCode != 204) {
                    tileRespRecv.setError();
                    throw new ServiceException("Unexpected response code from backend: " + responseCode + " for " + wmsBackendUrl.toString());
                }
                String responseMime = wmsBackendCon.getContentType();
                if (responseCode != 204 && responseMime != null && !this.mimeStringCheck(requestMime, responseMime)) {
                    String message = null;
                    if (responseMime.equalsIgnoreCase(ErrorMime.vnd_ogc_se_inimage.getFormat())) {
                        byte[] error = new byte[2048];
                        try {
                            int readLength = 0;
                            for (int readAccu = 0; readLength > -1 && readAccu < error.length; readAccu += readLength) {
                                int left = error.length - readAccu;
                                readLength = wmsBackendCon.getInputStream().read(error, readAccu, left);
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        message = new String(error);
                    }
                    String msg = "MimeType mismatch, expected " + requestMime + " but got " + responseMime + " from " + wmsBackendUrl.toString() + "\n\n" + message;
                    tileRespRecv.setError();
                    tileRespRecv.setErrorMessage(msg);
                    log.error((Object)msg);
                }
                if (tileRespRecv.getExpiresHeader() == -4L && (expire = ServletUtils.parseExpiresHeader(expireValue = wmsBackendCon.getHeaderField("Expires"))) != -1L) {
                    tileRespRecv.setExpiresHeader(expire / 1000L);
                }
                if (responseCode != 204) {
                    try {
                        if (responseLength < 1) {
                            ret = ServletUtils.readStream(wmsBackendCon.getInputStream(), 16384, 2048);
                        } else {
                            int readAccu;
                            ret = new byte[responseLength];
                            int readLength = 0;
                            for (readAccu = 0; readLength > -1 && readAccu < responseLength; readAccu += readLength) {
                                int left = responseLength - readAccu;
                                readLength = wmsBackendCon.getInputStream().read(ret, readAccu, left);
                            }
                            if (readAccu != responseLength) {
                                tileRespRecv.setError();
                                throw new GeoWebCacheException("Responseheader advertised " + responseLength + " bytes, but only received " + readLength + " from " + wmsBackendUrl.toString());
                            }
                        }
                        break block22;
                    }
                    catch (IOException ioe) {
                        tileRespRecv.setError();
                        log.error((Object)("Caught IO exception, " + wmsBackendUrl.toString() + " " + ioe.getMessage()));
                    }
                    break block22;
                }
                ret = new byte[]{};
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                wmsBackendCon.disconnect();
            }
        }
        return ret;
    }
}

