/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSetBroker {
    private static Log log = LogFactory.getLog(GridSetBroker.class);
    public final GridSet WORLD_EPSG4326;
    public final GridSet WORLD_EPSG3857;
    Hashtable<String, GridSet> gridSets = new Hashtable();

    public GridSetBroker(boolean useEPSG900913, boolean useGWC11xNames) {
        String unprojectedName = "GlobalCRS84Geometric";
        String mercatorName = "GoogleMapsCompatible";
        if (useGWC11xNames) {
            unprojectedName = "EPSG:4326";
            mercatorName = useEPSG900913 ? "EPSG:900913" : "EPSG:3857";
        }
        log.debug((Object)("Adding " + unprojectedName));
        this.WORLD_EPSG4326 = GridSetFactory.createGridSet(unprojectedName, SRS.getEPSG4326(), BoundingBox.WORLD4326, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256);
        this.gridSets.put(this.WORLD_EPSG4326.name, this.WORLD_EPSG4326);
        if (useEPSG900913) {
            log.debug((Object)"Adding EPSG:900913 grid set for Spherical Mercator / GoogleMapsCompatible");
            this.WORLD_EPSG3857 = GridSetFactory.createGridSet(mercatorName, SRS.getEPSG900913(), BoundingBox.WORLD3857, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256);
        } else {
            log.debug((Object)"Adding EPSG:3857 grid set for Spherical Mercator / GoogleMapsCompatible");
            this.WORLD_EPSG3857 = GridSetFactory.createGridSet(mercatorName, SRS.getEPSG3857(), BoundingBox.WORLD3857, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256);
        }
        this.gridSets.put(this.WORLD_EPSG3857.name, this.WORLD_EPSG3857);
        log.debug((Object)"Adding GlobalCRS84Pixel");
        GridSet GlobalCRS84Pixel = GridSetFactory.createGridSet("GlobalCRS84Pixel", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, this.scalesCRS84PixelResolutions(), null, null, 2.8E-4, null, 256, 256);
        this.gridSets.put(GlobalCRS84Pixel.name, GlobalCRS84Pixel);
        log.debug((Object)"Adding GlobalCRS84Scale");
        GridSet GlobalCRS84Scale = GridSetFactory.createGridSet("GlobalCRS84Scale", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, this.scalesCRS84ScaleResolutions(), null, null, 2.8E-4, null, 256, 256);
        this.gridSets.put(GlobalCRS84Scale.name, GlobalCRS84Scale);
    }

    public GridSet get(String gridSetId) {
        return this.gridSets.get(gridSetId);
    }

    public Hashtable<String, GridSet> getGridSets() {
        return this.gridSets;
    }

    public void put(GridSet gridSet) {
        if (this.gridSets.contains(gridSet.getName())) {
            log.warn((Object)("Duplicate grid set " + gridSet.getName() + ", " + "removing previous instance, but it may still be referenced by layers."));
            this.gridSets.remove(gridSet.getName());
        }
        log.debug((Object)("Adding " + gridSet.getName()));
        this.gridSets.put(gridSet.getName(), gridSet);
    }

    private double[] scalesCRS84PixelResolutions() {
        double[] scalesCRS84Pixel;
        scalesCRS84Pixel = new double[]{2.0, 1.0, 0.5, scalesCRS84Pixel[2] * 0.6666666666666666, scalesCRS84Pixel[2] / 3.0, scalesCRS84Pixel[4] / 2.0, scalesCRS84Pixel[4] / 5.0, scalesCRS84Pixel[4] / 10.0, 0.008333333333333333, scalesCRS84Pixel[8] / 2.0, scalesCRS84Pixel[9] / 3.0, scalesCRS84Pixel[9] / 5.0, scalesCRS84Pixel[11] / 3.0, scalesCRS84Pixel[12] / 2.0, scalesCRS84Pixel[13] * 0.6, scalesCRS84Pixel[14] / 3.0, scalesCRS84Pixel[15] * 0.3, scalesCRS84Pixel[16] / 3.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84ScaleResolutions() {
        double[] scalesCRS84Pixel = new double[]{1.25764139776733, 0.628820698883665, 0.251528279553466, 0.125764139776733, 0.0628820698883665, 0.0251528279553466, 0.0125764139776733, 0.00628820698883665, 0.00251528279553466, 0.00125764139776733, 6.28820698883665E-4, 2.51528279553466E-4, 1.25764139776733E-4, 6.28820698883665E-5, 2.51528279553466E-5, 1.25764139776733E-5, 6.28820698883665E-6, 2.51528279553466E-6, 1.25764139776733E-6, 6.28820698883665E-7, 2.51528279553466E-7};
        return scalesCRS84Pixel;
    }
}

