/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RasterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.util.ServletUtils;

public class WMSRasterFilter
extends RasterFilter {
    private static Log log = LogFactory.getLog(RasterFilter.class);
    public String wmsLayers;
    public String wmsStyles;
    public Integer backendTimeout;

    protected BufferedImage loadMatrix(TileLayer tlayer, String gridSetId, int z) throws IOException, GeoWebCacheException {
        if (!(tlayer instanceof WMSLayer)) {
            return null;
        }
        WMSLayer layer = (WMSLayer)tlayer;
        GridSubset gridSet = layer.getGridSubset(gridSetId);
        int[] widthHeight = this.calculateWidthHeight(gridSet, z);
        String urlStr = this.wmsUrl(layer, gridSet, z, widthHeight);
        log.info((Object)("Updated WMS raster filter, zoom level " + z + " for " + this.getName() + " (" + layer.getName() + ") , " + urlStr));
        URL wmsUrl = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)wmsUrl.openConnection();
        if (this.backendTimeout != null) {
            conn.setConnectTimeout(this.backendTimeout * 1000);
            conn.setReadTimeout(this.backendTimeout * 1000);
        } else {
            conn.setConnectTimeout(120000);
            conn.setReadTimeout(120000);
        }
        if (!conn.getContentType().startsWith("image/")) {
            throw new GeoWebCacheException("Unexpected response content type " + conn.getContentType() + " , request was " + urlStr + "\n");
        }
        if (conn.getResponseCode() != 200) {
            throw new GeoWebCacheException("Received response code " + conn.getResponseCode() + "\n");
        }
        byte[] ret = ServletUtils.readStream(conn.getInputStream(), 16384, 2048);
        ByteArrayInputStream is = new ByteArrayInputStream(ret);
        BufferedImage img = ImageIO.read(is);
        if (img.getWidth() != widthHeight[0] || img.getHeight() != widthHeight[1]) {
            String msg = "WMS raster filter has dimensions " + img.getWidth() + "," + img.getHeight() + ", expected " + widthHeight[0] + "," + widthHeight[1] + "\n";
            throw new GeoWebCacheException(msg);
        }
        return img;
    }

    protected String wmsUrl(WMSLayer layer, GridSubset gridSubset, int z, int[] widthHeight) throws GeoWebCacheException {
        BoundingBox bbox = gridSubset.getCoverageBounds(z);
        StringBuilder str = new StringBuilder();
        str.append(layer.getWMSurl()[0]);
        str.append("SERVICE=WMS&REQUEST=getmap&VERSION=1.1.1");
        str.append("&LAYERS=");
        if (this.wmsLayers != null) {
            str.append(this.wmsLayers);
        } else {
            str.append(layer.getName());
        }
        str.append("&STYLES=");
        if (this.wmsStyles != null) {
            str.append(this.wmsStyles);
        }
        str.append("&SRS=").append(layer.backendSRSOverride(gridSubset.getSRS()));
        str.append("&BBOX=").append(bbox.toString());
        str.append("&WIDTH=").append(widthHeight[0]);
        str.append("&HEIGHT=").append(widthHeight[1]);
        str.append("&FORMAT=").append(ImageMime.tiff.getFormat());
        str.append("&FORMAT_OPTIONS=antialias:none");
        str.append("&BGCOLOR=0xFFFFFF");
        return str.toString();
    }

    public void update(byte[] filterData, TileLayer layer, String gridSetId, int z) throws GeoWebCacheException {
        throw new GeoWebCacheException("update(byte[] filterData, TileLayer layer, String gridSetId, int z) is not appropriate for WMSRasterFilters");
    }

    public boolean update(TileLayer layer, String gridSetId) {
        for (int z = this.zoomStart.intValue(); z <= this.zoomStop; ++z) {
            try {
                this.setMatrix(layer, gridSetId, z, true);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    public void update(TileLayer layer, String gridSetId, int zStart, int zStop) throws GeoWebCacheException {
        for (int z = zStart; z <= zStop; ++z) {
            try {
                this.setMatrix(layer, gridSetId, z, true);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

