/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.demo.Demo;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.Service;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GeoWebCacheDispatcher
extends AbstractController {
    private static Log log = LogFactory.getLog(GeoWebCacheDispatcher.class);
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_DEMO = "demo";
    public static final String TYPE_HOME = "home";
    private TileLayerDispatcher tileLayerDispatcher = null;
    private DefaultStorageFinder defaultStorageFinder = null;
    private GridSetBroker gridSetBroker = null;
    private StorageBroker storageBroker;
    private XMLConfiguration mainConfiguration;
    private RuntimeStats runtimeStats;
    private HashMap<String, Service> services = null;
    private byte[] blankTile = null;
    private String servletPrefix = null;

    public GeoWebCacheDispatcher(TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker, StorageBroker storageBroker, XMLConfiguration mainConfiguration, RuntimeStats runtimeStats) {
        this.tileLayerDispatcher = tileLayerDispatcher;
        this.gridSetBroker = gridSetBroker;
        this.mainConfiguration = mainConfiguration;
        this.runtimeStats = runtimeStats;
        this.storageBroker = storageBroker;
        if (mainConfiguration.isRuntimeStatsEnabled()) {
            this.runtimeStats.start();
        } else {
            runtimeStats = null;
        }
    }

    public void setStorageBroker() {
        log.debug((Object)("GeoWebCacheDispatcher received StorageBroker : " + this.storageBroker.toString()));
    }

    public void setDefaultStorageFinder(DefaultStorageFinder defaultStorageFinder) {
        this.defaultStorageFinder = defaultStorageFinder;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = !servletPrefix.startsWith("/") ? "/" + servletPrefix : servletPrefix;
        log.info((Object)("Invoked setServletPrefix(" + servletPrefix + ")"));
    }

    private void loadServices() {
        WebApplicationContext context = (WebApplicationContext)this.getApplicationContext();
        Map serviceBeans = context.getBeansOfType(Service.class);
        Iterator beanIter = serviceBeans.values().iterator();
        this.services = new HashMap();
        while (beanIter.hasNext()) {
            Service aService = (Service)beanIter.next();
            this.services.put(aService.getPathName(), aService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlankTile() {
        String blankTilePath = this.defaultStorageFinder.findEnvVar("GWC_BLANK_TILE_PATH");
        if (blankTilePath != null) {
            File fh = new File(blankTilePath);
            if (fh.exists() && fh.canRead() && fh.isFile()) {
                long fileSize = fh.length();
                this.blankTile = new byte[(int)fileSize];
                int total = 0;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(fh);
                    int read = 0;
                    while (read != -1) {
                        read = fis.read(this.blankTile, total, this.blankTile.length - total);
                        if (read == -1) continue;
                        total += read;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (total == this.blankTile.length && total > 0) {
                    log.info((Object)("Loaded blank tile from " + blankTilePath));
                } else {
                    log.error((Object)("Failed to load blank tile from " + blankTilePath));
                }
                return;
            }
            log.error((Object)("" + blankTilePath + " does not exist or is not readable."));
        }
        InputStream is = null;
        try {
            is = GeoWebCacheDispatcher.class.getResourceAsStream("blank.png");
            this.blankTile = new byte[425];
            int ret = is.read(this.blankTile);
            log.info((Object)("Read " + ret + " from blank PNG file (expected 425)."));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block14: {
            String[] requestComps = null;
            try {
                String normalizedURI = request.getRequestURI().replaceFirst(request.getContextPath(), "");
                if (this.servletPrefix != null) {
                    normalizedURI = normalizedURI.replaceFirst(this.servletPrefix, "");
                }
                requestComps = this.parseRequest(normalizedURI);
            }
            catch (GeoWebCacheException gwce) {
                this.writeError(response, 400, gwce.getMessage());
                return null;
            }
            try {
                if (requestComps == null || requestComps[0].equalsIgnoreCase(TYPE_HOME)) {
                    this.handleFrontPage(request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_SERVICE)) {
                    this.handleServiceRequest(requestComps[1], request, response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_DEMO) || requestComps[0].equalsIgnoreCase("demos")) {
                    this.handleDemoRequest(requestComps[1], request, response);
                } else {
                    this.writeError(response, 404, "Unknown path: " + requestComps[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof RequestFilterException) {
                    RequestFilterException reqE = (RequestFilterException)e;
                    reqE.setHttpInfoHeader(response);
                    this.writeFixedResponse(response, reqE.getResponseCode(), reqE.getContentType(), reqE.getResponse(), Conveyor.CacheResult.OTHER);
                }
                if (e instanceof OWSException) {
                    OWSException owsE = (OWSException)e;
                    this.writeFixedResponse(response, owsE.getResponseCode(), owsE.getContentType(), owsE.getResponse(), Conveyor.CacheResult.OTHER);
                }
                if (!(e instanceof BadTileException) || log.isDebugEnabled()) {
                    log.error((Object)(e.getMessage() + " " + request.getRequestURL().toString()));
                }
                this.writeError(response, 400, e.getMessage());
                if (e instanceof GeoWebCacheException && !log.isDebugEnabled()) break block14;
                e.printStackTrace();
            }
        }
        return null;
    }

    public void destroy() {
        log.info((Object)"GeoWebCacheDispatcher.destroy() was invoked, shutting down.");
    }

    private String[] parseRequest(String servletPath) throws GeoWebCacheException {
        String[] retStrs = new String[2];
        String[] splitStr = servletPath.split("/");
        if (splitStr == null || splitStr.length < 2) {
            return null;
        }
        retStrs[0] = splitStr[1];
        if (splitStr.length > 2) {
            retStrs[1] = splitStr[2];
        }
        return retStrs;
    }

    private void handleServiceRequest(String serviceStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Conveyor conv = null;
        Service service = this.findService(serviceStr);
        conv = service.getConveyor(request, response);
        if (conv.reqHandler == Conveyor.RequestHandler.SERVICE) {
            service.handleRequest(conv);
        } else {
            ConveyorTile convTile = (ConveyorTile)conv;
            TileLayer layer = this.tileLayerDispatcher.getTileLayer(convTile.getLayerId());
            convTile.setTileLayer(layer);
            layer.applyRequestFilters(convTile);
            try {
                layer.getTile(convTile);
                this.writeData(convTile);
            }
            catch (OutsideCoverageException e) {
                this.writeEmpty(convTile, e.getMessage());
            }
        }
    }

    private void handleDemoRequest(String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        Demo.makeMap(this.tileLayerDispatcher, this.gridSetBroker, action, request, response);
    }

    private Service findService(String serviceStr) throws GeoWebCacheException {
        Service service;
        if (this.services == null) {
            this.loadServices();
            this.loadBlankTile();
        }
        if ((service = this.services.get(serviceStr)) == null) {
            serviceStr = serviceStr == null || serviceStr.length() == 0 ? ", try service/&lt;name of service&gt;" : " \"" + serviceStr + "\"";
            throw new GeoWebCacheException("Unable to find handler for service" + serviceStr);
        }
        return service;
    }

    private void handleFrontPage(HttpServletRequest request, HttpServletResponse response) {
        String baseUrl = null;
        if (request.getRequestURL().toString().endsWith("/") || request.getRequestURL().toString().endsWith(TYPE_HOME)) {
            baseUrl = "";
        } else {
            String[] strs = request.getRequestURL().toString().split("/");
            baseUrl = strs[strs.length - 1] + "/";
        }
        StringBuilder str = new StringBuilder();
        str.append("<html>\n" + ServletUtils.gwcHtmlHeader("GWC Home") + "<body>\n" + ServletUtils.gwcHtmlLogoLink(baseUrl));
        str.append("<h3>Welcome to GeoWebCache version NIGHTLY, built 2010-03-03</h3>\n");
        str.append("<p><a href=\"http://geowebcache.org\">GeoWebCache</a> is an advanced tile cache for WMS servers.");
        str.append("It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</p>");
        str.append("<h3>Automatically Generated Demos:</h3>\n");
        str.append("<ul><li><a href=\"" + baseUrl + "demo\">A list of all the layers and automatic demos</a></li></ul>\n");
        str.append("<h3>GetCapabilities:</h3>\n");
        str.append("<ul><li><a href=\"" + baseUrl + "service/wmts?REQUEST=getcapabilities\">WMTS 1.0.0 GetCapabilities document</a></li>");
        str.append("<li><a href=\"" + baseUrl + "service/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities&TILED=true\">WMS 1.1.1 GetCapabilities document</a></li>");
        str.append("<li><a href=\"" + baseUrl + "service/tms/1.0.0\">TMS 1.0.0 document</a></li>");
        str.append("<li>Note that the latter will only work with clients that are ");
        str.append("<a href=\"http://wiki.osgeo.org/wiki/WMS_Tiling_Client_Recommendation\">WMS-C capable</a>.</li>\n");
        str.append("<li>Omitting tiled=true from the URL will omit the TileSet elements.</li></ul>\n");
        if (this.runtimeStats != null) {
            str.append("<h3>Runtime Statistics</h3>\n");
            str.append(this.runtimeStats.getHTMLStats());
        }
        str.append("</body></html>\n");
        this.writePage(response, 200, str.toString());
    }

    private void writeError(HttpServletResponse response, int httpCode, String errorMsg) {
        log.debug((Object)errorMsg);
        errorMsg = "<html>\n" + ServletUtils.gwcHtmlHeader("GWC Error") + "<body>\n" + ServletUtils.gwcHtmlLogoLink("../") + "<h4>" + httpCode + ": " + errorMsg + "</h4>" + "</body></html>\n";
        this.writePage(response, httpCode, errorMsg);
    }

    private void writePage(HttpServletResponse response, int httpCode, String message) {
        this.writeFixedResponse(response, httpCode, "text/html", message.getBytes(), Conveyor.CacheResult.OTHER);
    }

    private void writeData(ConveyorTile tile) throws IOException {
        if (tile.getLayer().useETags()) {
            String ifNoneMatch = tile.servletReq.getHeader("If-None-Match");
            String hexTag = Long.toHexString(tile.getTSCreated());
            if (ifNoneMatch != null && ifNoneMatch.equals(hexTag)) {
                tile.servletResp.setStatus(304);
                return;
            }
            tile.servletResp.setHeader("ETag", hexTag);
        }
        this.writeFixedResponse(tile.servletResp, 200, tile.getMimeType().getMimeType(), tile.getContent(), tile.getCacheResult());
    }

    private void writeEmpty(ConveyorTile tile, String message) {
        tile.servletResp.setHeader("geowebcache-message", message);
        TileLayer layer = tile.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            if (layer.useETags()) {
                String ifNoneMatch = tile.servletReq.getHeader("If-None-Match");
                if (ifNoneMatch != null && ifNoneMatch.equals("gwc-blank-tile")) {
                    tile.servletResp.setStatus(304);
                    return;
                }
                tile.servletResp.setHeader("ETag", "gwc-blank-tile");
            }
        }
        this.writeFixedResponse(tile.servletResp, 200, ImageMime.png.getMimeType(), this.blankTile, Conveyor.CacheResult.OTHER);
    }

    private void writeFixedResponse(HttpServletResponse response, int httpCode, String contentType, byte[] data, Conveyor.CacheResult cacheRes) {
        response.setStatus(httpCode);
        response.setContentType(contentType);
        if (data != null) {
            response.setContentLength(data.length);
            try {
                ServletOutputStream os = response.getOutputStream();
                os.write(data);
                this.runtimeStats.log(data.length, cacheRes);
            }
            catch (IOException ioe) {
                log.debug((Object)("Caught IOException: " + ioe.getMessage() + "\n\n" + ioe.toString()));
            }
        }
    }
}

