/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.util.logging.Logging;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory;
    final ShapeType shapeType;

    public PolygonHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.POLYGON;
        this.geometryFactory = gf;
    }

    public PolygonHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        for (int t = pointList.length - 1; t >= 0; --t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return length;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.POLYGONZ ? 3 : 2;
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        CoordinateSequence coords = this.readCoordinates(buffer, numPoints, dimensions);
        if (this.shapeType == ShapeType.POLYGONZ) {
            buffer.position(buffer.position() + 16);
            for (int t = 0; t < numPoints; ++t) {
                coords.setOrdinate(t, 2, buffer.getDouble());
            }
        }
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            CoordinateSequence csRing = this.geometryFactory.getCoordinateSequenceFactory().create(length, dimensions);
            for (int i = 0; i < length; ++i) {
                csRing.setOrdinate(i, 0, coords.getOrdinate(offset, 0));
                csRing.setOrdinate(i, 1, coords.getOrdinate(offset, 1));
                if (dimensions == 3) {
                    csRing.setOrdinate(i, 2, coords.getOrdinate(offset, 2));
                }
                ++offset;
            }
            if (csRing.size() != 0 && csRing.size() <= 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(csRing);
            if (PolygonHandler.isCCW(csRing)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.size() == 0) {
            Logging.getLogger((String)"org.geotools.data.shapefile").warning("only one hole in this polygon record");
            return this.createMulti(JTSUtilities.reverseRing((LinearRing)holes.get(0)));
        }
        ArrayList holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private CoordinateSequence readCoordinates(ByteBuffer buffer, int numPoints, int dimensions) {
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(numPoints, dimensions);
        for (int t = 0; t < numPoints; ++t) {
            cs.setOrdinate(t, 0, buffer.getDouble());
            cs.setOrdinate(t, 1, buffer.getDouble());
        }
        return cs;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        int i;
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        if (shells.size() == 0) {
            int ii = holes.size();
            for (i = 0; i < ii; ++i) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(JTSUtilities.reverseRing(hole), new LinearRing[0]);
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    ArrayList assignHolesToShells(ArrayList shells, ArrayList holes) {
        int i;
        ArrayList holesForShells = new ArrayList(shells.size());
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            Geometry minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing(testPt, coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                Logging.getLogger((String)"org.geotools.data.shapefile").warning("polygon found with a hole thats not inside a shell");
                shells.add(JTSUtilities.reverseRing(testRing));
                holesForShells.add(new ArrayList());
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int seqSize;
        CoordinateSequence coords;
        int ringN;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        ArrayList<CoordinateSequence> allCoords = new ArrayList<CoordinateSequence>();
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            allCoords.add(p.getExteriorRing().getCoordinateSequence());
            for (ringN = 0; ringN < p.getNumInteriorRing(); ++ringN) {
                allCoords.add(p.getInteriorRingN(ringN).getCoordinateSequence());
            }
        }
        CoordinateSequence[] coordinates = allCoords.toArray(new CoordinateSequence[allCoords.size()]);
        int nrings = coordinates.length;
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        for (int t = 0; t < nrings; ++t) {
            buffer.putInt(count);
            count += coordinates[t].size();
        }
        double[] zExtreame = new double[]{Double.NaN, Double.NaN};
        for (ringN = 0; ringN < nrings; ++ringN) {
            coords = coordinates[ringN];
            JTSUtilities.zMinMax(coords, zExtreame);
            seqSize = coords.size();
            for (int coordN = 0; coordN < seqSize; ++coordN) {
                buffer.putDouble(coords.getOrdinate(coordN, 0));
                buffer.putDouble(coords.getOrdinate(coordN, 1));
            }
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (ringN = 0; ringN < nrings; ++ringN) {
                coords = coordinates[ringN];
                seqSize = coords.size();
                for (int coordN = 0; coordN < seqSize; ++coordN) {
                    double z = coords.getOrdinate(coordN, 2);
                    if (Double.isNaN(z)) {
                        buffer.putDouble(0.0);
                        continue;
                    }
                    buffer.putDouble(z);
                }
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (int t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }

    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        double hiy = ring.getOrdinate(0, 1);
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            if (!(ring.getOrdinate(i, 1) > hiy)) continue;
            hiy = ring.getOrdinate(i, 1);
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (PolygonHandler.equals2D(ring, iPrev, hiIndex) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (PolygonHandler.equals2D(ring, iNext = (iNext + 1) % nPts, hiIndex) && iNext != hiIndex) {
        }
        if (PolygonHandler.equals2D(ring, iPrev, hiIndex) || PolygonHandler.equals2D(ring, iNext, hiIndex) || PolygonHandler.equals2D(ring, iPrev, iNext)) {
            return false;
        }
        int disc = PolygonHandler.computeOrientation(ring, iPrev, hiIndex, iNext);
        boolean isCCW = false;
        isCCW = disc == 0 ? ring.getOrdinate(iPrev, 0) > ring.getOrdinate(iNext, 0) : disc > 0;
        return isCCW;
    }

    private static boolean equals2D(CoordinateSequence cs, int i, int j) {
        return cs.getOrdinate(i, 0) == cs.getOrdinate(j, 0) && cs.getOrdinate(i, 1) == cs.getOrdinate(j, 1);
    }

    public static int computeOrientation(CoordinateSequence cs, int p1, int p2, int q) {
        double p1x = cs.getOrdinate(p1, 0);
        double p1y = cs.getOrdinate(p1, 1);
        double p2x = cs.getOrdinate(p2, 0);
        double p2y = cs.getOrdinate(p2, 1);
        double qx = cs.getOrdinate(q, 0);
        double qy = cs.getOrdinate(q, 1);
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        double dx2 = qx - p2x;
        double dy2 = qy - p2y;
        return RobustDeterminant.signOfDet2x2(dx1, dy1, dx2, dy2);
    }
}

