/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import org.tuckey.web.filters.validation.utils.StringEscapeUtils;
import org.xml.sax.SAXParseException;

public final class LineIssue {
    public static final String TYPE_FATAL_ERROR = "fat";
    public static final String TYPE_ERROR = "err";
    public static final String TYPE_WARNING = "war";
    private final String type;
    private final int lineNumber;
    private final int columnNumber;
    private final String message;

    public LineIssue(String type, SAXParseException saxParseException) {
        this.type = type;
        this.lineNumber = saxParseException.getLineNumber();
        this.columnNumber = saxParseException.getColumnNumber();
        this.message = StringEscapeUtils.escapeHtml(saxParseException.getMessage());
    }

    public final String getType() {
        return this.type;
    }

    public final String getTypeTitle() {
        if (TYPE_ERROR.equals(this.type)) {
            return "Error";
        }
        if (TYPE_FATAL_ERROR.equals(this.type)) {
            return "Fatal Error";
        }
        if (TYPE_WARNING.equals(this.type)) {
            return "Warning";
        }
        return null;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getColumnNumber() {
        return this.columnNumber;
    }

    public final String getMessage() {
        return this.message;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineIssue)) {
            return false;
        }
        LineIssue lineIssue = (LineIssue)o;
        if (this.columnNumber != lineIssue.columnNumber) {
            return false;
        }
        if (this.lineNumber != lineIssue.lineNumber) {
            return false;
        }
        if (this.message != null ? !this.message.equals(lineIssue.message) : lineIssue.message != null) {
            return false;
        }
        return !(this.type == null ? lineIssue.type != null : !this.type.equals(lineIssue.type));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 29 * result + this.lineNumber;
        result = 29 * result + this.columnNumber;
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

