/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import simple.http.serve.LocateException;
import simple.http.serve.Locator;
import simple.util.FileProperties;

public class FileLocator
implements Locator {
    private File[] list;

    public FileLocator() {
        this(new File[0]);
    }

    public FileLocator(File path) {
        this(new File[]{path});
    }

    public FileLocator(File[] list) {
        this.list = list;
    }

    public String getLocation(String name) throws LocateException {
        String real = this.getRealPath(name);
        int i = 0;
        while (i < this.list.length) {
            try {
                return this.getLocation(this.list[i], real);
            }
            catch (LocateException locateException) {
                ++i;
            }
        }
        return this.getLocation(new File("."), real);
    }

    private String getLocation(File base, String name) throws LocateException {
        File file = new File(base, name);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new LocateException("File not found");
    }

    public File getFile(String name) throws LocateException {
        return new File(this.getLocation(name));
    }

    public Properties getProperties(String name) throws LocateException {
        try {
            return new FileProperties(this.getFile(name));
        }
        catch (IOException e) {
            throw new LocateException("File not found");
        }
    }

    public URL getResource(String name) throws LocateException {
        try {
            return this.getResource(this.getFile(name));
        }
        catch (Exception e) {
            return this.getResource(name, this.getClassLoader());
        }
    }

    private URL getResource(String name, ClassLoader loader) throws LocateException {
        URL target = loader.getResource(name);
        if (target == null) {
            throw new LocateException("File not found");
        }
        return target;
    }

    private URL getResource(File path) throws IOException {
        return path.getCanonicalFile().toURL();
    }

    private ClassLoader getClassLoader() {
        return FileLocator.class.getClassLoader();
    }

    private String getRealPath(String path) {
        return path.replace('/', File.separatorChar);
    }
}

