/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGGraphicFactory
implements ExternalGraphicFactory {
    static Map<URL, RenderableSVG> glyphCache = Collections.synchronizedMap(new SoftValueHashMap());
    static final Set<String> formats = new HashSet<String>(){
        {
            this.add("image/svg");
            this.add("image/svg-xml");
            this.add("image/svg+xml");
        }
    };

    public Icon getIcon(Feature feature, Expression url, String format, int size) throws Exception {
        if (format == null || !formats.contains(format.toLowerCase())) {
            return null;
        }
        URL svgfile = (URL)url.evaluate((Object)feature, URL.class);
        if (svgfile == null) {
            throw new IllegalArgumentException("The specified expression could not be turned into an URL");
        }
        RenderableSVG svg = glyphCache.get(svgfile);
        if (svg == null) {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            Document doc = f.createDocument(url.toString());
            svg = new RenderableSVG(doc);
            glyphCache.put(svgfile, svg);
        }
        return new SVGIcon(svg, size);
    }

    public void resetCache() {
        glyphCache.clear();
    }

    private static class RenderableSVG {
        Rectangle2D bounds;
        private GraphicsNode node;

        public RenderableSVG(Document doc) {
            this.node = this.getGraphicNode(doc);
            this.bounds = this.getSvgDocBounds(doc);
            if (this.bounds == null) {
                this.bounds = this.node.getBounds();
            }
        }

        private Rectangle2D getSvgDocBounds(Document doc) {
            NodeList list = doc.getElementsByTagName("svg");
            Node svgNode = list.item(0);
            NamedNodeMap attrbiutes = svgNode.getAttributes();
            Node widthNode = attrbiutes.getNamedItem("width");
            Node heightNode = attrbiutes.getNamedItem("height");
            if (widthNode != null && heightNode != null) {
                double width = Double.parseDouble(widthNode.getNodeValue());
                double height = Double.parseDouble(heightNode.getNodeValue());
                return new Rectangle2D.Double(0.0, 0.0, width, height);
            }
            return null;
        }

        private GraphicsNode getGraphicNode(Document doc) {
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            return builder.build(ctx, doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D g, int width, int height, int x, int y) {
            AffineTransform oldTransform = g.getTransform();
            try {
                if (oldTransform == null) {
                    oldTransform = new AffineTransform();
                }
                AffineTransform transform = new AffineTransform(oldTransform);
                transform.scale((double)width / this.bounds.getWidth(), (double)height / this.bounds.getHeight());
                g.setTransform(transform);
                this.node.paint(g);
            }
            finally {
                g.setTransform(oldTransform);
            }
        }
    }

    private static class SVGIcon
    implements Icon {
        private int width;
        private int height;
        private RenderableSVG svg;

        public SVGIcon(RenderableSVG svg, int size) {
            this.svg = svg;
            Rectangle2D bounds = svg.bounds;
            double targetWidth = bounds.getWidth();
            double targetHeight = bounds.getHeight();
            if (size > 0) {
                double shapeAspectRatio = bounds.getHeight() > 0.0 && bounds.getWidth() > 0.0 ? bounds.getWidth() / bounds.getHeight() : 1.0;
                targetWidth = shapeAspectRatio * (double)size;
                targetHeight = size;
            }
            this.width = (int)Math.round(targetWidth);
            this.height = (int)Math.round(targetHeight);
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.svg.paint((Graphics2D)g, this.width, this.height, x, y);
        }
    }
}

