/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.filter.expression.DirectPropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.SimpleFeaturePropertyAccessorFactory;

public class PropertyAccessors {
    static final PropertyAccessorFactory[] FACTORY_CACHE;

    private PropertyAccessors() {
    }

    public static PropertyAccessor findPropertyAccessor(Object object, String xpath, Class target, Hints hints) {
        if (object == null) {
            return null;
        }
        for (PropertyAccessorFactory factory : FACTORY_CACHE) {
            PropertyAccessor accessor = factory.createPropertyAccessor(object.getClass(), xpath, target, hints);
            if (accessor == null || !accessor.canHandle(object, xpath, target)) continue;
            return accessor;
        }
        return null;
    }

    static {
        ArrayList<PropertyAccessorFactory> cache = new ArrayList<PropertyAccessorFactory>();
        cache.add(new SimpleFeaturePropertyAccessorFactory());
        cache.add(new DirectPropertyAccessorFactory());
        Iterator factories = FactoryRegistry.lookupProviders(PropertyAccessorFactory.class);
        while (factories.hasNext()) {
            Object factory = factories.next();
            if (factory instanceof SimpleFeaturePropertyAccessorFactory || factory instanceof DirectPropertyAccessorFactory) continue;
            cache.add((PropertyAccessorFactory)factory);
        }
        FACTORY_CACHE = cache.toArray(new PropertyAccessorFactory[cache.size()]);
    }
}

