/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.AttributeExpressionImpl2;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.EnvironmentVariable;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MapScaleDenominatorImpl;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NotImpl;
import org.geotools.filter.NullFilter;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.SortByImpl;
import org.geotools.filter.capability.ArithmeticOperatorsImpl;
import org.geotools.filter.capability.ComparisonOperatorsImpl;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.capability.FunctionsImpl;
import org.geotools.filter.capability.IdCapabilitiesImpl;
import org.geotools.filter.capability.OperatorImpl;
import org.geotools.filter.capability.ScalarCapabilitiesImpl;
import org.geotools.filter.capability.SpatialCapabiltiesImpl;
import org.geotools.filter.capability.SpatialOperatorImpl;
import org.geotools.filter.capability.SpatialOperatorsImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.DisjointImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Functions;
import org.opengis.filter.capability.GeometryOperand;
import org.opengis.filter.capability.IdCapabilities;
import org.opengis.filter.capability.Operator;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperator;
import org.opengis.filter.capability.SpatialOperators;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Geometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactoryImpl
implements FilterFactory {
    private FunctionFinder functionFinder = new FunctionFinder(null);

    public FilterFactoryImpl() {
        this(null);
    }

    public FilterFactoryImpl(Hints hints) {
    }

    public FeatureId featureId(String id) {
        return new FeatureIdImpl(id);
    }

    public GmlObjectId gmlObjectId(String id) {
        return new GmlObjectIdImpl(id);
    }

    public And and(org.opengis.filter.Filter f, org.opengis.filter.Filter g) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>(2);
        list.add(f);
        list.add(g);
        return new AndImpl((org.opengis.filter.FilterFactory)this, list);
    }

    public And and(List filters) {
        return new AndImpl((org.opengis.filter.FilterFactory)this, filters);
    }

    public Or or(org.opengis.filter.Filter f, org.opengis.filter.Filter g) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>(2);
        list.add(f);
        list.add(g);
        return new OrImpl((org.opengis.filter.FilterFactory)this, list);
    }

    public Or or(List filters) {
        return new OrImpl((org.opengis.filter.FilterFactory)this, filters);
    }

    public Not not(org.opengis.filter.Filter filter) {
        return new NotImpl((org.opengis.filter.FilterFactory)this, filter);
    }

    public Id id(Set id) {
        return new FidFilterImpl(id);
    }

    public PropertyName property(String name) {
        return new AttributeExpressionImpl(name);
    }

    public PropertyIsBetween between(Expression expr, Expression lower, Expression upper) {
        return new IsBetweenImpl((org.opengis.filter.FilterFactory)this, lower, expr, upper);
    }

    public PropertyIsEqualTo equals(Expression expr1, Expression expr2) {
        return this.equal(expr1, expr2, true);
    }

    public PropertyIsEqualTo equal(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsEqualsToImpl((org.opengis.filter.FilterFactory)this, expr1, expr2, matchCase);
    }

    public PropertyIsNotEqualTo notEqual(Expression expr1, Expression expr2) {
        return this.notEqual(expr1, expr2, false);
    }

    public PropertyIsNotEqualTo notEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsNotEqualToImpl((org.opengis.filter.FilterFactory)this, expr1, expr2, matchCase);
    }

    public PropertyIsGreaterThan greater(Expression expr1, Expression expr2) {
        return this.greater(expr1, expr2, false);
    }

    public PropertyIsGreaterThan greater(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsGreaterThanImpl((org.opengis.filter.FilterFactory)this, expr1, expr2);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(Expression expr1, Expression expr2) {
        return this.greaterOrEqual(expr1, expr2, false);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsGreaterThanOrEqualToImpl((org.opengis.filter.FilterFactory)this, expr1, expr2, matchCase);
    }

    public PropertyIsLessThan less(Expression expr1, Expression expr2) {
        return this.less(expr1, expr2, false);
    }

    public PropertyIsLessThan less(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsLessThenImpl((org.opengis.filter.FilterFactory)this, expr1, expr2, matchCase);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(Expression expr1, Expression expr2) {
        return this.lessOrEqual(expr1, expr2, false);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(Expression expr1, Expression expr2, boolean matchCase) {
        return new IsLessThenOrEqualToImpl((org.opengis.filter.FilterFactory)this, expr1, expr2, false);
    }

    public PropertyIsLike like(Expression expr, String pattern) {
        return this.like(expr, pattern, "*", "?", "\\");
    }

    public PropertyIsLike like(Expression expr, String pattern, String wildcard, String singleChar, String escape) {
        return this.like(expr, pattern, wildcard, singleChar, escape, false);
    }

    public PropertyIsLike like(Expression expr, String pattern, String wildcard, String singleChar, String escape, boolean matchCase) {
        LikeFilterImpl filter = new LikeFilterImpl();
        filter.setExpression(expr);
        filter.setPattern(pattern, wildcard, singleChar, escape);
        filter.setMatchingCase(matchCase);
        return filter;
    }

    public PropertyIsNull isNull(Expression expr) {
        return new IsNullImpl((org.opengis.filter.FilterFactory)this, expr);
    }

    public BBOX bbox(String propertyName, double minx, double miny, double maxx, double maxy, String srs) {
        PropertyName name = this.property(propertyName);
        return this.bbox((Expression)name, minx, miny, maxx, maxy, srs);
    }

    public BBOX bbox(Expression geometry, Expression bounds) {
        return new BBOXImpl((org.opengis.filter.FilterFactory)this, geometry, bounds);
    }

    public BBOX bbox(Expression geometry, BoundingBox bounds) {
        return this.bbox(geometry, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), CRS.toSRS(bounds.getCoordinateReferenceSystem()));
    }

    @Override
    public BBOX bbox(Expression e, double minx, double miny, double maxx, double maxy, String srs) {
        PropertyName name = null;
        if (!(e instanceof PropertyName)) {
            throw new IllegalArgumentException();
        }
        name = (PropertyName)e;
        BBoxExpression bbox = null;
        try {
            bbox = this.createBBoxExpression(new Envelope(minx, maxx, miny, maxy));
        }
        catch (IllegalFilterException ife) {
            new IllegalArgumentException().initCause(ife);
        }
        BBOXImpl box = new BBOXImpl((org.opengis.filter.FilterFactory)this, e, bbox);
        if (e == null) {
            box.setPropertyName(name.getPropertyName());
        }
        box.setSRS(srs);
        box.setMinX(minx);
        box.setMinY(miny);
        box.setMaxX(maxx);
        box.setMaxY(maxy);
        return box;
    }

    public Beyond beyond(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.beyond((Expression)name, (Expression)geom, distance, units);
    }

    @Override
    public Beyond beyond(Expression geometry1, Expression geometry2, double distance, String units) {
        BeyondImpl beyond = new BeyondImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
        beyond.setDistance(distance);
        beyond.setUnits(units);
        return beyond;
    }

    public Contains contains(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.contains((Expression)name, (Expression)geom);
    }

    @Override
    public Contains contains(Expression geometry1, Expression geometry2) {
        return new ContainsImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Crosses crosses(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.crosses((Expression)name, (Expression)geom);
    }

    @Override
    public Crosses crosses(Expression geometry1, Expression geometry2) {
        return new CrossesImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Disjoint disjoint(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.disjoint((Expression)name, (Expression)geom);
    }

    @Override
    public Disjoint disjoint(Expression geometry1, Expression geometry2) {
        return new DisjointImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public DWithin dwithin(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.dwithin((Expression)name, (Expression)geom, distance, units);
    }

    @Override
    public DWithin dwithin(Expression geometry1, Expression geometry2, double distance, String units) {
        DWithinImpl dwithin = new DWithinImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
        dwithin.setDistance(distance);
        dwithin.setUnits(units);
        return dwithin;
    }

    public Equals equals(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.equal((Expression)name, (Expression)geom);
    }

    @Override
    public Equals equal(Expression geometry1, Expression geometry2) {
        return new EqualsImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Intersects intersects(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.intersects((Expression)name, (Expression)geom);
    }

    @Override
    public Intersects intersects(Expression geometry1, Expression geometry2) {
        return new IntersectsImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Overlaps overlaps(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.overlaps((Expression)name, (Expression)geom);
    }

    @Override
    public Overlaps overlaps(Expression geometry1, Expression geometry2) {
        return new OverlapsImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Touches touches(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.touches((Expression)name, (Expression)geom);
    }

    @Override
    public Touches touches(Expression geometry1, Expression geometry2) {
        return new TouchesImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Within within(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.within((Expression)name, (Expression)geom);
    }

    @Override
    public Within within(Expression geometry1, Expression geometry2) {
        return new WithinImpl((org.opengis.filter.FilterFactory)this, geometry1, geometry2);
    }

    public Add add(Expression expr1, Expression expr2) {
        return new AddImpl(expr1, expr2);
    }

    public Divide divide(Expression expr1, Expression expr2) {
        return new DivideImpl(expr1, expr2);
    }

    public Multiply multiply(Expression expr1, Expression expr2) {
        return new MultiplyImpl(expr1, expr2);
    }

    public Subtract subtract(Expression expr1, Expression expr2) {
        return new SubtractImpl(expr1, expr2);
    }

    public Function function(String name, Expression[] args) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(args));
        return function;
    }

    public Function function(String name, Expression arg1) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1));
        return function;
    }

    public Function function(String name, Expression arg1, Expression arg2) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2));
        return function;
    }

    public Function function(String name, List<Expression> parameters, Literal fallback) {
        Function function = this.functionFinder.findFunction(name, parameters, fallback);
        return function;
    }

    public Function function(String name, Expression arg1, Expression arg2, Expression arg3) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2, arg3));
        return function;
    }

    public Literal literal(Object obj) {
        try {
            return new LiteralExpressionImpl(obj);
        }
        catch (IllegalFilterException e) {
            new IllegalArgumentException().initCause(e);
            return null;
        }
    }

    public Literal literal(byte b) {
        return new LiteralExpressionImpl(b);
    }

    public Literal literal(short s) {
        return new LiteralExpressionImpl(s);
    }

    public Literal literal(int i) {
        return new LiteralExpressionImpl(i);
    }

    public Literal literal(long l) {
        return new LiteralExpressionImpl(l);
    }

    public Literal literal(float f) {
        return new LiteralExpressionImpl(f);
    }

    public Literal literal(double d) {
        return new LiteralExpressionImpl(d);
    }

    public Literal literal(char c) {
        return new LiteralExpressionImpl(c);
    }

    public Literal literal(boolean b) {
        return b ? new LiteralExpressionImpl(Boolean.TRUE) : new LiteralExpressionImpl(Boolean.FALSE);
    }

    @Override
    public AttributeExpression createAttributeExpression(String xpath) {
        return new AttributeExpressionImpl(xpath);
    }

    @Override
    public AttributeExpression createAttributeExpression(SimpleFeatureType schema) {
        return new AttributeExpressionImpl(schema);
    }

    @Override
    public AttributeExpression createAttributeExpression(SimpleFeatureType schema, String path) throws IllegalFilterException {
        return new AttributeExpressionImpl(schema, path);
    }

    @Override
    public AttributeExpression createAttributeExpression(AttributeDescriptor at) throws IllegalFilterException {
        return new AttributeExpressionImpl2(at);
    }

    @Override
    public BBoxExpression createBBoxExpression(Envelope env) throws IllegalFilterException {
        return new BBoxExpressionImpl(env);
    }

    @Override
    public BetweenFilter createBetweenFilter() throws IllegalFilterException {
        return new BetweenFilterImpl();
    }

    @Override
    public CompareFilter createCompareFilter(short type) throws IllegalFilterException {
        switch (type) {
            case 14: {
                return new IsEqualsToImpl((org.opengis.filter.FilterFactory)this);
            }
            case 23: {
                return new IsNotEqualToImpl((org.opengis.filter.FilterFactory)this);
            }
            case 16: {
                return new IsGreaterThanImpl((org.opengis.filter.FilterFactory)this);
            }
            case 18: {
                return new IsGreaterThanOrEqualToImpl((org.opengis.filter.FilterFactory)this);
            }
            case 15: {
                return new IsLessThenImpl((org.opengis.filter.FilterFactory)this);
            }
            case 17: {
                return new IsLessThenOrEqualToImpl((org.opengis.filter.FilterFactory)this);
            }
            case 19: {
                return new BetweenFilterImpl((org.opengis.filter.FilterFactory)this);
            }
        }
        throw new IllegalFilterException("Must be one of <,<=,==,>,>=,<>");
    }

    @Override
    public FidFilter createFidFilter() {
        return new FidFilterImpl();
    }

    @Override
    public FidFilter createFidFilter(String fid) {
        return new FidFilterImpl(fid);
    }

    @Override
    public GeometryFilter createGeometryFilter(short filterType) throws IllegalFilterException {
        switch (filterType) {
            case 5: {
                return new EqualsImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 6: {
                return new DisjointImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 24: {
                return new DWithinImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 7: {
                return new IntersectsImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 9: {
                return new CrossesImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 10: {
                return new WithinImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 11: {
                return new ContainsImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 12: {
                return new OverlapsImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 13: {
                return new BeyondImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 4: {
                return new BBOXImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 8: {
                return new TouchesImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
        }
        throw new IllegalFilterException("Not one of the accepted spatial filter types.");
    }

    @Override
    public GeometryDistanceFilter createGeometryDistanceFilter(short filterType) throws IllegalFilterException {
        switch (filterType) {
            case 13: {
                return new BeyondImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
            case 24: {
                return new DWithinImpl((org.opengis.filter.FilterFactory)this, null, null);
            }
        }
        throw new IllegalFilterException("Not one of the accepted spatial filter types.");
    }

    @Override
    public LikeFilter createLikeFilter() {
        return new LikeFilterImpl();
    }

    @Override
    public LiteralExpression createLiteralExpression() {
        return new LiteralExpressionImpl();
    }

    @Override
    public LiteralExpression createLiteralExpression(Object o) throws IllegalFilterException {
        return new LiteralExpressionImpl(o);
    }

    @Override
    public LiteralExpression createLiteralExpression(int i) {
        return new LiteralExpressionImpl(i);
    }

    @Override
    public LiteralExpression createLiteralExpression(double d) {
        return new LiteralExpressionImpl(d);
    }

    @Override
    public LiteralExpression createLiteralExpression(String s) {
        return new LiteralExpressionImpl(s);
    }

    @Override
    public LogicFilter createLogicFilter(short filterType) throws IllegalFilterException {
        ArrayList children = new ArrayList();
        switch (filterType) {
            case 2: {
                return new AndImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 1: {
                return new OrImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 3: {
                return new NotImpl((org.opengis.filter.FilterFactory)this);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    @Override
    public LogicFilter createLogicFilter(Filter filter, short filterType) throws IllegalFilterException {
        ArrayList<Filter> children = new ArrayList<Filter>();
        children.add(filter);
        switch (filterType) {
            case 2: {
                return new AndImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 1: {
                return new OrImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 3: {
                return new NotImpl((org.opengis.filter.FilterFactory)this, filter);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    @Override
    public LogicFilter createLogicFilter(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        ArrayList<Filter> children = new ArrayList<Filter>();
        children.add(filter1);
        children.add(filter2);
        switch (filterType) {
            case 2: {
                return new AndImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 1: {
                return new OrImpl((org.opengis.filter.FilterFactory)this, children);
            }
            case 3: {
                return new NotImpl((org.opengis.filter.FilterFactory)this, filter1);
            }
        }
        throw new IllegalFilterException("Must be one of AND,OR,NOT.");
    }

    @Override
    public MathExpression createMathExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MathExpression createMathExpression(short expressionType) throws IllegalFilterException {
        switch (expressionType) {
            case 105: {
                return new AddImpl(null, null);
            }
            case 106: {
                return new SubtractImpl(null, null);
            }
            case 107: {
                return new MultiplyImpl(null, null);
            }
            case 108: {
                return new DivideImpl(null, null);
            }
        }
        throw new IllegalFilterException("Unsupported math expression");
    }

    @Override
    public FunctionExpression createFunctionExpression(String name) {
        return (FunctionExpression)this.functionFinder.findFunction(name);
    }

    @Override
    public NullFilter createNullFilter() {
        return new NullFilterImpl();
    }

    @Override
    public EnvironmentVariable createEnvironmentVariable(String name) {
        if (name.equalsIgnoreCase("MapScaleDenominator")) {
            return new MapScaleDenominatorImpl();
        }
        throw new RuntimeException("Unknown environment variable:" + name);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public SortBy sort(String propertyName, SortOrder order) {
        return new SortByImpl(this.property(propertyName), order);
    }

    @Override
    public Filter and(Filter filter1, Filter filter2) {
        return (Filter)this.and((org.opengis.filter.Filter)filter1, (org.opengis.filter.Filter)filter2);
    }

    @Override
    public Filter not(Filter filter) {
        return (Filter)this.not((org.opengis.filter.Filter)filter);
    }

    @Override
    public Filter or(Filter filter1, Filter filter2) {
        return (Filter)this.or((org.opengis.filter.Filter)filter1, (org.opengis.filter.Filter)filter2);
    }

    public Beyond beyond(Expression geometry1, Geometry geometry2, double distance, String units) {
        return this.beyond(geometry1, (Expression)this.literal(geometry2), distance, units);
    }

    public PropertyName property(Name name) {
        return this.property(name.toString());
    }

    public Within within(Expression geometry1, Geometry geometry2) {
        return this.within(geometry1, (Expression)this.literal(geometry2));
    }

    public Operator operator(String name) {
        return new OperatorImpl(name);
    }

    public SpatialOperator spatialOperator(String name, GeometryOperand[] geometryOperands) {
        return new SpatialOperatorImpl(name, geometryOperands);
    }

    public FunctionName functionName(String name, int nargs) {
        return new FunctionNameImpl(name, nargs);
    }

    public Functions functions(FunctionName[] functionNames) {
        return new FunctionsImpl(functionNames);
    }

    public SpatialOperators spatialOperators(SpatialOperator[] spatialOperators) {
        return new SpatialOperatorsImpl(spatialOperators);
    }

    public ArithmeticOperators arithmeticOperators(boolean simple, Functions functions) {
        return new ArithmeticOperatorsImpl(simple, functions);
    }

    public ComparisonOperators comparisonOperators(Operator[] comparisonOperators) {
        return new ComparisonOperatorsImpl(comparisonOperators);
    }

    public FilterCapabilities capabilities(String version, ScalarCapabilities scalar, SpatialCapabilities spatial, IdCapabilities id) {
        return new FilterCapabilitiesImpl(version, scalar, spatial, id);
    }

    public ScalarCapabilities scalarCapabilities(ComparisonOperators comparison, ArithmeticOperators arithmetic, boolean logicalOperators) {
        return new ScalarCapabilitiesImpl(comparison, arithmetic, logicalOperators);
    }

    public SpatialCapabilities spatialCapabilities(GeometryOperand[] geometryOperands, SpatialOperators spatial) {
        return new SpatialCapabiltiesImpl(geometryOperands, spatial);
    }

    public IdCapabilities idCapabilities(boolean eid, boolean fid) {
        return new IdCapabilitiesImpl(eid, fid);
    }
}

