/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Set;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.geotools.resources.LazySet;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;

public final class CommonFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private CommonFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CommonFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(StyleFactory.class, FilterFactory.class, FeatureLockFactory.class, FileDataStoreFactorySpi.class, FunctionImpl.class, FunctionExpression.class, Function.class, FeatureFactory.class, FeatureTypeFactory.class, FeatureCollections.class));
        }
        return registry;
    }

    public static synchronized StyleFactory getStyleFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (StyleFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(StyleFactory.class, null, hints, (Hints.Key)Hints.STYLE_FACTORY);
    }

    public static synchronized Set getStyleFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(StyleFactory.class, null, hints));
    }

    public static synchronized Set getFunctionExpressions(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FunctionExpression.class, null, hints));
    }

    public static synchronized Set getFunctions(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(Function.class, null, hints));
    }

    public static synchronized FeatureLockFactory getFeatureLockFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureLockFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureLockFactory.class, null, hints, (Hints.Key)Hints.FEATURE_LOCK_FACTORY);
    }

    public static synchronized Set getFeatureLockFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureLockFactory.class, null, hints));
    }

    public static synchronized Set getFileDataStoreFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FileDataStoreFactorySpi.class, null, hints));
    }

    public static synchronized FeatureFactory getFeatureFactory(Hints hints) {
        if ((hints = CommonFactoryFinder.mergeSystemHints((Hints)hints)).get((Object)Hints.FEATURE_FACTORY) == null) {
            hints.put((Object)Hints.FEATURE_FACTORY, LenientFeatureFactoryImpl.class);
        }
        return (FeatureFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureFactory.class, null, hints, (Hints.Key)Hints.FEATURE_FACTORY);
    }

    public static synchronized FeatureTypeFactory getFeatureTypeFactory(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureTypeFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureTypeFactory.class, null, hints, (Hints.Key)Hints.FEATURE_TYPE_FACTORY);
    }

    public static synchronized FeatureCollections getFeatureCollections(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FeatureCollections)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FeatureCollections.class, null, hints, (Hints.Key)Hints.FEATURE_COLLECTIONS);
    }

    public static synchronized Set getFeatureCollectionsSet(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FeatureCollections.class, null, hints));
    }

    public static synchronized FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return (FilterFactory)CommonFactoryFinder.getServiceRegistry().getServiceProvider(FilterFactory.class, null, hints, (Hints.Key)Hints.FILTER_FACTORY);
    }

    public static synchronized Set getFilterFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints((Hints)hints);
        return new LazySet(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FilterFactory.class, null, hints));
    }

    public static FilterFactory2 getFilterFactory2(Hints hints) throws FactoryRegistryException {
        Object h = (hints = CommonFactoryFinder.mergeSystemHints((Hints)hints)).get((Object)Hints.FILTER_FACTORY);
        if (!(!(h instanceof Class) ? h instanceof FilterFactory2 : FilterFactory2.class.isAssignableFrom((Class)h))) {
            hints = new Hints((RenderingHints)hints);
            hints.put((Object)Hints.FILTER_FACTORY, FilterFactory2.class);
        }
        return (FilterFactory2)CommonFactoryFinder.getFilterFactory(hints);
    }

    public static synchronized void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }
}

