/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();
    public static final SimpleFeature NULL = new SimpleFeature(){

        public Object getAttribute(String path) {
            return null;
        }

        public Object getAttribute(int index) {
            return null;
        }

        public Object[] getAttributes(Object[] attributes) {
            return null;
        }

        public ReferencedEnvelope getBounds() {
            return null;
        }

        public Geometry getDefaultGeometry() {
            return null;
        }

        public SimpleFeatureType getFeatureType() {
            return null;
        }

        public String getID() {
            return null;
        }

        public FeatureId getIdentifier() {
            return null;
        }

        public int getNumberOfAttributes() {
            return 0;
        }

        public void setAttribute(int position, Object val) {
        }

        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
        }

        public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        }

        public Object getAttribute(Name name) {
            return null;
        }

        public int getAttributeCount() {
            return 0;
        }

        public List<Object> getAttributes() {
            return null;
        }

        public SimpleFeatureType getType() {
            return null;
        }

        public void setAttribute(Name name, Object value) {
        }

        public void setAttributes(List<Object> values) {
        }

        public void setAttributes(Object[] values) {
        }

        public void setDefaultGeometry(Object geometry) {
        }

        public GeometryAttribute getDefaultGeometryProperty() {
            return null;
        }

        public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        }

        public Collection<Property> getProperties(Name name) {
            return null;
        }

        public Collection<Property> getProperties() {
            return null;
        }

        public Collection<Property> getProperties(String name) {
            return null;
        }

        public Property getProperty(Name name) {
            return null;
        }

        public Property getProperty(String name) {
            return null;
        }

        public Collection<? extends Property> getValue() {
            return null;
        }

        public void setValue(Collection<Property> values) {
        }

        public AttributeDescriptor getDescriptor() {
            return null;
        }

        public Name getName() {
            return null;
        }

        public Map<Object, Object> getUserData() {
            return null;
        }

        public boolean isNillable() {
            return false;
        }

        public void setValue(Object newValue) {
        }

        public String toString() {
            return "<NullFeature>";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object arg0) {
            return arg0 == this;
        }

        public void validate() {
        }
    };

    public TransactionStateDiff(AbstractDataStore dataStore) {
        this.store = dataStore;
    }

    @Override
    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.typeNameDiff != null) {
                for (Diff diff : this.typeNameDiff.values()) {
                    diff.clear();
                }
                this.typeNameDiff.clear();
            }
            this.store = null;
        }
    }

    public synchronized Diff diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return (Diff)this.typeNameDiff.get(typeName);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types;
        try {
            types = this.store.getTypeNames();
        }
        catch (IOException e) {
            return false;
        }
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    @Override
    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    @Override
    public synchronized void commit() throws IOException {
        for (Map.Entry entry : this.typeNameDiff.entrySet()) {
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            this.applyDiff(typeName, diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDiff(String typeName, Diff diff) throws IOException {
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        if (diff.isEmpty()) {
            return;
        }
        try {
            writer = this.store.createFeatureWriter(typeName, this.transaction);
        }
        catch (UnsupportedOperationException e) {
            try {
                writer = this.store.getFeatureWriter(typeName);
            }
            catch (UnsupportedOperationException eek) {
                throw e;
            }
        }
        try {
            String fid;
            while (writer.hasNext()) {
                SimpleFeature feature = writer.next();
                fid = feature.getID();
                if (!diff.modified2.containsKey(fid)) continue;
                SimpleFeature update = (SimpleFeature)diff.modified2.get(fid);
                if (update == NULL) {
                    writer.remove();
                    this.store.listenerManager.fireFeaturesRemoved(typeName, this.transaction, ReferencedEnvelope.reference(feature.getBounds()), true);
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes());
                    writer.write();
                    ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)null);
                    bounds.include(feature.getBounds());
                    bounds.include(update.getBounds());
                    this.store.listenerManager.fireFeaturesChanged(typeName, this.transaction, bounds, true);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, (Throwable)((Object)e));
                }
            }
            Diff diff2 = diff;
            synchronized (diff2) {
                for (SimpleFeature addedFeature : diff.added.values()) {
                    fid = addedFeature.getID();
                    SimpleFeature nextFeature = writer.next();
                    if (nextFeature == null) {
                        throw new DataSourceException("Could not add " + fid);
                    }
                    try {
                        nextFeature.setAttributes(addedFeature.getAttributes());
                        writer.write();
                        this.store.listenerManager.fireFeaturesAdded(typeName, this.transaction, ReferencedEnvelope.reference(nextFeature.getBounds()), true);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could update " + fid, (Throwable)((Object)e));
                    }
                }
            }
        }
        finally {
            writer.close();
            this.store.listenerManager.fireChanged(typeName, this.transaction, true);
            diff.clear();
        }
    }

    @Override
    public synchronized void rollback() throws IOException {
        for (Map.Entry entry : this.typeNameDiff.entrySet()) {
            String typeName = (String)entry.getKey();
            Diff diff = (Diff)entry.getValue();
            diff.clear();
            this.store.listenerManager.fireChanged(typeName, this.transaction, false);
        }
    }

    public synchronized FeatureReader<SimpleFeatureType, SimpleFeature> reader(String typeName) throws IOException {
        Diff diff = this.diff(typeName);
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, diff);
    }

    public synchronized FeatureWriter<SimpleFeatureType, SimpleFeature> writer(final String typeName, Filter filter) throws IOException {
        Diff diff = this.diff(typeName);
        FilteringFeatureReader<SimpleFeatureType, SimpleFeature> reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(this.store.getFeatureReader(typeName, new DefaultQuery(typeName, filter)), filter);
        return new DiffFeatureWriter(reader, diff, filter){

            public void fireNotification(int eventType, ReferencedEnvelope bounds) {
                switch (eventType) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, TransactionStateDiff.this.transaction, bounds, false);
                    }
                }
            }

            public String toString() {
                return "<DiffFeatureWriter>(" + this.reader.toString() + ")";
            }
        };
    }
}

