/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.geoserver.web.GeoServerApplication;
import org.geotools.util.logging.Logging;

public class WebUtils {
    static final Logger LOGGER = Logging.getLogger(WebUtils.class);

    public static String localize(String key, IModel model, Object ... params) {
        StringResourceModel rm = new StringResourceModel(key, null, model, params){

            public void setLocalizer(Localizer localizer) {
                super.setLocalizer(localizer);
                this.load();
            }
        };
        rm.setLocalizer(GeoServerApplication.get().getResourceSettings().getLocalizer());
        return rm.getString();
    }

    public static IResourceStream getFreemakerMarkupStream(Component c, TemplateModel model) {
        return new FreemarkerResourceStream(c.getClass(), model);
    }

    static class FreemarkerResourceStream
    implements IResourceStream {
        Class clazz;
        TemplateModel model;
        String templateName;
        Configuration cfg;

        FreemarkerResourceStream(Class clazz, TemplateModel model) {
            this.clazz = clazz;
            this.model = model;
            this.templateName = clazz.getSimpleName() + ".ftl";
            this.cfg = new Configuration();
            this.cfg.setClassForTemplateLoading(clazz, "");
        }

        public String getContentType() {
            return "text/html";
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                Template t = this.cfg.getTemplate(this.templateName);
                t.process((Object)this.model, (Writer)new OutputStreamWriter(output));
                return new ByteArrayInputStream(output.toByteArray());
            }
            catch (IOException e) {
                throw (ResourceStreamNotFoundException)new ResourceStreamNotFoundException("Could not find template for: " + this.clazz).initCause((Throwable)e);
            }
            catch (TemplateException e) {
                throw (ResourceStreamNotFoundException)new ResourceStreamNotFoundException("Error in tempalte for: " + this.clazz).initCause((Throwable)e);
            }
        }

        public Locale getLocale() {
            return this.cfg.getLocale();
        }

        public void setLocale(Locale locale) {
            this.cfg.setLocale(locale);
        }

        public long length() {
            return -1L;
        }

        public Time lastModifiedTime() {
            Object source;
            try {
                source = this.cfg.getTemplateLoader().findTemplateSource(this.templateName);
            }
            catch (IOException e) {
                return null;
            }
            if (source != null) {
                long modified = this.cfg.getTemplateLoader().getLastModified(source);
                return Time.valueOf((long)modified);
            }
            return null;
        }

        public void close() throws IOException {
        }
    }
}

