/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.data.store.AbstractCoverageStorePage;
import org.geoserver.web.data.store.CheckExistingResourcesInWorkspaceValidator;
import org.geoserver.web.data.store.StoreConnectionFailedInformationPanel;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.opengis.coverage.grid.GridCoverageReader;

public class CoverageStoreEditPage
extends AbstractCoverageStorePage {
    public static final String STORE_NAME = "storeName";
    public static final String WS_NAME = "wsName";
    private GeoServerDialog dialog;

    public CoverageStoreEditPage(PageParameters parameters) {
        String wsName = parameters.getString(WS_NAME);
        String storeName = parameters.getString(STORE_NAME);
        CoverageStoreInfo csi = this.getCatalog().getCoverageStoreByName(wsName, storeName);
        if (csi == null) {
            this.error((Serializable)((Object)new ParamResourceModel("CoverageStoreEditPage.notFound", (Component)this, wsName, storeName).getString()));
            this.setResponsePage(StorePage.class);
            return;
        }
        this.initUI(csi);
    }

    public CoverageStoreEditPage(String storeId) throws IllegalArgumentException {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getCoverageStore(storeId);
        if (store == null) {
            throw new IllegalArgumentException("Cannot find coverage store " + storeId);
        }
        this.initUI(store);
    }

    void initUI(CoverageStoreInfo store) {
        this.dialog = new GeoServerDialog("dialog");
        this.add((Component)this.dialog);
        super.initUI(store);
        String workspaceId = store.getWorkspace().getId();
        this.workspacePanel.getFormComponent().add((IValidator)new CheckExistingResourcesInWorkspaceValidator(store.getId(), workspaceId));
    }

    protected final void onSave(CoverageStoreInfo info, AjaxRequestTarget requestTarget) throws IllegalArgumentException {
        if (null == info.getType()) {
            throw new IllegalArgumentException("Coverage type has not been set");
        }
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        resourcePool.clear(info);
        if (info.isEnabled()) {
            LOGGER.finer("Store " + info.getName() + " is enabled, verifying factory availability " + "before saving it...");
            AbstractGridFormat gridFormat = resourcePool.getGridCoverageFormat(info);
            if (gridFormat == null) {
                throw new IllegalArgumentException("No grid format found capable of connecting to the provided URL. To save the store disable it, and check the required libraries are in place");
            }
            try {
                GridCoverageReader reader = resourcePool.getGridCoverageReader(info, null);
                LOGGER.info("Connection to store " + info.getName() + " validated. Got a " + reader.getClass().getName() + ". Saving store");
                this.doSaveStore(info);
                this.setResponsePage(StorePage.class);
            }
            catch (IOException e) {
                this.confirmSaveOnConnectionFailure(info, requestTarget, e);
            }
            catch (RuntimeException e) {
                this.confirmSaveOnConnectionFailure(info, requestTarget, e);
            }
        } else {
            this.doSaveStore(info);
            this.setResponsePage(StorePage.class);
        }
    }

    private void confirmSaveOnConnectionFailure(final CoverageStoreInfo info, AjaxRequestTarget requestTarget, Exception error) {
        final String exceptionMessage = error.getMessage();
        this.dialog.showOkCancel(requestTarget, new GeoServerDialog.DialogDelegate(){
            boolean accepted = false;

            protected Component getContents(String id) {
                return new StoreConnectionFailedInformationPanel(id, info.getName(), exceptionMessage);
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                CoverageStoreEditPage.this.doSaveStore(info);
                this.accepted = true;
                return true;
            }

            protected boolean onCancel(AjaxRequestTarget target) {
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (this.accepted) {
                    CoverageStoreEditPage.this.setResponsePage(StorePage.class);
                }
            }
        });
    }

    private void doSaveStore(CoverageStoreInfo info) {
        try {
            Catalog catalog = this.getCatalog();
            String prefix = info.getWorkspace().getName();
            NamespaceInfo namespace = catalog.getNamespaceByPrefix(prefix);
            List alreadyConfigured = catalog.getResourcesByStore((StoreInfo)info, CoverageInfo.class);
            for (CoverageInfo coverage : alreadyConfigured) {
                coverage.setNamespace(namespace);
            }
            ResourcePool resourcePool = catalog.getResourcePool();
            resourcePool.clear(info);
            catalog.save((StoreInfo)info);
            for (CoverageInfo coverage : alreadyConfigured) {
                catalog.save((ResourceInfo)coverage);
            }
            LOGGER.finer("Saved store " + info.getName());
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Saving the store for " + info.getURL(), e);
            throw new IllegalArgumentException("Unable to save the store: " + e.getMessage());
        }
    }
}

