/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.LayerDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupEntryPanel;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractLayerGroupPage
extends GeoServerSecuredPage {
    public static final String GROUP = "group";
    IModel lgModel;
    EnvelopePanel envelopePanel;
    CRSPanel crsPanel;
    LayerGroupEntryPanel lgEntryPanel;
    String layerGroupId;

    protected void initUI(LayerGroupInfo layerGroup) {
        this.lgModel = new LayerGroupDetachableModel(layerGroup);
        this.layerGroupId = layerGroup.getId();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.lgModel));
        this.add((Component)form);
        TextField name = new TextField("name");
        name.setRequired(true);
        name.add((IValidator)new GroupNameValidator());
        form.add((Component)name);
        this.envelopePanel = new EnvelopePanel("bounds");
        form.add((Component)this.envelopePanel);
        this.envelopePanel.setRequired(true);
        this.envelopePanel.setOutputMarkupId(true);
        CoordinateReferenceSystem crs = layerGroup.getBounds() != null ? layerGroup.getBounds().getCoordinateReferenceSystem() : null;
        this.crsPanel = crs != null ? new CRSPanel("crs", crs) : new CRSPanel("crs", (IModel)new Model());
        form.add((Component)this.crsPanel);
        this.crsPanel.setOutputMarkupId(true);
        this.crsPanel.setRequired(true);
        form.add((Component)new GeoServerAjaxFormLink("generateBounds"){

            public void onClick(AjaxRequestTarget target, Form form) {
                LayerGroupInfo lg = AbstractLayerGroupPage.this.getCatalog().getFactory().createLayerGroup();
                for (LayerGroupEntry entry : AbstractLayerGroupPage.this.lgEntryPanel.getEntries()) {
                    lg.getLayers().add(entry.getLayer());
                    lg.getStyles().add(entry.getStyle());
                }
                try {
                    CoordinateReferenceSystem crs = AbstractLayerGroupPage.this.crsPanel.getCRS();
                    if (crs != null) {
                        new CatalogBuilder(AbstractLayerGroupPage.this.getCatalog()).calculateLayerGroupBounds(lg, crs);
                    } else {
                        new CatalogBuilder(AbstractLayerGroupPage.this.getCatalog()).calculateLayerGroupBounds(lg);
                    }
                    AbstractLayerGroupPage.this.envelopePanel.setModelObject(lg.getBounds());
                    target.addComponent((Component)AbstractLayerGroupPage.this.envelopePanel);
                    if (crs == null) {
                        AbstractLayerGroupPage.this.crsPanel.setModelObject(lg.getBounds().getCoordinateReferenceSystem());
                        target.addComponent((Component)AbstractLayerGroupPage.this.crsPanel);
                    }
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        });
        this.lgEntryPanel = new LayerGroupEntryPanel("layers", layerGroup);
        form.add((Component)this.lgEntryPanel);
        form.add((Component)new SubmitLink("save"){

            public void onSubmit() {
                if (AbstractLayerGroupPage.this.lgEntryPanel.getEntries().size() == 0) {
                    this.error((Serializable)((Object)((String)new ParamResourceModel("oneLayerMinimum", (Component)this.getPage(), new Object[0]).getObject())));
                    return;
                }
                LayerGroupInfo lg = (LayerGroupInfo)AbstractLayerGroupPage.this.lgModel.getObject();
                lg.getLayers().clear();
                lg.getStyles().clear();
                for (LayerGroupEntry entry : AbstractLayerGroupPage.this.lgEntryPanel.getEntries()) {
                    lg.getLayers().add(entry.getLayer());
                    lg.getStyles().add(entry.getStyle());
                }
                AbstractLayerGroupPage.this.onSubmit();
            }
        });
        form.add((Component)new BookmarkablePageLink("cancel", LayerGroupPage.class));
    }

    protected abstract void onSubmit();

    class GroupNameValidator
    extends AbstractValidator {
        GroupNameValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            String name = (String)validatable.getValue();
            LayerGroupInfo other = AbstractLayerGroupPage.this.getCatalog().getLayerGroupByName(name);
            if (!(other == null || AbstractLayerGroupPage.this.layerGroupId != null && other.getId().equals(AbstractLayerGroupPage.this.layerGroupId))) {
                this.error(validatable, "duplicateGroupNameError", Collections.singletonMap("name", name));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class LayerListPanel
    extends GeoServerTablePanel<LayerInfo> {
        static GeoServerDataProvider.Property<LayerInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerInfo>("name", "name");
        static GeoServerDataProvider.Property<LayerInfo> STORE = new GeoServerDataProvider.BeanProperty<LayerInfo>("store", "resource.store.name");
        static GeoServerDataProvider.Property<LayerInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerInfo>("workspace", "resource.store.workspace.name");

        LayerListPanel(String id) {
            super(id, new GeoServerDataProvider<LayerInfo>(){

                @Override
                protected List<LayerInfo> getItems() {
                    return this.getCatalog().getLayers();
                }

                @Override
                protected List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
                    return Arrays.asList(NAME, STORE, WORKSPACE);
                }

                public IModel model(Object object) {
                    return new LayerDetachableModel((LayerInfo)object);
                }
            });
            this.getTopPager().setVisible(false);
        }

        @Override
        protected Component getComponentForProperty(String id, final IModel itemModel, GeoServerDataProvider.Property<LayerInfo> property) {
            IModel model = property.getModel(itemModel);
            if (NAME == property) {
                return new SimpleAjaxLink(id, model){

                    protected void onClick(AjaxRequestTarget target) {
                        LayerInfo layer = (LayerInfo)itemModel.getObject();
                        LayerListPanel.this.handleLayer(layer, target);
                    }
                };
            }
            return new Label(id, model);
        }

        protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class StyleListPanel
    extends GeoServerTablePanel<StyleInfo> {
        static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty<StyleInfo>("name", "name");

        public StyleListPanel(String id) {
            super(id, new GeoServerDataProvider<StyleInfo>(){

                @Override
                protected List<StyleInfo> getItems() {
                    return this.getCatalog().getStyles();
                }

                @Override
                protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
                    return Arrays.asList(NAME);
                }

                public IModel model(Object object) {
                    return new StyleDetachableModel((StyleInfo)object);
                }
            });
            this.getTopPager().setVisible(false);
        }

        @Override
        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
            final StyleInfo style = (StyleInfo)itemModel.getObject();
            if (property == NAME) {
                return new SimpleAjaxLink(id, NAME.getModel(itemModel)){

                    public void onClick(AjaxRequestTarget target) {
                        StyleListPanel.this.handleStyle(style, target);
                    }
                };
            }
            return null;
        }

        protected abstract void handleStyle(StyleInfo var1, AjaxRequestTarget var2);
    }
}

