/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.admin.ServerAdminPage;

public class GlobalSettingsPage
extends ServerAdminPage {
    private static final long serialVersionUID = 4716657682337915996L;
    static final List<String> DEFAULT_LOG_PROFILES = Arrays.asList("DEFAULT_LOGGING.properties", "VERBOSE_LOGGING.properties", "PRODUCTION_LOGGING.properties", "GEOTOOLS_DEVELOPER_LOGGING.properties", "GEOSERVER_DEVELOPER_LOGGING.properties");

    public GlobalSettingsPage() {
        final IModel globalInfoModel = this.getGlobalInfoModel();
        final IModel loggingInfoModel = this.getLoggingInfoModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)globalInfoModel));
        this.add((Component)form);
        form.add((Component)new CheckBox("verbose"));
        form.add((Component)new CheckBox("verboseExceptions"));
        form.add((Component)new TextField("numDecimals"));
        form.add((Component)new TextField("charset"));
        form.add((Component)new TextField("proxyBaseUrl"));
        this.logLevelsAppend(form, loggingInfoModel);
        form.add((Component)new CheckBox("stdOutLogging", (IModel)new PropertyModel((Object)loggingInfoModel, "stdOutLogging")));
        form.add((Component)new TextField("loggingLocation", (IModel)new PropertyModel((Object)loggingInfoModel, "location")));
        form.add((Component)new TextField("featureTypeCacheSize"));
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = GlobalSettingsPage.this.getGeoServer();
                gs.save((GeoServerInfo)globalInfoModel.getObject());
                gs.save((LoggingInfo)loggingInfoModel.getObject());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)submit);
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add((Component)cancel);
    }

    private void logLevelsAppend(Form form, IModel loggingInfoModel) {
        GeoServerResourceLoader loader = GeoServerApplication.get().getBeanOfType(GeoServerResourceLoader.class);
        List<String> logProfiles = null;
        try {
            File logsDirectory = loader.find("logs");
            if (logsDirectory.exists() && logsDirectory.isDirectory()) {
                String[] propFiles = logsDirectory.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith("logging.properties");
                    }
                });
                logProfiles = Arrays.asList(propFiles);
                Collections.sort(logProfiles, String.CASE_INSENSITIVE_ORDER);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not load the list of log configurations from the data directory", e);
        }
        if (logProfiles == null || logProfiles.size() == 0) {
            logProfiles = DEFAULT_LOG_PROFILES;
        }
        form.add((Component)new ListChoice("log4jConfigFile", (IModel)new PropertyModel((Object)loggingInfoModel, "level"), logProfiles));
    }
}

