/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.WrappingFeatureListener;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetypingFeatureSource
implements FeatureSource<SimpleFeatureType, SimpleFeature> {
    FeatureSource<SimpleFeatureType, SimpleFeature> wrapped;
    FeatureTypeMap typeMap;
    RetypingDataStore store;
    Map listeners = new HashMap();

    RetypingFeatureSource(RetypingDataStore ds, FeatureSource<SimpleFeatureType, SimpleFeature> wrapped, FeatureTypeMap typeMap) {
        this.store = ds;
        this.wrapped = wrapped;
        this.typeMap = typeMap;
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public void addFeatureListener(FeatureListener listener) {
        WrappingFeatureListener wrapper = new WrappingFeatureListener(this, listener);
        this.listeners.put(listener, wrapper);
        this.wrapped.addFeatureListener((FeatureListener)wrapper);
    }

    public void removeFeatureListener(FeatureListener listener) {
        FeatureListener wrapper = (FeatureListener)this.listeners.get(listener);
        if (wrapper != null) {
            this.wrapped.removeFeatureListener(wrapper);
            this.listeners.remove(listener);
        }
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.wrapped.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.wrapped.getBounds(this.store.retypeQuery(query, this.typeMap));
    }

    public int getCount(Query query) throws IOException {
        return this.wrapped.getCount(this.store.retypeQuery(query, this.typeMap));
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException {
        if (query.getTypeName() == null) {
            query = new DefaultQuery(query);
            ((DefaultQuery)query).setTypeName(this.typeMap.getName());
        } else if (!this.typeMap.getName().equals(query.getTypeName())) {
            throw new IOException("Cannot query this feature source with " + query.getTypeName() + " since it serves only " + this.typeMap.getName());
        }
        SimpleFeatureType target = this.typeMap.getFeatureType();
        if (query.getPropertyNames() != Query.ALL_NAMES) {
            target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)target, (String[])query.getPropertyNames());
        }
        return new RetypingFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)this.wrapped.getFeatures(this.store.retypeQuery(query, this.typeMap)), target);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(this.typeMap.getName(), filter));
    }

    public SimpleFeatureType getSchema() {
        return this.typeMap.getFeatureType();
    }

    public Set getSupportedHints() {
        return this.wrapped.getSupportedHints();
    }

    public ResourceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.wrapped.getQueryCapabilities();
    }
}

