/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

class FidTransformeVisitor
extends DuplicatingFilterVisitor {
    private Object featureType;
    private FeatureTypeMap map;

    public FidTransformeVisitor(FeatureTypeMap map) {
        super(CommonFactoryFinder.getFilterFactory2(null));
        this.map = map;
    }

    public Object visit(Id filter, Object extraData) {
        Set ids = filter.getIDs();
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Invalid fid filter provides, has no fids inside");
        }
        Object external = null;
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            FeatureIdImpl id = new FeatureIdImpl((String)it.next());
            FeatureId retyped = RetypingFeatureCollection.reTypeId((FeatureId)id, this.map.getFeatureType(), this.map.getOriginalFeatureType());
            fids.add(retyped);
        }
        return this.ff.id(fids);
    }
}

