/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.requests.CoverageRequest;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class CoverageResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final Hints hints = new Hints();
    CoverageResponseDelegate delegate;
    private CoverageRequest request = null;

    public HashMap getResponseHeaders() {
        return null;
    }

    public String getContentType(GeoServer geoServer) {
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public String getContentDisposition() {
        return this.delegate.getContentDisposition();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.request == null || this.delegate == null) {
            throw new IllegalStateException("execute has not been called prior to writeTo");
        }
        this.delegate.encode(out);
    }

    public void execute(Request req) throws WcsException {
        this.execute((CoverageRequest)req);
    }

    public void execute(CoverageRequest request) throws WcsException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(new StringBuffer("execute CoverageRequest response. Called request is: ").append((Object)request).toString());
        }
        this.request = request;
        String outputFormat = request.getOutputFormat();
        this.delegate = CoverageResponseDelegateFactory.encoderFor(outputFormat);
        if (this.delegate == null) {
            throw new WcsException("Output format: " + outputFormat + " not supported by geoserver " + "for this Coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
        Catalog catalog = request.getWCS().getGeoServer().getCatalog();
        CoverageInfo meta = null;
        Object coverage = null;
        try {
            meta = catalog.getCoverageByName(request.getCoverage());
            if (!meta.getSupportedFormats().contains(outputFormat.toUpperCase())) {
                WcsException newEx = new WcsException(new StringBuffer("output format: ").append(outputFormat).append(" not ").append("supported by geoserver for this Coverage").toString());
                throw newEx;
            }
            AbstractGridFormat format = meta.getStore().getFormat();
            AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(meta.getStore(), hints);
            ParameterValueGroup params = reader.getFormat().getReadParameters();
            GridCoverage2D finalCoverage = CoverageResponse.getFinalCoverage(request, meta, reader, CoverageUtils.getParametersKVP((ParameterValueGroup)params));
            this.delegate.prepare(outputFormat, finalCoverage);
        }
        catch (IOException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (NoSuchElementException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (IllegalArgumentException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (SecurityException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (WcsException e) {
            WcsException newEx = new WcsException((Throwable)((Object)e), "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (FactoryException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (IndexOutOfBoundsException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
        catch (TransformException e) {
            WcsException newEx = new WcsException(e, "problem with CoverageResults", request.getHandle());
            throw newEx;
        }
    }

    public void abort(ServiceInfo gs) {
        if (this.request == null) {
            return;
        }
    }

    private static GridCoverage2D getFinalCoverage(CoverageRequest request, CoverageInfo meta, AbstractGridCoverage2DReader coverageReader, Map parameters) throws WcsException, IOException, IndexOutOfBoundsException, FactoryException, TransformException {
        GridCoverage2D croppedGridCoverage;
        String responseCRS = request.getResponseCRS();
        if (!meta.getResponseSRS().contains(responseCRS)) {
            throw new WcsException("This Coverage does not support the requested Response-CRS.");
        }
        CoordinateReferenceSystem targetCRS = CRS.decode((String)responseCRS);
        String requestCRS = request.getCRS();
        if (!meta.getResponseSRS().contains(requestCRS)) {
            throw new WcsException("This Coverage does not support the requested CRS.");
        }
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)requestCRS);
        CoordinateReferenceSystem cvCRS = coverageReader.getOriginalEnvelope().getCoordinateReferenceSystem();
        MathTransform GCCRSTodeviceCRSTransformdeviceCRSToGCCRSTransform = CRS.findMathTransform((CoordinateReferenceSystem)cvCRS, (CoordinateReferenceSystem)sourceCRS, (boolean)true);
        MathTransform GCCRSTodeviceCRSTransform = CRS.findMathTransform((CoordinateReferenceSystem)cvCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        MathTransform deviceCRSToGCCRSTransform = GCCRSTodeviceCRSTransformdeviceCRSToGCCRSTransform.inverse();
        Envelope envelope = request.getEnvelope();
        boolean lonFirst = sourceCRS.getCoordinateSystem().getAxis(0).getDirection().absolute().equals((Object)AxisDirection.EAST);
        GeneralEnvelope destinationEnvelope = !lonFirst ? new GeneralEnvelope(new double[]{envelope.getMinY(), envelope.getMinX()}, new double[]{envelope.getMaxY(), envelope.getMaxX()}) : new GeneralEnvelope(new double[]{envelope.getMinX(), envelope.getMinY()}, new double[]{envelope.getMaxX(), envelope.getMaxY()});
        destinationEnvelope.setCoordinateReferenceSystem(sourceCRS);
        GeneralEnvelope destinationEnvelopeInSourceCRS = !deviceCRSToGCCRSTransform.isIdentity() ? CRS.transform((MathTransform)deviceCRSToGCCRSTransform, (org.opengis.geometry.Envelope)destinationEnvelope) : new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelope);
        destinationEnvelopeInSourceCRS.setCoordinateReferenceSystem(cvCRS);
        Rectangle destinationSize = null;
        if (request.getGridLow() == null || request.getGridHigh() == null) {
            throw new WcsException("Neither Grid Size nor Grid Resolution have been specified.");
        }
        int[] lowers = new int[]{request.getGridLow()[0].intValue(), request.getGridLow()[1].intValue()};
        int[] highers = new int[]{request.getGridHigh()[0].intValue(), request.getGridHigh()[1].intValue()};
        destinationSize = new Rectangle(lowers[0], lowers[1], highers[0], highers[1]);
        Interpolation interpolation = Interpolation.getInstance((int)0);
        String interpolationType = request.getInterpolation();
        if (interpolationType != null) {
            boolean interpolationSupported = false;
            Iterator internal = meta.getInterpolationMethods().iterator();
            while (internal.hasNext()) {
                if (!interpolationType.equalsIgnoreCase((String)internal.next())) continue;
                interpolationSupported = true;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.");
            }
            if (interpolationType.equalsIgnoreCase("bilinear")) {
                interpolation = Interpolation.getInstance((int)1);
            } else if (interpolationType.equalsIgnoreCase("bicubic")) {
                interpolation = Interpolation.getInstance((int)2);
            }
        }
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)new GeneralGridEnvelope(destinationSize), (org.opengis.geometry.Envelope)destinationEnvelopeInSourceCRS));
        GridCoverage2D coverage = coverageReader.read(CoverageUtils.getParameters((ParameterValueGroup)coverageReader.getFormat().getReadParameters(), (Map)parameters, (boolean)true));
        if (coverage == null || !(coverage instanceof GridCoverage2D)) {
            throw new IOException("The requested coverage could not be found.");
        }
        Coverage bandSelectedCoverage = null;
        bandSelectedCoverage = WCSUtils.bandSelect(request.getParameters(), (GridCoverage)coverage);
        GridCoverage2D subCoverage = croppedGridCoverage = WCSUtils.crop(bandSelectedCoverage, (GeneralEnvelope)coverage.getEnvelope(), cvCRS, destinationEnvelopeInSourceCRS, Boolean.TRUE);
        GeneralGridEnvelope newGridrange = new GeneralGridEnvelope(destinationSize);
        subCoverage = WCSUtils.scale(croppedGridCoverage, (GridEnvelope)newGridrange, (GridCoverage)croppedGridCoverage, cvCRS, destinationEnvelopeInSourceCRS);
        subCoverage = WCSUtils.reproject(subCoverage, sourceCRS, targetCRS, interpolation);
        return subCoverage;
    }

    static {
        hints.add((RenderingHints)LENIENT_HINT);
    }
}

